/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.MultifileClassCodegenImpl;
import org.jetbrains.kotlin.codegen.PackageCodegenImpl;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "()V", "createMultifileClassCodegen", "Lorg/jetbrains/kotlin/codegen/MultifileClassCodegenImpl;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "createPackageCodegen", "Lorg/jetbrains/kotlin/codegen/PackageCodegenImpl;", "generateModule", "", "generateMultifileClass", "multifileClassFqName", "generatePackage", "packageFqName", "jetFiles", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    public static final DefaultCodegenFactory INSTANCE;

    @Override
    public void generateModule(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile ktFile : files2) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), ktFile);
                continue;
            }
            filesInPackages.putValue(ktFile.getPackageFqName(), ktFile);
        }
        HashSet hashSet = new HashSet(state.getObsoleteMultifileClasses());
        Set set = filesInMultifileClasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"filesInMultifileClasses.keySet()");
        for (FqName multifileClassFqName : SetsKt.plus(set, (Iterable)hashSet)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            FqName fqName2 = multifileClassFqName;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"multifileClassFqName");
            Collection collection = filesInMultifileClasses.get(multifileClassFqName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"filesInMultifileClasses.get(multifileClassFqName)");
            this.generateMultifileClass(state, fqName2, collection);
        }
        HashSet packagesWithObsoleteParts = new HashSet(state.getPackagesWithObsoleteParts());
        Set set2 = packagesWithObsoleteParts;
        Set set3 = filesInPackages.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"filesInPackages.keySet()");
        for (FqName packageFqName : SetsKt.plus((Set)set2, (Iterable)set3)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            FqName fqName3 = packageFqName;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"packageFqName");
            Collection collection = filesInPackages.get(packageFqName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"filesInPackages.get(packageFqName)");
            this.generatePackage(state, fqName3, collection);
        }
    }

    @Override
    @NotNull
    public PackageCodegenImpl createPackageCodegen(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return new PackageCodegenImpl(state, files2, fqName2);
    }

    @Override
    @NotNull
    public MultifileClassCodegenImpl createMultifileClassCodegen(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return new MultifileClassCodegenImpl(state, files2, fqName2);
    }

    private final void generateMultifileClass(GenerationState state, FqName multifileClassFqName, Collection<? extends KtFile> files2) {
        state.getFactory().forMultifileClass(multifileClassFqName, files2).generate();
    }

    public final void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> jetFiles) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(jetFiles, (String)"jetFiles");
        state.getFactory().forPackage(packageFqName, jetFiles).generate();
    }

    private DefaultCodegenFactory() {
    }

    static {
        DefaultCodegenFactory defaultCodegenFactory;
        INSTANCE = defaultCodegenFactory = new DefaultCodegenFactory();
    }
}

