/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\r\u0010#\u001a\u00020\u000e*\u00020\u0016H\u0082\u0010J\u0014\u0010$\u001a\u00020\u0016*\u00020\u00162\u0006\u0010%\u001a\u00020\u0019H\u0014J\u0014\u0010&\u001a\u00020\u0016*\u00020\u00162\u0006\u0010'\u001a\u00020\u0012H\u0014J\u0014\u0010(\u001a\u00020\u0016*\u00020\u00162\u0006\u0010'\u001a\u00020\u0012H\u0014J\u001c\u0010)\u001a\u00020\u0016*\u00020\u00162\u0006\u0010'\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u000fH\u0014J\u0014\u0010+\u001a\u00020\u0016*\u00020\u00162\u0006\u0010'\u001a\u00020,H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\t*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AutoboxingTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "callTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getCallTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isDispatchReceiver", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;)Z", "target", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildSafeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arg", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "resultType", "call", "Lkotlin/Function1;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isGetUnit", "useAs", "type", "useAsDispatchReceiver", "expression", "useAsExtensionReceiver", "useAsValueArgument", "parameter", "useAsVarargElement", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "backend.js"})
public final class AutoboxingTransformer
extends AbstractValueUsageTransformer
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrDeclarationParent irDeclarationParent;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (container.getParent() instanceof IrFunction) {
            return;
        }
        IrStatement irStatement = container.transform(this, null);
        if (irStatement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration replacement = (IrDeclaration)irStatement;
        if (container != replacement) {
            String string2 = "Declaration has changed: " + container;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrElement irElement = irBody;
        IrDeclaration irDeclaration2 = container;
        if (!(irDeclaration2 instanceof IrDeclarationParent)) {
            irDeclaration2 = null;
        }
        if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration2)) == null) {
            irDeclarationParent = container.getParent();
        }
        PatchDeclarationParentsKt.patchDeclarationParents(irElement, irDeclarationParent);
    }

    private final boolean isGetUnit(IrExpression $this$isGetUnit) {
        boolean bl;
        block2: {
            IrExpression irExpression;
            while ((irExpression = $this$isGetUnit) instanceof IrContainerExpression) {
                IrStatement lastStmt = (IrStatement)CollectionsKt.lastOrNull(((IrContainerExpression)$this$isGetUnit).getStatements());
                if (lastStmt instanceof IrExpression) {
                    $this$isGetUnit = (IrExpression)lastStmt;
                    continue;
                }
                bl = false;
                break block2;
            }
            bl = irExpression instanceof IrGetObjectValue ? Intrinsics.areEqual((Object)((IrGetObjectValue)$this$isGetUnit).getSymbol(), (Object)this.getIrBuiltIns().getUnitClass()) : false;
        }
        return bl;
    }

    @Override
    @NotNull
    protected IrExpression useAs(@NotNull IrExpression $this$useAs, @NotNull IrType type2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrType actualType;
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$useAs, (String)"$this$useAs");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrExpression irExpression = $this$useAs;
        if (irExpression instanceof IrConstructorCall) {
            irType = ((IrConstructor)((IrConstructorCall)$this$useAs).getSymbol().getOwner()).getReturnType();
        } else if (irExpression instanceof IrCall) {
            irType = IrResolveUtilsKt.getRealOverrideTarget(((IrCall)$this$useAs).getSymbol().getOwner()).getReturnType();
        } else if (irExpression instanceof IrGetField) {
            irType = ((IrField)((IrGetField)$this$useAs).getSymbol().getOwner()).getType();
        } else if (irExpression instanceof IrTypeOperatorCall) {
            boolean bl = ((IrTypeOperatorCall)$this$useAs).getOperator() == IrTypeOperator.REINTERPRET_CAST;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AutoboxingTransformer$useAs$actualType$22 = false;
                String $i$a$-assert-AutoboxingTransformer$useAs$actualType$22 = "Only REINTERPRET_CAST expected at this point";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AutoboxingTransformer$useAs$actualType$22));
            }
            irType = ((IrTypeOperatorCall)$this$useAs).getTypeOperand();
        } else {
            IrValueDeclaration value2;
            irType = irExpression instanceof IrGetValue ? ((value2 = ((IrGetValue)$this$useAs).getSymbol().getOwner()) instanceof IrValueParameter && this.isDispatchReceiver((IrValueParameter)value2) ? this.getIrBuiltIns().getAnyNType() : $this$useAs.getType()) : (actualType = $this$useAs.getType());
        }
        if (IrTypePredicatesKt.isNothing(IrTypesKt.makeNotNull(actualType))) {
            return $this$useAs;
        }
        IrType expectedType2 = type2;
        if (IrTypePredicatesKt.isUnit(actualType) && !IrTypePredicatesKt.isUnit(expectedType2) && !this.isGetUnit($this$useAs)) {
            IrGetObjectValueImpl unitValue = JsIrBuilder.INSTANCE.buildGetObjectValue(actualType, this.context.getIrBuiltIns().getUnitClass());
            return JsIrBuilder.INSTANCE.buildComposite(actualType, CollectionsKt.listOf((Object[])new IrExpression[]{$this$useAs, unitValue}));
        }
        IrClass actualInlinedClass = InlineClassesKt.getInlinedClass(actualType);
        IrClass expectedInlinedClass = InlineClassesKt.getInlinedClass(expectedType2);
        if (actualType instanceof IrDynamicType && IrTypePredicatesKt.isChar(IrTypesKt.makeNotNull(expectedType2)) || IrTypePredicatesKt.isChar(IrTypesKt.makeNotNull(actualType)) && expectedType2 instanceof IrDynamicType) {
            return $this$useAs;
        }
        if (actualInlinedClass == null && expectedInlinedClass == null) {
            return $this$useAs;
        }
        if (actualInlinedClass != null && expectedInlinedClass == null) {
            irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBoxIntrinsic();
        } else if (actualInlinedClass == null && expectedInlinedClass != null) {
            irSimpleFunctionSymbol = this.context.getIntrinsics().getJsUnboxIntrinsic();
        } else {
            return $this$useAs;
        }
        IrSimpleFunctionSymbol function2 = irSimpleFunctionSymbol;
        return this.buildSafeCall($this$useAs, actualType, expectedType2, (Function1<? super IrExpression, ? extends IrExpression>)((Function1)new Function1<IrExpression, IrExpression>(function2, expectedType2, actualType){
            final /* synthetic */ IrSimpleFunctionSymbol $function;
            final /* synthetic */ IrType $expectedType;
            final /* synthetic */ IrType $actualType;

            @NotNull
            public final IrExpression invoke(@NotNull IrExpression arg) {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                IrCall irCall = JsIrBuilder.INSTANCE.buildCall(this.$function, this.$expectedType, CollectionsKt.listOf((Object[])new IrType[]{this.$actualType, this.$expectedType}));
                boolean bl = false;
                boolean bl2 = false;
                IrCall it = irCall;
                boolean bl3 = false;
                it.putValueArgument(0, arg);
                return irCall;
            }
            {
                this.$function = irSimpleFunctionSymbol;
                this.$expectedType = irType;
                this.$actualType = irType2;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSafeCall(IrExpression arg, IrType actualType, IrType resultType, Function1<? super IrExpression, ? extends IrExpression> call2) {
        void $this$apply;
        if (!IrTypeUtilsKt.isNullable(actualType)) {
            return (IrExpression)call2.invoke((Object)arg);
        }
        JsIrBuilder jsIrBuilder = JsIrBuilder.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsIrBuilder $this$run = jsIrBuilder;
        boolean bl3 = false;
        IrVariable tmp = JsIrBuilder.buildVar$default($this$run, actualType, null, null, false, false, false, arg, 60, null);
        IrCall irCall = JsIrBuilder.buildCall$default($this$run, this.getIrBuiltIns().getEqeqSymbol(), null, null, 6, null);
        boolean bl4 = false;
        boolean bl5 = false;
        IrCall irCall2 = irCall;
        IrType irType = resultType;
        JsIrBuilder jsIrBuilder2 = $this$run;
        boolean bl6 = false;
        $this$apply.putValueArgument(0, $this$run.buildGetValue((IrValueSymbol)tmp.getSymbol()));
        $this$apply.putValueArgument(1, $this$run.buildNull(this.getIrBuiltIns().getNothingNType()));
        Unit unit = Unit.INSTANCE;
        IrWhen nullCheck = jsIrBuilder2.buildIfElse(irType, irCall, $this$run.buildNull(this.getIrBuiltIns().getNothingNType()), (IrExpression)call2.invoke((Object)$this$run.buildGetValue((IrValueSymbol)tmp.getSymbol())));
        return $this$run.buildBlock(resultType, CollectionsKt.listOf((Object[])new IrStatement[]{tmp, nullCheck}));
    }

    private final IrFunction getTarget(IrFunctionAccessExpression $this$target) {
        Object object;
        IrFunctionAccessExpression irFunctionAccessExpression = $this$target;
        if (irFunctionAccessExpression instanceof IrConstructorCall) {
            object = ((IrConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrDelegatingConstructorCall) {
            object = ((IrDelegatingConstructorCall)$this$target).getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrCall) {
            object = this.getCallTarget((IrCall)$this$target);
        } else {
            String string2 = RenderIrElementKt.render($this$target);
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return object;
    }

    private final IrFunction getCallTarget(IrCall $this$callTarget) {
        return IrResolveUtilsKt.getRealOverrideTarget($this$callTarget.getSymbol().getOwner());
    }

    @Override
    @NotNull
    protected IrExpression useAsDispatchReceiver(@NotNull IrExpression $this$useAsDispatchReceiver, @NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsDispatchReceiver, (String)"$this$useAsDispatchReceiver");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueParameter irValueParameter = this.getTarget(expression2).getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        return this.useAsArgument($this$useAsDispatchReceiver, irValueParameter);
    }

    @Override
    @NotNull
    protected IrExpression useAsExtensionReceiver(@NotNull IrExpression $this$useAsExtensionReceiver, @NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsExtensionReceiver, (String)"$this$useAsExtensionReceiver");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueParameter irValueParameter = this.getTarget(expression2).getExtensionReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        return this.useAsArgument($this$useAsExtensionReceiver, irValueParameter);
    }

    @Override
    @NotNull
    protected IrExpression useAsValueArgument(@NotNull IrExpression $this$useAsValueArgument, @NotNull IrFunctionAccessExpression expression2, @NotNull IrValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsValueArgument, (String)"$this$useAsValueArgument");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.useAsArgument($this$useAsValueArgument, this.getTarget(expression2).getValueParameters().get(parameter.getIndex()));
    }

    @Override
    @NotNull
    protected IrExpression useAsVarargElement(@NotNull IrExpression $this$useAsVarargElement, @NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsVarargElement, (String)"$this$useAsVarargElement");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.useAs($this$useAsVarargElement, InlineClassesKt.isInlined($this$useAsVarargElement.getType()) && !InlineClassesKt.isInlined(expression2.getType()) && !org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isPrimitiveArray(expression2.getType()) ? this.getIrBuiltIns().getAnyNType() : expression2.getVarargElementType());
    }

    private final boolean isDispatchReceiver(IrValueParameter $this$isDispatchReceiver) {
        IrDeclarationParent parent2 = $this$isDispatchReceiver.getParent();
        if (parent2 instanceof IrClass) {
            return true;
        }
        return parent2 instanceof IrFunction && Intrinsics.areEqual((Object)((IrFunction)parent2).getDispatchReceiverParameter(), (Object)$this$isDispatchReceiver);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public AutoboxingTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2.getIrBuiltIns());
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

