/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0013H\u0007J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "checkDeprecatedWhenSyntax", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkDuplicatedLabels", "checkReservedPrefix", "containsNullCase", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfSealed", "getClassIdForEnumSubject", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassIdForTypeIfEnum", "getEnumMissingCases", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "enumClassDescriptor", "getMissingCases", "getSealedMissingCases", "sealedClassDescriptor", "isWhenExhaustive", "whenSubjectType", "whenSubjectTypeWithoutSmartCasts", "frontend"})
public final class WhenChecker {
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;
    public static final WhenChecker INSTANCE;

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForEnumSubject(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return WhenChecker.getClassIdForTypeIfEnum(WhenChecker.whenSubjectType(expression2, context2));
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForTypeIfEnum(@Nullable KotlinType type2) {
        ClassDescriptor classDescriptor2 = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        return classDescriptor2 != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor2) : null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"TypeUtils.getClassDescriptor(type) ?: return null");
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (classDescriptor3.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type2) {
        KotlinType kotlinType = type2;
        Annotated annotated = kotlinType;
        if (kotlinType == null) return null;
        KotlinType kotlinType2 = annotated;
        boolean bl = false;
        boolean bl2 = false;
        KotlinType it = kotlinType2;
        boolean bl3 = false;
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(it);
        annotated = classDescriptor2;
        if (classDescriptor2 == null) return null;
        kotlinType2 = annotated;
        bl = false;
        bl2 = false;
        it = kotlinType2;
        boolean bl4 = false;
        if (!DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)it))) return null;
        KotlinType kotlinType3 = kotlinType2;
        return kotlinType3;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context2.get(BindingContext.VARIABLE, subjectVariable);
            object = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else if (subjectExpression != null) {
            object = (ExplicitSmartCasts)context2.get(BindingContext.SMARTCAST, subjectExpression);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context2.getType(subjectExpression);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final KotlinType whenSubjectTypeWithoutSmartCasts(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context2.get(BindingContext.VARIABLE, subjectVariable);
            kotlinType = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else {
            kotlinType = subjectExpression != null ? context2.getType(subjectExpression) : null;
        }
        return kotlinType;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)enumClassDescriptor, (String)"enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sealedClassDescriptor, (String)"sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, sealedClassDescriptor, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        void $this$mapTo$iv$iv;
        WhenExhaustivenessChecker it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context2);
        if (kotlinType == null) {
            return CollectionsKt.listOf((Object)UnknownMissingCase.INSTANCE);
        }
        KotlinType type2 = kotlinType;
        boolean nullable = type2.isMarkedNullable();
        Iterable $this$filter$iv = exhaustivenessCheckers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf((Object)UnknownMissingCase.INSTANCE);
        }
        Iterable $this$map$iv = checkers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<WhenMissingCase> list2 = it.getMissingCases(expression2, context2, TypeUtils.getClassDescriptor(type2), nullable);
            collection.add(list2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        if (INSTANCE.getMissingCases(expression2, bindingContext).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        HashSet checkedConstants = new HashSet();
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) continue;
            for (KtWhenCondition condition : entry.getConditions()) {
                KotlinType type2;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition).getExpression() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)constantExpression, (String)"condition.expression ?: continue@conditions");
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    if (ConstantExpressionEvaluator.Companion.getConstant(constantExpression, bindingContext) == null) {
                        continue;
                    }
                    if (checkedConstants.contains(constant)) {
                        trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(constantExpression));
                        continue;
                    }
                    checkedConstants.add(constant);
                    continue;
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern)) continue;
                if (((KtWhenConditionIsPattern)condition).getTypeReference() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"condition.typeReference ?: continue@conditions");
                if ((KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"trace.get(BindingContext\u2026e) ?: continue@conditions");
                Pair typeWithIsNegation = TuplesKt.to((Object)type2, (Object)((KtWhenConditionIsPattern)condition).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        block0: while (iterator2.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                ASTNode aSTNode = child.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"child.node");
                if (aSTNode.getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                ASTNode aSTNode2 = child.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"child.node");
                if (aSTNode2.getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkReservedPrefix(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        DiagnosticSink diagnosticSink = trace;
        PsiElement psiElement = expression2.getWhenKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.whenKeyword");
        ReservedCheckingKt.checkReservedPrefixWord(diagnosticSink, psiElement, "sealed", "sealed when");
    }

    private WhenChecker() {
    }

    static {
        WhenChecker whenChecker;
        INSTANCE = whenChecker = new WhenChecker();
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE});
    }
}

