/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker;", "", "()V", "checkSupertypes", "", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "reportOn", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "classifierType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ForCalls", "ForDeclarations", "frontend"})
public final class MissingDependencySupertypeChecker {
    public static final MissingDependencySupertypeChecker INSTANCE;

    public final boolean checkSupertypes(@NotNull KotlinType classifierType, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter((Object)classifierType, (String)"classifierType");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)missingSupertypesResolver, (String)"missingSupertypesResolver");
        return this.checkSupertypes(classifierType.getConstructor().getDeclarationDescriptor(), reportOn, trace, missingSupertypesResolver);
    }

    public final boolean checkSupertypes(@Nullable DeclarationDescriptor declaration2, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)missingSupertypesResolver, (String)"missingSupertypesResolver");
        if (!(declaration2 instanceof ClassifierDescriptor)) {
            return false;
        }
        Set<ClassifierDescriptor> missingSupertypes = missingSupertypesResolver.getMissingSuperClassifiers((ClassifierDescriptor)declaration2);
        for (ClassifierDescriptor missingClassifier : missingSupertypes) {
            trace.report(Errors.MISSING_DEPENDENCY_SUPERCLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(missingClassifier), DescriptorUtilsKt.getFqNameSafe(declaration2)));
        }
        Collection collection = missingSupertypes;
        boolean bl = false;
        return !collection.isEmpty();
    }

    private MissingDependencySupertypeChecker() {
    }

    static {
        MissingDependencySupertypeChecker missingDependencySupertypeChecker;
        INSTANCE = missingDependencySupertypeChecker = new MissingDependencySupertypeChecker();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForDeclarations;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class ForDeclarations
    implements DeclarationChecker {
        public static final ForDeclarations INSTANCE;

        @Override
        public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            BindingTrace trace = context2.getTrace();
            if (descriptor2 instanceof ClassDescriptor) {
                INSTANCE.checkSupertypes(descriptor2, (PsiElement)declaration2, trace, context2.getMissingSupertypesResolver());
            }
            if (declaration2 instanceof KtTypeParameterListOwner) {
                for (KtTypeParameter ktTypeParameter : ((KtTypeParameterListOwner)declaration2).getTypeParameters()) {
                    TypeParameterDescriptor typeParameterDescriptor;
                    if ((TypeParameterDescriptor)trace.getBindingContext().get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"trace.bindingContext.get\u2026ypeParameter) ?: continue");
                    Iterator<KotlinType> iterator2 = typeParameterDescriptor.getUpperBounds().iterator();
                    while (iterator2.hasNext()) {
                        KotlinType upperBound;
                        KotlinType kotlinType = upperBound = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"upperBound");
                        KtTypeParameter ktTypeParameter2 = ktTypeParameter;
                        Intrinsics.checkNotNullExpressionValue((Object)ktTypeParameter2, (String)"ktTypeParameter");
                        INSTANCE.checkSupertypes(kotlinType, (PsiElement)ktTypeParameter2, trace, context2.getMissingSupertypesResolver());
                    }
                }
            }
        }

        private ForDeclarations() {
        }

        static {
            ForDeclarations forDeclarations;
            INSTANCE = forDeclarations = new ForDeclarations();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForCalls;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getDeclaration", "(Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
    public static final class ForCalls
    implements CallChecker {
        public static final ForCalls INSTANCE;

        @Override
        public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
            Object descriptor2;
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Object obj = descriptor2 = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, (String)"descriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor = obj.getDispatchReceiverParameter();
            boolean errorReported = INSTANCE.checkSupertypes(receiverParameterDescriptor != null ? this.getDeclaration(receiverParameterDescriptor) : null, reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
            if (!(descriptor2 instanceof ConstructorDescriptor || descriptor2 instanceof FakeCallableDescriptorForObject || errorReported)) {
                INSTANCE.checkSupertypes(descriptor2.getContainingDeclaration(), reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
                ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
                INSTANCE.checkSupertypes(receiverParameterDescriptor2 != null ? this.getDeclaration(receiverParameterDescriptor2) : null, reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
            }
        }

        private final ClassifierDescriptor getDeclaration(ReceiverParameterDescriptor $this$declaration) {
            ReceiverValue receiverValue = $this$declaration.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"value");
            return receiverValue.getType().getConstructor().getDeclarationDescriptor();
        }

        private ForCalls() {
        }

        static {
            ForCalls forCalls;
            INSTANCE = forCalls = new ForCalls();
        }
    }
}

