/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@ApiStatus.Internal
public abstract class ExtensionPointImpl<@NotNull T>
implements ExtensionPoint<T>,
Iterable<T> {
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    private volatile T @Nullable [] myExtensionsCacheAsArray;
    private ComponentManager myComponentManager;
    @NotNull
    protected final PluginDescriptor myDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> myAdapters;
    private volatile boolean myAdaptersIsSorted;
    private ExtensionPointListener<T> @NotNull [] myListeners;
    @Nullable
    Class<T> myExtensionClass;
    private final boolean myDynamic;
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className2, @NotNull PluginDescriptor pluginDescriptor, boolean dynamic) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        this.myAdapters = Collections.emptyList();
        this.myAdaptersIsSorted = true;
        this.myListeners = ExtensionPointListener.EMPTY_ARRAY;
        this.myName = name;
        this.myClassName = className2;
        this.myDescriptor = pluginDescriptor;
        this.myDynamic = dynamic;
    }

    final synchronized void setComponentManager(@NotNull ComponentManager value2) {
        if (value2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.myComponentManager = value2;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public String getClassName() {
        String string2 = this.myClassName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, null);
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, parentDisposable);
    }

    @NotNull
    final PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ExtensionPointImpl.castComponentInstance(adapter) != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, this.getDescriptor(), order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(ExtensionEvent.ADDED, extension, adapter.getPluginDescriptor(), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index2 = ContainerUtil.indexOfIdentity(this.myAdapters, adapter);
                    if (index2 < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.myComponentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list2 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                    list2.remove(index2);
                    this.myAdapters = list2;
                    this.clearCache();
                    this.notifyListeners(ExtensionEvent.REMOVED, adapter.myComponentInstance, adapter.getPluginDescriptor(), this.myListeners);
                }
            });
        }
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        if (!extensionClass.isInstance(extension)) {
            String message2 = "Extension " + extension.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message2 = message2 + " (adapter=" + adapter + ")";
            }
            throw new ExtensionException(message2, extension.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        List<T> result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    T[] array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = result2 = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        List<T> list2 = result2;
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T @NotNull [] getExtensions() {
        T[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    this.myExtensionsCacheAsArray = array = this.processAdapters();
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(22);
        }
        return objectArray;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result2 = this.myExtensionsCache;
        Iterator<T> iterator2 = result2 == null ? this.createIterator() : result2.iterator();
        if (iterator2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        return iterator2;
    }

    @NotNull
    private List<ExtensionComponentAdapter> getThreadSafeAdapterList(boolean failIfListenerAdded) {
        CHECK_CANCELED.run();
        if (!this.myDynamic && this.myListeners.length > 0) {
            String message2 = "Listeners not allowed for extension point " + this.getName();
            if (failIfListenerAdded) {
                LOG.error(message2);
            } else {
                LOG.warn(message2);
                this.getExtensionList();
            }
        }
        return this.getSortedAdapters();
    }

    @NotNull
    private Iterator<T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getThreadSafeAdapterList(true);
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(26);
            }
            return iterator2;
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @NotNull
    public Stream<T> extensions() {
        Stream stream = this.getExtensionList().stream();
        if (stream == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        return stream;
    }

    @Override
    public boolean hasAnyExtensions() {
        List<T> cache2 = this.myExtensionsCache;
        return cache2 == null ? !this.myAdapters.isEmpty() : !cache2.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.myAdaptersIsSorted) {
            List<ExtensionComponentAdapter> list2 = this.myAdapters;
            if (list2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(28);
            }
            return list2;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.myAdaptersIsSorted) {
                List<ExtensionComponentAdapter> list3 = this.myAdapters;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list3 == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(29);
                }
                return list3;
            }
            if (this.myAdapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list4 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                LoadingOrder.sort(list4);
                this.myAdapters = list4;
            }
            this.myAdaptersIsSorted = true;
        }
        List<ExtensionComponentAdapter> list5 = this.myAdapters;
        if (list5 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(30);
        }
        return list5;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result2 = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            if (result2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(31);
            }
            return result2;
        }
        OpenTHashSet duplicates = this instanceof BeanExtensionPoint ? null : new OpenTHashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            T extension = this.processAdapter(adapters.get(i), listeners, result2, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result2[extensionIndex++] = extension;
        }
        if (extensionIndex != result2.length) {
            result2 = Arrays.copyOf(result2, extensionIndex);
        }
        ActivityCategory category = ExtensionPointImpl.getActivityCategory(this.myComponentManager.getPicoContainer());
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        if (result2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        return result2;
    }

    @NotNull
    public abstract ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager var1);

    @NotNull
    private static ActivityCategory getActivityCategory(@NotNull PicoContainer picoContainer) {
        PicoContainer parent2;
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        if ((parent2 = picoContainer.getParent()) == null) {
            ActivityCategory activityCategory = ActivityCategory.APP_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(34);
            }
            return activityCategory;
        }
        if (parent2.getParent() == null) {
            ActivityCategory activityCategory = ActivityCategory.PROJECT_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(35);
            }
            return activityCategory;
        }
        ActivityCategory activityCategory = ActivityCategory.MODULE_EXTENSION;
        if (activityCategory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        return activityCategory;
    }

    private T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        return this.processAdapter(adapter, null, null, null, null, null);
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result2, @Nullable OpenTHashSet<T> duplicates, @Nullable Class<T> extensionClassForCheck, @Nullable List<? extends ExtensionComponentAdapter> adapters) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        try {
            T duplicate;
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated() && !this.myDynamic;
            Object extension = adapter.createInstance(this.myComponentManager);
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = duplicates.get(extension);
                assert (result2 != null);
            } else {
                if (extensionClassForCheck != null) {
                    this.checkExtensionType(extension, extensionClassForCheck, adapter);
                }
                if (isNotifyThatAdded) {
                    this.notifyListeners(ExtensionEvent.ADDED, extension, adapter.getPluginDescriptor(), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result2) + ";\n  adapters:        " + adapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    @Override
    public void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$9(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    public boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        ArrayList<Runnable> listenerCallbacks = new ArrayList<Runnable>();
        boolean result2 = this.unregisterExtensions(extensionClassFilter, stopAfterFirstMatch, listenerCallbacks);
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result2;
    }

    public synchronized boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch, List<Runnable> listenerCallbacks) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        boolean found2 = false;
        ExtensionPointListener[] listeners = this.myListeners;
        SmartList<ExtensionComponentAdapter> removedAdapters = listeners.length > 0 ? new SmartList<ExtensionComponentAdapter>() : null;
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.clearCache();
            if (adapters == this.myAdapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (removedAdapters != null) {
                removedAdapters.add(adapter);
            }
            found2 = true;
            if (stopAfterFirstMatch) break;
        }
        this.myAdapters = adapters;
        if (removedAdapters != null && !removedAdapters.isEmpty()) {
            listenerCallbacks.add(() -> this.notifyListeners(ExtensionEvent.REMOVED, removedAdapters, listeners));
        }
        return found2;
    }

    private void notifyListeners(@NotNull ExtensionEvent event, @NotNull T extensionObject, @NotNull PluginDescriptor pluginDescriptor, ExtensionPointListener<T> @NotNull [] listeners) {
        if (event == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(49);
        }
        this.notifyListeners(event, () -> Collections.singletonList(Pair.create(extensionObject, pluginDescriptor)), listeners);
    }

    private void notifyListeners(@NotNull ExtensionEvent event, @NotNull List<? extends ExtensionComponentAdapter> adapters, ExtensionPointListener<T> @NotNull [] listeners) {
        if (event == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(52);
        }
        this.notifyListeners(event, () -> ContainerUtil.mapNotNull(adapters, adapter -> adapter.isInstanceCreated() ? Pair.create(adapter.createInstance(this.myComponentManager), adapter.getPluginDescriptor()) : null), listeners);
    }

    private void notifyListeners(@NotNull ExtensionEvent event, @NotNull NotNullFactory<List<Pair<T, PluginDescriptor>>> extensions, ExtensionPointListener<T> @NotNull [] listeners) {
        if (event == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        if (extensions == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        List<Pair<T, PluginDescriptor>> extensionsList = null;
        for (ExtensionPointListener extensionPointListener : listeners) {
            if (extensionPointListener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)extensionPointListener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            if (extensionsList == null) {
                extensionsList = extensions.create();
            }
            for (Pair pair : extensionsList) {
                try {
                    switch (event) {
                        case REMOVED: {
                            extensionPointListener.extensionRemoved(pair.first, (PluginDescriptor)pair.second);
                            break;
                        }
                        case ADDED: {
                            extensionPointListener.extensionAdded(pair.first, (PluginDescriptor)pair.second);
                        }
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded;
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        if (invokeForLoadedExtensions) {
            this.getExtensionList();
        }
        if ((isAdded = this.addListener(listener)) && invokeForLoadedExtensions) {
            this.notifyListeners(ExtensionEvent.ADDED, this.myAdapters, new ExtensionPointListener[]{listener});
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        ArrayFactory<ExtensionPointListener<T>> arrayFactory = LISTENER_ARRAY_FACTORY;
        if (arrayFactory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        return arrayFactory;
    }

    private boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        if (ArrayUtil.indexOf(this.myListeners, listener) != -1) {
            return false;
        }
        this.myListeners = listener instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener, this.myListeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    private void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(59);
        }
        this.myListeners = ArrayUtil.remove(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    public void addExtensionPointListener(final @NotNull ExtensionPointChangeListener listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(61);
        }
        this.addExtensionPointListener(new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.extensionListChanged();
            }
        }, invokeForLoadedExtensions, parentDisposable);
    }

    @Override
    public synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(62);
        }
        this.removeListener(listener);
    }

    @NotNull
    private static <T> T castComponentInstance(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(63);
        }
        Object object = ((ObjectComponentAdapter)adapter).myComponentInstance;
        if (object == null) {
            ExtensionPointImpl.$$$reportNull$$$0(64);
        }
        return (T)object;
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw this.myComponentManager.createError(e, this.myDescriptor.getPluginId());
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(65);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(66);
        }
        ArrayList<ExtensionComponentAdapter> list2 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + 1);
        list2.addAll(this.myAdapters);
        list2.add(adapter);
        this.myAdapters = list2;
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.myAdaptersIsSorted = false;
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    final synchronized void registerExtensions(@NotNull List<? extends Element> extensionElements, @NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters;
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(70);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(71);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(72);
        }
        if (this.myComponentManager != componentManager) {
            LOG.error("The same point on different levels (pointName=" + this.getName() + ")");
        }
        if ((adapters = this.myAdapters) == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.myAdaptersIsSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (Element element : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(element, pluginDescriptor, componentManager));
        }
        int newSize = this.myAdapters.size();
        if (listenerCallbacks != null) {
            this.clearCache();
            listenerCallbacks.add(() -> this.notifyListeners(ExtensionEvent.ADDED, () -> ContainerUtil.map(this.myAdapters.subList(oldSize, newSize), adapter -> Pair.create(this.processAdapter((ExtensionComponentAdapter)adapter), pluginDescriptor)), this.myListeners));
        }
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(73);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass2, boolean isRequired, @NotNull ThreeState strictMatch) {
        List<T> extensionsCache;
        if (aClass2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(75);
        }
        if (strictMatch == null) {
            ExtensionPointImpl.$$$reportNull$$$0(76);
        }
        if (strictMatch != ThreeState.NO) {
            V result2 = this.findExtensionByExactClass(aClass2);
            if (result2 != null) {
                return result2;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                try {
                    if (!aClass2.isAssignableFrom(adapter.getImplementationClass())) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.myComponentManager.logError(e, adapter.getPluginDescriptor().getPluginId());
                }
            }
        } else {
            for (Object extension : extensionsCache) {
                if (!aClass2.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            String message2 = "could not find extension implementation " + aClass2;
            if (this.isInReadOnlyMode()) {
                message2 = message2 + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message2);
        }
        return null;
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass2) {
        List<T> extensionsCache;
        if (aClass2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(77);
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                Object classOrName = adapter.myImplementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass2.getName()) : classOrName == aClass2)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : extensionsCache) {
                if (aClass2 != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$9(String classNameToUnregister, String className2, ExtensionComponentAdapter adapter) {
        return !className2.equals(classNameToUnregister);
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 64: 
            case 65: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 64: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 48: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 42: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 14: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 18: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 20: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 37: 
            case 38: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 46: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 49: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictMatch";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAdapters";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "listenerArrayFactory";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "castComponentInstance";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setComponentManager";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 64: 
            case 65: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 17: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionIndexForAnyOrder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processImplementations";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getActivityCategory";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 41: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
            case 56: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "castComponentInstance";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptor";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByExactClass";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 64: 
            case 65: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ExtensionEvent {
        ADDED,
        REMOVED;

    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T myComponentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder);
            this.myComponentInstance = extension;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            T t = this.myComponentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(3);
            }
            return (I)t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

