/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class Registry {
    private static Reference<ResourceBundle> ourBundle;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final THashMap<String, RegistryKeyDescriptor> myContributedKeys = new THashMap();
    private static final Registry ourInstance;
    private volatile boolean myLoaded = false;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        RegistryValue value2;
        if (key == null) {
            Registry.$$$reportNull$$$0(1);
        }
        if ((value2 = (RegistryValue)this.myValues.get(key)) != null) {
            RegistryValue registryValue = value2;
            if (registryValue == null) {
                Registry.$$$reportNull$$$0(2);
            }
            return registryValue;
        }
        value2 = new RegistryValue(this, key, (RegistryKeyDescriptor)this.myContributedKeys.get((Object)key));
        RegistryValue prev = this.myValues.putIfAbsent(key, value2);
        RegistryValue registryValue = prev == null ? value2 : prev;
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.get(key).asInteger();
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("misc.registry");
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return resourceBundle;
    }

    public String getBundleValue(@NonNls @NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if (this.myContributedKeys.containsKey((Object)key)) {
            return ((RegistryKeyDescriptor)this.myContributedKeys.get((Object)key)).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(14);
        }
        return registry;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    @NotNull
    @ApiStatus.Internal
    public Map<String, String> getUserProperties() {
        Map<String, String> map2 = this.myUserProperties;
        if (map2 == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return map2;
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addKeys";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeKey";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

