/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J)\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u0013*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getChildren", "", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "(Lcom/intellij/lang/LighterASTNode;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)[Lcom/intellij/lang/LighterASTNode;", "hasAnyArguments", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "report", "source", "checkers"})
public final class FirTypeArgumentsNotAllowedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeArgumentsNotAllowedExpressionChecker INSTANCE;

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression explicitReceiver = expression2.getExplicitReceiver();
        if (explicitReceiver instanceof FirResolvedQualifier && ((FirResolvedQualifier)explicitReceiver).getSymbol() == null) {
            FirSourceElement firSourceElement = explicitReceiver.getSource();
            if (firSourceElement != null) {
                if (this.hasAnyArguments(firSourceElement)) {
                    this.report(reporter, explicitReceiver.getSource());
                    return;
                }
            }
        }
    }

    private final boolean hasAnyArguments(FirSourceElement $this$hasAnyArguments) {
        PsiElement localPsi = FirSourceElementKt.getPsi($this$hasAnyArguments);
        LighterASTNode localLight = FirSourceElementKt.getLightNode($this$hasAnyArguments);
        if (localPsi != null && !(localPsi instanceof PsiErrorElement)) {
            return this.hasAnyArguments(localPsi);
        }
        if (localLight != null && $this$hasAnyArguments instanceof FirLightSourceElement) {
            return this.hasAnyArguments(localLight, ((FirLightSourceElement)$this$hasAnyArguments).getTree());
        }
        return false;
    }

    private final boolean hasAnyArguments(PsiElement $this$hasAnyArguments) {
        PsiElement[] children2 = $this$hasAnyArguments.getChildren();
        return children2.length > 1 && children2[1] instanceof KtTypeArgumentList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasAnyArguments(LighterASTNode $this$hasAnyArguments, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode[] children2;
        LighterASTNode[] $this$count$iv = children2 = this.getChildren($this$hasAnyArguments, tree);
        boolean $i$f$count = false;
        int count$iv = 0;
        LighterASTNode[] lighterASTNodeArray = $this$count$iv;
        int n = lighterASTNodeArray.length;
        for (int i = 0; i < n; ++i) {
            LighterASTNode element$iv;
            LighterASTNode it = element$iv = lighterASTNodeArray[i];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        if (count$iv <= true) return false;
        LighterASTNode lighterASTNode = children2[1];
        if (!Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.TYPE_ARGUMENT_LIST)) return false;
        return true;
    }

    private final LighterASTNode[] getChildren(LighterASTNode $this$getChildren, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Ref<T[]> childrenRef = new Ref<T[]>();
        int childCount = tree.getChildren($this$getChildren, childrenRef);
        LighterASTNode[] lighterASTNodeArray = childCount > 0 ? (LighterASTNode[])childrenRef.get() : new LighterASTNode[]{};
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNodeArray, (String)"if (childCount > 0) chil\u2026f.get() else emptyArray()");
        return lighterASTNodeArray;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED().on(it));
        }
    }

    private FirTypeArgumentsNotAllowedExpressionChecker() {
    }

    static {
        FirTypeArgumentsNotAllowedExpressionChecker firTypeArgumentsNotAllowedExpressionChecker;
        INSTANCE = firTypeArgumentsNotAllowedExpressionChecker = new FirTypeArgumentsNotAllowedExpressionChecker();
    }
}

