/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirDelegateFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirComposedSuperTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorCallExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrLocalDelegatedPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSpreadElementImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u001f\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ*\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010<2\b\b\u0002\u0010H\u001a\u00020@J\u0018\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020K2\b\u0010G\u001a\u0004\u0018\u00010<J\u000e\u0010L\u001a\u00020<2\u0006\u0010M\u001a\u00020NJ\u0018\u0010O\u001a\u00020<2\u0006\u0010P\u001a\u00020Q2\b\u0010G\u001a\u0004\u0018\u00010<J4\u0010R\u001a\u00020<2\u0006\u0010J\u001a\u00020K2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010<2\b\u0010X\u001a\u0004\u0018\u00010<H\u0002JL\u0010Y\u001a\u00020Z2\u0006\u0010J\u001a\u00020K2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020V2\u0006\u0010a\u001a\u00020b2\b\u0010W\u001a\u0004\u0018\u00010<2\b\u0010X\u001a\u0004\u0018\u00010<H\u0002J(\u0010c\u001a\u00020d2\u0006\u0010U\u001a\u00020V2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\\2\u0006\u0010a\u001a\u00020hH\u0002J*\u0010i\u001a\u00020<2\u0006\u0010J\u001a\u00020K2\b\u0010G\u001a\u0004\u0018\u00010<2\u0006\u0010S\u001a\u00020T2\u0006\u0010a\u001a\u00020bH\u0002J,\u0010j\u001a\u00020k2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010l\u001a\u00020m2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010hH\u0002J$\u0010n\u001a\u00020@2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020q0p2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020q0sH\u0002J\u0018\u0010t\u001a\u00020@2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020qH\u0002J\u0018\u0010x\u001a\u00020@2\u0006\u0010a\u001a\u00020b2\u0006\u0010y\u001a\u00020VH\u0002J\u0018\u0010z\u001a\u00020@2\u0006\u0010a\u001a\u00020b2\u0006\u0010y\u001a\u00020VH\u0002J \u0010{\u001a\u00020@2\u0006\u0010J\u001a\u00020K2\u0006\u0010a\u001a\u00020b2\u0006\u0010y\u001a\u00020VH\u0002J:\u0010|\u001a\u00020<*\u0006\u0012\u0002\b\u00030}2\u0012\u0010~\u001a\u000e\u0012\u0004\u0012\u00020v\u0012\u0004\u0012\u00020q0\u007f2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020q0s2\u0006\u0010H\u001a\u00020@H\u0002J\u001f\u0010\u0080\u0001\u001a\u00020<*\u00020<2\u0006\u0010u\u001a\u00020v2\b\u0010w\u001a\u0004\u0018\u00010qH\u0002J'\u0010\u0081\u0001\u001a\u00020<*\u00020<2\n\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\u0006\u0010H\u001a\u00020@H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u001f\u0010\u0085\u0001\u001a\u00020<*\u00020<2\u0006\u0010C\u001a\u00020D2\b\u0010G\u001a\u0004\u0018\u00010<H\u0002J\u001f\u0010\u0086\u0001\u001a\u00020<*\u00020<2\u0006\u0010u\u001a\u00020v2\b\u0010w\u001a\u0004\u0018\u00010qH\u0002J\u0016\u0010\u0087\u0001\u001a\u00020<*\u00020<2\u0007\u0010\u0088\u0001\u001a\u00020DH\u0002J\"\u0010\u0089\u0001\u001a\u0004\u0018\u00010<*\u00020D2\b\u0010G\u001a\u0004\u0018\u00010<2\u0007\u0010\u008a\u0001\u001a\u00020@H\u0002J\u0019\u0010\u008b\u0001\u001a\u0004\u0018\u00010<*\u00020D2\b\u0010G\u001a\u0004\u0018\u00010<H\u0002J\u0019\u0010\u008c\u0001\u001a\u0004\u0018\u00010<*\u00020D2\b\u0010G\u001a\u0004\u0018\u00010<H\u0002J\"\u0010\u008d\u0001\u001a\u0004\u0018\u00010<*\u00020D2\b\u0010G\u001a\u0004\u0018\u00010<2\u0007\u0010\u008a\u0001\u001a\u00020@H\u0002J\u000e\u0010\u008e\u0001\u001a\u00020b*\u00030\u008f\u0001H\u0002J\u001c\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001*\u00020v2\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0002J\u000e\u0010\u0094\u0001\u001a\u00020h*\u00030\u008f\u0001H\u0002J\r\u0010\u0094\u0001\u001a\u00020h*\u00020FH\u0002J\u0018\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u0001*\u00020D2\u0006\u0010a\u001a\u00020hH\u0002R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020$X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020(X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u000204X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u000208X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0097\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "visitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "convertToGetObject", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "qualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "callableReferenceMode", "", "convertToGetObject$fir2ir", "convertToIrCall", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "explicitReceiverExpression", "annotationMode", "convertToIrCallableReference", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "convertToIrConstructorCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "convertToIrSetCall", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "createAdapteeCall", "adapteeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "adapterFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "boundDispatchReceiver", "boundExtensionReceiver", "createAdapterFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "startOffset", "", "endOffset", "firAdaptee", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "adaptee", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "createAdapterParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "name", "Lorg/jetbrains/kotlin/name/Name;", "index", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateAdaptedCallableReference", "generateErrorCallExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorCallExpression;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "needArgumentReordering", "parametersInActualOrder", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "valueParameters", "", "needSamConversion", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "requiresCoercionToUnit", "function", "requiresSuspendConversion", "requiresVarargSpread", "applyArgumentsWithReorderingIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "argumentMapping", "", "applyAssigningArrayElementsToVarargInNamedForm", "applyCallArguments", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "applyCallArguments$fir2ir", "applyReceivers", "applySamConversionIfNeeded", "applyTypeArguments", "access", "findBoundReceiver", "isDispatch", "findIrDispatchReceiver", "findIrExtensionReceiver", "findIrReceiver", "kFunctionTypeToFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "callSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "toIrType", "tryConvertToSamConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "fir2ir"})
public final class CallAndReferenceGenerator
implements Fir2IrComponents {
    private final Fir2IrComponents components;
    private final Fir2IrVisitor visitor;
    private final Fir2IrConversionScope conversionScope;

    private final IrType toIrType(FirTypeRef $this$toIrType) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$with = fir2IrTypeConverter;
        boolean bl3 = false;
        return Fir2IrTypeConverter.toIrType$default($this$with, $this$toIrType, null, 1, null);
    }

    private final IrType toIrType(ConeKotlinType $this$toIrType) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$with = fir2IrTypeConverter;
        boolean bl3 = false;
        return Fir2IrTypeConverter.toIrType$default($this$with, $this$toIrType, null, null, 3, null);
    }

    @NotNull
    public final IrExpression convertToIrCallableReference(@NotNull FirCallableReferenceAccess callableReferenceAccess, @Nullable IrExpression explicitReceiverExpression) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        IrSymbol symbol2 = ConversionUtilsKt.toSymbol$default(callableReferenceAccess.getCalleeReference(), this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false, 16, null);
        IrType type2 = this.toIrType(callableReferenceAccess.getTypeRef());
        return this.applyReceivers(this.applyTypeArguments((IrExpression)ConversionUtilsKt.convertWithOffsets(callableReferenceAccess, (Function2)new Function2<Integer, Integer, IrExpression>(this, symbol2, callableReferenceAccess, type2, explicitReceiverExpression){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ IrSymbol $symbol;
            final /* synthetic */ FirCallableReferenceAccess $callableReferenceAccess;
            final /* synthetic */ IrType $type;
            final /* synthetic */ IrExpression $explicitReceiverExpression;

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                IrSymbol irSymbol = this.$symbol;
                if (irSymbol instanceof IrPropertySymbol) {
                    IrFieldSymbol irFieldSymbol;
                    IrProperty referencedProperty = (IrProperty)((IrPropertySymbol)this.$symbol).getOwner();
                    IrSimpleFunction referencedPropertyGetter = referencedProperty.getGetter();
                    if (referencedPropertyGetter != null) {
                        irFieldSymbol = null;
                    } else {
                        IrField irField = referencedProperty.getBackingField();
                        irFieldSymbol = irField != null ? (IrFieldSymbol)irField.getSymbol() : null;
                    }
                    IrFieldSymbol backingFieldSymbol = irFieldSymbol;
                    Object object = this.$callableReferenceAccess.getSource();
                    PsiElement psiElement = object != null && (object = FirSourceElementKt.getPsi((FirSourceElement)object)) != null ? object.getParent() : null;
                    IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE origin = psiElement instanceof KtPropertyDelegate ? IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE.INSTANCE : null;
                    IrSimpleFunction irSimpleFunction = referencedPropertyGetter;
                    IrSimpleFunction irSimpleFunction2 = referencedProperty.getSetter();
                    Object object2 = referencedPropertyGetter;
                    irExpression = new IrPropertyReferenceImpl(startOffset, endOffset, this.$type, (IrPropertySymbol)this.$symbol, object2 != null && (object2 = object2.getTypeParameters()) != null ? object2.size() : 0, backingFieldSymbol, irSimpleFunction != null ? (IrSimpleFunctionSymbol)irSimpleFunction.getSymbol() : null, irSimpleFunction2 != null ? (IrSimpleFunctionSymbol)irSimpleFunction2.getSymbol() : null, origin);
                } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                    IrFunctionSymbol irFunctionSymbol = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getSymbol();
                    if (irFunctionSymbol == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol");
                    }
                    IrFunction irFunction2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getSetter();
                    irExpression = new IrLocalDelegatedPropertyReferenceImpl(startOffset, endOffset, this.$type, (IrLocalDelegatedPropertySymbol)this.$symbol, (IrVariableSymbol)((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getDelegate().getSymbol(), (IrSimpleFunctionSymbol)irFunctionSymbol, (IrSimpleFunctionSymbol)(irFunction2 != null ? irFunction2.getSymbol() : null), IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE.INSTANCE);
                } else if (irSymbol instanceof IrConstructorSymbol) {
                    Object object;
                    IrConstructor constructor2 = (IrConstructor)((IrConstructorSymbol)this.$symbol).getOwner();
                    IrDeclarationParent irDeclarationParent = constructor2.getParent();
                    if (!(irDeclarationParent instanceof IrClass)) {
                        irDeclarationParent = null;
                    }
                    IrClass klass = (IrClass)irDeclarationParent;
                    irExpression = new IrFunctionReferenceImpl(startOffset, endOffset, this.$type, (IrFunctionSymbol)this.$symbol, constructor2.getTypeParameters().size() + ((object = klass) != null && (object = object.getTypeParameters()) != null ? object.size() : 0), constructor2.getValueParameters().size(), (IrFunctionSymbol)this.$symbol, null, 128, null);
                } else if (irSymbol instanceof IrFunctionSymbol) {
                    boolean constructor2 = IrTypeUtilsKt.isFunctionTypeOrSubtype(this.$type);
                    boolean klass = false;
                    if (_Assertions.ENABLED && !constructor2) {
                        boolean $i$a$-assert-CallAndReferenceGenerator$convertToIrCallableReference$1$22 = false;
                        String $i$a$-assert-CallAndReferenceGenerator$convertToIrCallableReference$1$22 = "Callable reference whose symbol refers to a function should be of functional type.";
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallAndReferenceGenerator$convertToIrCallableReference$1$22));
                    }
                    IrType irType = this.$type;
                    if (irType == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                    }
                    IrSimpleType cfr_ignored_0 = (IrSimpleType)irType;
                    IrFunction function2 = ((IrFunctionSymbol)this.$symbol).getOwner();
                    if (CallAndReferenceGenerator.access$requiresVarargSpread(this.this$0, this.$callableReferenceAccess, (IrSimpleType)this.$type, function2) || CallAndReferenceGenerator.access$requiresCoercionToUnit(this.this$0, (IrSimpleType)this.$type, function2) || CallAndReferenceGenerator.access$requiresSuspendConversion(this.this$0, (IrSimpleType)this.$type, function2)) {
                        FirTypeRef $this$coneType$iv = this.$callableReferenceAccess.getTypeRef();
                        boolean $i$f$getConeType = false;
                        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                        boolean $i$f$coneTypeUnsafe = false;
                        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                        if (coneKotlinType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                        }
                        IrSimpleType adaptedType = CallAndReferenceGenerator.access$kFunctionTypeToFunctionType(this.this$0, coneKotlinType);
                        irExpression = CallAndReferenceGenerator.access$generateAdaptedCallableReference(this.this$0, this.$callableReferenceAccess, this.$explicitReceiverExpression, (IrFunctionSymbol)this.$symbol, adaptedType);
                    } else {
                        irExpression = new IrFunctionReferenceImpl(startOffset, endOffset, this.$type, (IrFunctionSymbol)this.$symbol, function2.getTypeParameters().size(), function2.getValueParameters().size(), (IrFunctionSymbol)this.$symbol, null, 128, null);
                    }
                } else {
                    irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, "Unsupported callable reference: " + FirRendererKt.render$default(this.$callableReferenceAccess, null, 1, null));
                }
                return irExpression;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$symbol = irSymbol;
                this.$callableReferenceAccess = firCallableReferenceAccess;
                this.$type = irType;
                this.$explicitReceiverExpression = irExpression;
                super(2);
            }
        }), callableReferenceAccess), callableReferenceAccess, explicitReceiverExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean requiresVarargSpread(FirCallableReferenceAccess callableReferenceAccess, IrSimpleType type2, IrFunction function2) {
        int shift = callableReferenceAccess.getExplicitReceiver() instanceof FirResolvedQualifier ? 1 : 0;
        List<IrTypeArgument> typeArguments2 = type2.getArguments();
        int expectedParameterSize = typeArguments2.size() - 1 - shift;
        if (expectedParameterSize < function2.getValueParameters().size()) {
            return false;
        }
        boolean hasSpreadCase = false;
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irValueParameter;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (!AdditionalIrUtilsKt.isVararg((IrValueParameter)irValueParameter) || !Intrinsics.areEqual((Object)typeArguments2.get(shift + index2), (Object)irValueParameter.getVarargElementType())) continue;
            hasSpreadCase = true;
        }
        return hasSpreadCase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean requiresCoercionToUnit(IrSimpleType type2, IrFunction function2) {
        IrType expectedReturnType;
        IrType irType = expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type2.getArguments()));
        if (irType == null) return false;
        if (!IrTypePredicatesKt.isUnit(irType)) return false;
        if (IrTypePredicatesKt.isUnit(function2.getReturnType())) return false;
        return true;
    }

    private final boolean requiresSuspendConversion(IrSimpleType type2, IrFunction function2) {
        return IrTypeUtilsKt.isKSuspendFunction(type2) && !AdditionalIrUtilsKt.isSuspend(function2);
    }

    private final IrSimpleType kFunctionTypeToFunctionType(ConeKotlinType $this$kFunctionTypeToFunctionType) {
        FunctionClassKind kind = InferenceUtilsKt.isSuspendFunctionType($this$kFunctionTypeToFunctionType, this.getSession()) ? FunctionClassKind.SuspendFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$kFunctionTypeToFunctionType.getTypeArguments().length - 1));
        ConeClassLikeTypeImpl coneType = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$kFunctionTypeToFunctionType.getTypeArguments(), false, null, 8, null);
        IrType irType = this.toIrType(coneType);
        if (irType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        }
        return (IrSimpleType)irType;
    }

    private final IrExpression generateAdaptedCallableReference(FirCallableReferenceAccess callableReferenceAccess, IrExpression explicitReceiverExpression, IrFunctionSymbol adapteeSymbol, IrSimpleType type2) {
        Object v1;
        Object object = FirExpressionUtilKt.toResolvedCallableReference(callableReferenceAccess);
        if (!((object != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((AbstractFirBasedSymbol)object).getFir() : (v1 = null)) instanceof FirSimpleFunction)) {
            v1 = null;
        }
        FirSimpleFunction firAdaptee = v1;
        IrFunction adaptee = adapteeSymbol.getOwner();
        IrType expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type2.getArguments()));
        return (IrExpression)ConversionUtilsKt.convertWithOffsets(callableReferenceAccess, (Function2)new Function2<Integer, Integer, IrExpression>(this, callableReferenceAccess, explicitReceiverExpression, firAdaptee, adaptee, type2, adapteeSymbol, expectedReturnType){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ FirCallableReferenceAccess $callableReferenceAccess;
            final /* synthetic */ IrExpression $explicitReceiverExpression;
            final /* synthetic */ FirSimpleFunction $firAdaptee;
            final /* synthetic */ IrFunction $adaptee;
            final /* synthetic */ IrSimpleType $type;
            final /* synthetic */ IrFunctionSymbol $adapteeSymbol;
            final /* synthetic */ IrType $expectedReturnType;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                IrExpression boundReceiver;
                IrExpression boundDispatchReceiver = CallAndReferenceGenerator.access$findBoundReceiver(this.this$0, this.$callableReferenceAccess, this.$explicitReceiverExpression, true);
                IrExpression boundExtensionReceiver = CallAndReferenceGenerator.access$findBoundReceiver(this.this$0, this.$callableReferenceAccess, this.$explicitReceiverExpression, false);
                FirSimpleFunction firSimpleFunction = this.$firAdaptee;
                Intrinsics.checkNotNull((Object)firSimpleFunction);
                IrSimpleFunction irAdapterFunction = CallAndReferenceGenerator.access$createAdapterFunction(this.this$0, this.$callableReferenceAccess, startOffset, endOffset, firSimpleFunction, this.$adaptee, this.$type, boundDispatchReceiver, boundExtensionReceiver);
                IrExpression irCall = CallAndReferenceGenerator.access$createAdapteeCall(this.this$0, this.$callableReferenceAccess, this.$adapteeSymbol, irAdapterFunction, boundDispatchReceiver, boundExtensionReceiver);
                irAdapterFunction.setBody(this.this$0.getIrFactory().createBlockBody(startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this, irCall, startOffset, endOffset, irAdapterFunction){
                    final /* synthetic */ generateAdaptedCallableReference.1 this$0;
                    final /* synthetic */ IrExpression $irCall;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;
                    final /* synthetic */ IrSimpleFunction $irAdapterFunction;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$receiver");
                        IrType irType = this.this$0.$expectedReturnType;
                        if (irType != null) {
                            if (IrTypePredicatesKt.isUnit(irType)) {
                                $this$createBlockBody.getStatements().add(this.$irCall);
                                return;
                            }
                        }
                        $this$createBlockBody.getStatements().add(new IrReturnImpl(this.$startOffset, this.$endOffset, this.this$0.this$0.getIrBuiltIns().getNothingType(), this.$irAdapterFunction.getSymbol(), this.$irCall));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$irCall = irExpression;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        this.$irAdapterFunction = irSimpleFunction;
                        super(1);
                    }
                })));
                IrExpression irExpression2 = boundDispatchReceiver;
                if (irExpression2 == null) {
                    irExpression2 = boundReceiver = boundExtensionReceiver;
                }
                if (boundReceiver == null) {
                    irExpression = new IrFunctionExpressionImpl(startOffset, endOffset, this.$type, irAdapterFunction, IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE);
                } else {
                    IrFunctionReferenceImpl irAdapterRef = new IrFunctionReferenceImpl(startOffset, endOffset, this.$type, irAdapterFunction.getSymbol(), irAdapterFunction.getTypeParameters().size(), irAdapterFunction.getValueParameters().size(), null, IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE);
                    SmartList<Object> statements2 = new SmartList<Object>();
                    if (IrUtilsKt.isSafeToUseWithoutCopying(boundReceiver)) {
                        irAdapterRef.setExtensionReceiver(boundReceiver);
                    } else {
                        void irVariable2;
                        void p2;
                        void p1;
                        IrElement $this$deepCopyWithSymbols$iv = boundReceiver;
                        IrDeclarationParent initialParent$iv = null;
                        boolean $i$f$deepCopyWithSymbols = false;
                        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                        IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
                        DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                        TypeRemapper typeRemapper = typeRemapper$iv;
                        SymbolRemapper symbolRemapper = symbolRemapper$iv;
                        IrElement irElement = $this$deepCopyWithSymbols$iv;
                        CallAndReferenceGenerator callAndReferenceGenerator = this.this$0;
                        DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
                        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                        if (irElement2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                        }
                        Pair<IrVariable, IrValueSymbol> pair = ConversionUtilsKt.createTemporaryVariableForSafeCallConstruction(callAndReferenceGenerator, (IrExpression)((IrElement)((IrExpression)irElement2)), CallAndReferenceGenerator.access$getConversionScope$p(this.this$0));
                        IrVariable irVariable3 = (IrVariable)pair.component1();
                        IrValueSymbol irVariableSymbol = (IrValueSymbol)pair.component2();
                        irAdapterRef.setExtensionReceiver(new IrGetValueImpl(startOffset, endOffset, irVariableSymbol, null, 8, null));
                        statements2.add(irVariable2);
                    }
                    statements2.add(irAdapterFunction);
                    statements2.add(irAdapterRef);
                    irExpression = new IrBlockImpl(startOffset, endOffset, this.$type, IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE, (List<? extends IrStatement>)statements2);
                }
                return irExpression;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$callableReferenceAccess = firCallableReferenceAccess;
                this.$explicitReceiverExpression = irExpression;
                this.$firAdaptee = firSimpleFunction;
                this.$adaptee = irFunction2;
                this.$type = irSimpleType;
                this.$adapteeSymbol = irFunctionSymbol;
                this.$expectedReturnType = irType;
                super(2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createAdapterFunction(FirCallableReferenceAccess callableReferenceAccess, int startOffset, int endOffset, FirSimpleFunction firAdaptee, IrFunction adaptee, IrSimpleType type2, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        void $this$mapTo$iv$iv;
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type2.getArguments()));
        Intrinsics.checkNotNull((Object)irType);
        IrType returnType2 = irType;
        Iterable $this$map$iv = CollectionsKt.dropLast(type2.getArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType irType2;
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)IrTypesKt.getTypeOrNull((IrTypeArgument)it));
            collection.add(irType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        WrappedSimpleFunctionDescriptor adapterFunctionDescriptor = new WrappedSimpleFunctionDescriptor();
        return this.getSymbolTable().declareSimpleFunction(adapterFunctionDescriptor, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(this, startOffset, endOffset, adaptee, returnType2, firAdaptee, type2, adapterFunctionDescriptor, boundDispatchReceiver, boundExtensionReceiver, callableReferenceAccess, parameterTypes){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrFunction $adaptee;
            final /* synthetic */ IrType $returnType;
            final /* synthetic */ FirSimpleFunction $firAdaptee;
            final /* synthetic */ IrSimpleType $type;
            final /* synthetic */ WrappedSimpleFunctionDescriptor $adapterFunctionDescriptor;
            final /* synthetic */ IrExpression $boundDispatchReceiver;
            final /* synthetic */ IrExpression $boundExtensionReceiver;
            final /* synthetic */ FirCallableReferenceAccess $callableReferenceAccess;
            final /* synthetic */ List $parameterTypes;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol irAdapterSymbol) {
                Collection<IrValueParameter> collection;
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)irAdapterSymbol, (String)"irAdapterSymbol");
                IrFactory irFactory = this.this$0.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE;
                Name name = this.$adaptee.getName();
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"DescriptorVisibilities.LOCAL");
                FirMemberDeclaration $this$isInline$iv = this.$firAdaptee;
                boolean $i$f$isInline = false;
                FirMemberDeclaration $this$isExternal$iv = this.$firAdaptee;
                boolean $i$f$isExternal = false;
                FirMemberDeclaration $this$isTailRec$iv = this.$firAdaptee;
                boolean $i$f$isTailRec = false;
                FirMemberDeclaration $this$isSuspend$iv = this.$firAdaptee;
                boolean $i$f$isSuspend = false;
                FirMemberDeclaration $this$isOperator$iv = this.$firAdaptee;
                boolean $i$f$isOperator = false;
                FirMemberDeclaration $this$isInfix$iv = this.$firAdaptee;
                boolean $i$f$isInfix = false;
                FirMemberDeclaration $this$isExpect$iv = this.$firAdaptee;
                boolean $i$f$isExpect = false;
                IrSimpleFunction irSimpleFunction = IrFactory.DefaultImpls.createFunction$default(irFactory, this.$startOffset, this.$endOffset, irDeclarationOrigin, irAdapterSymbol, name, descriptorVisibility, Modality.FINAL, this.$returnType, $this$isInline$iv.getStatus().isInline(), $this$isExternal$iv.getStatus().isExternal(), $this$isTailRec$iv.getStatus().isTailRec(), $this$isSuspend$iv.getStatus().isSuspend() || IrTypeUtilsKt.isSuspendFunction(this.$type), $this$isOperator$iv.getStatus().isOperator(), $this$isInfix$iv.getStatus().isInfix(), $this$isExpect$iv.getStatus().isExpect(), false, null, 65536, null);
                boolean bl = false;
                boolean bl2 = false;
                IrSimpleFunction irAdapterFunction = irSimpleFunction;
                boolean bl3 = false;
                this.$adapterFunctionDescriptor.bind((IrDeclaration)irAdapterFunction);
                irAdapterFunction.setMetadata(new FirMetadataSource.Function(this.$firAdaptee));
                this.this$0.getSymbolTable().enterScope(irAdapterFunction);
                irAdapterFunction.setDispatchReceiverParameter(null);
                IrExpression irExpression = this.$boundDispatchReceiver;
                if (irExpression == null) {
                    irExpression = this.$boundExtensionReceiver;
                }
                IrExpression boundReceiver = irExpression;
                if (boundReceiver == null) {
                    irAdapterFunction.setExtensionReceiverParameter(null);
                } else {
                    if (this.$boundDispatchReceiver != null && this.$boundExtensionReceiver != null) {
                        String string2 = "Bound callable references can't have both receivers: " + FirRendererKt.render$default(this.$callableReferenceAccess, null, 1, null);
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    IrFunction irFunction2 = irAdapterFunction;
                    Name name2 = Name.identifier("receiver");
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"receiver\")");
                    irAdapterFunction.setExtensionReceiverParameter(CallAndReferenceGenerator.access$createAdapterParameter(this.this$0, irFunction2, name2, -1, boundReceiver.getType()));
                }
                IrSimpleFunction irSimpleFunction2 = irAdapterFunction;
                Iterable iterable = this.$parameterTypes;
                Collection collection2 = irSimpleFunction2.getValueParameters();
                IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
                boolean $i$f$mapIndexed = false;
                void var12_14 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void parameterType;
                    void index2;
                    int n = index$iv$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrType irType = (IrType)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    IrFunction irFunction3 = irAdapterFunction;
                    Name name3 = Name.identifier("" + 'p' + (int)index2);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"p$index\")");
                    IrValueParameter irValueParameter = CallAndReferenceGenerator.access$createAdapterParameter(this.this$0, irFunction3, name3, (int)index2, (IrType)parameterType);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irSimpleFunction3.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                this.this$0.getSymbolTable().leaveScope(irAdapterFunction);
                IrDeclarationParent irDeclarationParent = CallAndReferenceGenerator.access$getConversionScope$p(this.this$0).parent();
                Intrinsics.checkNotNull((Object)irDeclarationParent);
                irAdapterFunction.setParent(irDeclarationParent);
                return irSimpleFunction;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$adaptee = irFunction2;
                this.$returnType = irType;
                this.$firAdaptee = firSimpleFunction;
                this.$type = irSimpleType;
                this.$adapterFunctionDescriptor = wrappedSimpleFunctionDescriptor;
                this.$boundDispatchReceiver = irExpression;
                this.$boundExtensionReceiver = irExpression2;
                this.$callableReferenceAccess = firCallableReferenceAccess;
                this.$parameterTypes = list2;
                super(1);
            }
        }));
    }

    private final IrValueParameter createAdapterParameter(IrFunction adapterFunction, Name name, int index2, IrType type2) {
        int startOffset = adapterFunction.getStartOffset();
        int endOffset = adapterFunction.getEndOffset();
        WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor();
        return SymbolTable.declareValueParameter$default(this.getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.ADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE.INSTANCE, descriptor2, type2, null, (Function1)new Function1<IrValueParameterSymbol, IrValueParameter>(this, startOffset, endOffset, name, index2, type2, descriptor2, adapterFunction){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ Name $name;
            final /* synthetic */ int $index;
            final /* synthetic */ IrType $type;
            final /* synthetic */ WrappedValueParameterDescriptor $descriptor;
            final /* synthetic */ IrFunction $adapterFunction;

            @NotNull
            public final IrValueParameter invoke(@NotNull IrValueParameterSymbol irAdapterParameterSymbol) {
                Intrinsics.checkNotNullParameter((Object)irAdapterParameterSymbol, (String)"irAdapterParameterSymbol");
                IrValueParameter irValueParameter = IrFactory.DefaultImpls.createValueParameter$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, IrDeclarationOrigin.ADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE.INSTANCE, irAdapterParameterSymbol, this.$name, this.$index, this.$type, null, false, false, false, 1024, null);
                boolean bl = false;
                boolean bl2 = false;
                IrValueParameter irAdapterValueParameter = irValueParameter;
                boolean bl3 = false;
                this.$descriptor.bind((IrDeclaration)irAdapterValueParameter);
                irAdapterValueParameter.setParent(this.$adapterFunction);
                return irValueParameter;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$name = name;
                this.$index = n3;
                this.$type = irType;
                this.$descriptor = wrappedValueParameterDescriptor;
                this.$adapterFunction = irFunction2;
                super(1);
            }
        }, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createAdapteeCall(FirCallableReferenceAccess callableReferenceAccess, IrFunctionSymbol adapteeSymbol, IrFunction adapterFunction, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        void $this$mapIndexedTo$iv$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunction adapteeFunction = adapteeSymbol.getOwner();
        int startOffset = adapteeFunction.getStartOffset();
        int endOffset = adapteeFunction.getEndOffset();
        IrType type2 = adapteeFunction.getReturnType();
        IrFunctionSymbol irFunctionSymbol = adapteeSymbol;
        if (irFunctionSymbol instanceof IrConstructorSymbol) {
            irFunctionAccessExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, startOffset, endOffset, type2, (IrConstructorSymbol)adapteeSymbol, null, 16, null);
        } else if (irFunctionSymbol instanceof IrSimpleFunctionSymbol) {
            irFunctionAccessExpression = new IrCallImpl(startOffset, endOffset, type2, (IrSimpleFunctionSymbol)adapteeSymbol, callableReferenceAccess.getTypeArguments().size(), adapteeFunction.getValueParameters().size(), null, null);
        } else {
            String string2 = "unknown callee kind: " + RenderIrElementKt.render(adapteeFunction);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrFunctionAccessExpression irCall = irFunctionAccessExpression;
        int adapterParameterIndex = 0;
        if (boundDispatchReceiver != null || boundExtensionReceiver != null) {
            IrValueParameter irValueParameter = adapterFunction.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrGetValueImpl receiverValue = new IrGetValueImpl(startOffset, endOffset, irValueParameter.getSymbol(), IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE);
            if (boundDispatchReceiver != null) {
                irCall.setDispatchReceiver(receiverValue);
            } else if (boundExtensionReceiver != null) {
                irCall.setExtensionReceiver(receiverValue);
            }
        } else if (callableReferenceAccess.getExplicitReceiver() instanceof FirResolvedQualifier) {
            IrValueParameter adaptedReceiverParameter = adapterFunction.getValueParameters().get(0);
            IrGetValueImpl adaptedReceiverValue = new IrGetValueImpl(startOffset, endOffset, adaptedReceiverParameter.getType(), adaptedReceiverParameter.getSymbol(), null, 16, null);
            if (adapteeFunction.getExtensionReceiverParameter() != null) {
                irCall.setExtensionReceiver(adaptedReceiverValue);
                int n = adapterParameterIndex;
                adapterParameterIndex = n + 1;
            } else {
                irCall.setDispatchReceiver(adaptedReceiverValue);
            }
        }
        Function1<IrValueParameter, IrGetValue> $fun$toGetValue$1 = new Function1<IrValueParameter, IrGetValue>(startOffset, endOffset){
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;

            @NotNull
            public final IrGetValue invoke(@NotNull IrValueParameter $this$toGetValue) {
                Intrinsics.checkNotNullParameter((Object)$this$toGetValue, (String)"$this$toGetValue");
                return new IrGetValueImpl(this.$startOffset, this.$endOffset, $this$toGetValue.getType(), $this$toGetValue.getSymbol(), null, 16, null);
            }
            {
                this.$startOffset = n;
                this.$endOffset = n2;
                super(1);
            }
        };
        Iterable $this$mapIndexed$iv = adapteeFunction.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void valueParameter;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (AdditionalIrUtilsKt.isVararg((IrValueParameter)valueParameter)) {
                if (adapterFunction.getValueParameters().size() <= index2) {
                    irCall.putValueArgument((int)index2, null);
                } else {
                    IrType irType = valueParameter.getType();
                    IrType irType2 = valueParameter.getVarargElementType();
                    Intrinsics.checkNotNull((Object)irType2);
                    IrVarargImpl adaptedValueArgument = new IrVarargImpl(startOffset, endOffset, irType, irType2);
                    boolean neitherArrayNorSpread = false;
                    while (adapterParameterIndex < adapterFunction.getValueParameters().size()) {
                        int n3;
                        IrGetValue irValueArgument = $fun$toGetValue$1.invoke(adapterFunction.getValueParameters().get(adapterParameterIndex));
                        if (Intrinsics.areEqual((Object)irValueArgument.getType(), (Object)valueParameter.getType())) {
                            adaptedValueArgument.addElement(new IrSpreadElementImpl(startOffset, endOffset, irValueArgument));
                            n3 = adapterParameterIndex;
                            adapterParameterIndex = n3 + 1;
                            break;
                        }
                        if (Intrinsics.areEqual((Object)irValueArgument.getType(), (Object)valueParameter.getVarargElementType())) {
                            adaptedValueArgument.addElement(irValueArgument);
                            n3 = adapterParameterIndex;
                            adapterParameterIndex = n3 + 1;
                            continue;
                        }
                        neitherArrayNorSpread = true;
                        break;
                    }
                    if (neitherArrayNorSpread) {
                        irCall.putValueArgument((int)index2, null);
                    } else {
                        irCall.putValueArgument((int)index2, adaptedValueArgument);
                    }
                }
            } else if (IrUtilsKt.hasDefaultValue((IrValueParameter)valueParameter)) {
                irCall.putValueArgument((int)index2, null);
            } else {
                int n4 = adapterParameterIndex;
                adapterParameterIndex = n4 + 1;
                irCall.putValueArgument((int)index2, $fun$toGetValue$1.invoke(adapterFunction.getValueParameters().get(n4)));
            }
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return this.applyTypeArguments(irCall, callableReferenceAccess);
    }

    private final IrTypeOperatorCall tryConvertToSamConstructorCall(FirQualifiedAccess $this$tryConvertToSamConstructorCall, IrType type2) {
        FirReference firReference = $this$tryConvertToSamConstructorCall.getCalleeReference();
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
        if (firResolvedNamedReference == null) {
            return null;
        }
        FirResolvedNamedReference calleeReference = firResolvedNamedReference;
        Object fir = calleeReference.getResolvedSymbol().getFir();
        if ($this$tryConvertToSamConstructorCall instanceof FirFunctionCall && fir instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)fir).getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return (IrTypeOperatorCall)ConversionUtilsKt.convertWithOffsets($this$tryConvertToSamConstructorCall, (Function2)new Function2<Integer, Integer, IrTypeOperatorCallImpl>(this, $this$tryConvertToSamConstructorCall, type2){
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ FirQualifiedAccess $this_tryConvertToSamConstructorCall;
                final /* synthetic */ IrType $type;

                @NotNull
                public final IrTypeOperatorCallImpl invoke(int startOffset, int endOffset) {
                    FirCall $this$argument$iv = (FirCall)((Object)this.$this_tryConvertToSamConstructorCall);
                    boolean $i$f$getArgument = false;
                    return new IrTypeOperatorCallImpl(startOffset, endOffset, this.$type, IrTypeOperator.SAM_CONVERSION, this.$type, Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), (FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()), false, 2, null));
                }
                {
                    this.this$0 = callAndReferenceGenerator;
                    this.$this_tryConvertToSamConstructorCall = firQualifiedAccess;
                    this.$type = irType;
                    super(2);
                }
            });
        }
        return null;
    }

    private final IrClassSymbol superQualifierSymbol(FirExpression $this$superQualifierSymbol, IrSymbol callSymbol) {
        ConeClassLikeType coneSuperType;
        FirTypeRef superTypeRef;
        if (!($this$superQualifierSymbol instanceof FirQualifiedAccess)) {
            return null;
        }
        FirReference dispatchReceiverReference = ((FirQualifiedAccess)((Object)$this$superQualifierSymbol)).getCalleeReference();
        if (!(dispatchReceiverReference instanceof FirSuperReference)) {
            return null;
        }
        FirTypeRef $this$coneTypeSafe$iv = superTypeRef = ((FirSuperReference)dispatchReceiverReference).getSuperTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneSuperType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null) {
            FirClassSymbol firClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneSuperType.getLookupTag(), this.getSession());
            if (!(firClassLikeSymbol instanceof FirClassSymbol)) {
                firClassLikeSymbol = null;
            }
            if ((firClassSymbol = (FirClassSymbol)firClassLikeSymbol) != null) {
                return this.getClassifierStorage().getIrClassSymbol(firClassSymbol);
            }
        } else if (superTypeRef instanceof FirComposedSuperTypeRef) {
            IrSymbolOwner owner;
            IrSymbol irSymbol = callSymbol;
            IrSymbolOwner irSymbolOwner = owner = irSymbol != null ? irSymbol.getOwner() : null;
            if (owner != null && owner instanceof IrDeclaration) {
                IrClass irClass2 = IrUtilsKt.getParentClassOrNull((IrDeclaration)((Object)owner));
                return irClass2 != null ? (IrClassSymbol)irClass2.getSymbol() : null;
            }
        }
        return null;
    }

    @NotNull
    public final IrExpression convertToIrCall(@NotNull FirQualifiedAccess qualifiedAccess, @NotNull FirTypeRef typeRef, @Nullable IrExpression explicitReceiverExpression, boolean annotationMode) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccess, (String)"qualifiedAccess");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        try {
            IrType type2 = this.toIrType(typeRef);
            IrTypeOperatorCall samConstructorCall = this.tryConvertToSamConstructorCall(qualifiedAccess, type2);
            if (samConstructorCall != null) {
                return samConstructorCall;
            }
            IrSymbol symbol2 = ConversionUtilsKt.toSymbol$default(qualifiedAccess.getCalleeReference(), this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false, 16, null);
            IrExpression irExpression = (IrExpression)ConversionUtilsKt.convertWithOffsets(qualifiedAccess, (Function2)new Function2<Integer, Integer, IrExpression>(this, qualifiedAccess, symbol2, type2){
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ FirQualifiedAccess $qualifiedAccess;
                final /* synthetic */ IrSymbol $symbol;
                final /* synthetic */ IrType $type;

                @NotNull
                public final IrExpression invoke(int startOffset, int endOffset) {
                    IrExpression irExpression;
                    FirExpression dispatchReceiver = this.$qualifiedAccess.getDispatchReceiver();
                    if (this.$qualifiedAccess.getCalleeReference() instanceof FirSuperReference && !(dispatchReceiver instanceof FirNoReceiverExpression)) {
                        return Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), dispatchReceiver, false, 2, null);
                    }
                    IrSymbol irSymbol = this.$symbol;
                    if (irSymbol instanceof IrConstructorSymbol) {
                        irExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, startOffset, endOffset, this.$type, (IrConstructorSymbol)this.$symbol, null, 16, null);
                    } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
                        irExpression = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)this.$symbol, ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getTypeParameters().size(), ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getValueParameters().size(), ConversionUtilsKt.statementOrigin(this.$qualifiedAccess.getCalleeReference()), CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol));
                    } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                        IrFunctionSymbol irFunctionSymbol = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getSymbol();
                        if (irFunctionSymbol == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol");
                        }
                        irExpression = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)irFunctionSymbol, ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getTypeParameters().size(), 0, IrStatementOrigin.GET_LOCAL_PROPERTY.INSTANCE, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol));
                    } else if (irSymbol instanceof IrPropertySymbol) {
                        IrSimpleFunction getter2 = ((IrProperty)((IrPropertySymbol)this.$symbol).getOwner()).getGetter();
                        IrField backingField2 = ((IrProperty)((IrPropertySymbol)this.$symbol).getOwner()).getBackingField();
                        irExpression = getter2 != null ? (IrExpression)new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)getter2.getSymbol(), getter2.getTypeParameters().size(), 0, IrStatementOrigin.GET_PROPERTY.INSTANCE, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol)) : (backingField2 != null ? (IrExpression)new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)backingField2.getSymbol(), this.$type, null, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol), 16, null) : (IrExpression)new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, "No getter or backing field found for " + FirRendererKt.render$default(this.$qualifiedAccess.getCalleeReference(), null, 1, null)));
                    } else if (irSymbol instanceof IrFieldSymbol) {
                        IrStatementOrigin.GET_PROPERTY gET_PROPERTY = IrStatementOrigin.GET_PROPERTY.INSTANCE;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrStatementOrigin.GET_PROPERTY gET_PROPERTY2 = gET_PROPERTY;
                        IrType irType = this.$type;
                        IrFieldSymbol irFieldSymbol = (IrFieldSymbol)this.$symbol;
                        int n = endOffset;
                        int n2 = startOffset;
                        boolean bl3 = false;
                        boolean bl4 = !(this.$qualifiedAccess.getCalleeReference() instanceof FirDelegateFieldReference);
                        IrClassSymbol irClassSymbol = CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol);
                        IrStatementOrigin irStatementOrigin = bl4 ? gET_PROPERTY : null;
                        IrType irType2 = irType;
                        IrFieldSymbol irFieldSymbol2 = irFieldSymbol;
                        int n3 = n;
                        int n4 = n2;
                        irExpression = new IrGetFieldImpl(n4, n3, irFieldSymbol2, irType2, irStatementOrigin, irClassSymbol);
                    } else {
                        irExpression = irSymbol instanceof IrValueSymbol ? (IrExpression)new IrGetValueImpl(startOffset, endOffset, this.$type, (IrValueSymbol)this.$symbol, ConversionUtilsKt.statementOrigin(this.$qualifiedAccess.getCalleeReference())) : (irSymbol instanceof IrEnumEntrySymbol ? (IrExpression)new IrGetEnumValueImpl(startOffset, endOffset, this.$type, (IrEnumEntrySymbol)this.$symbol) : (IrExpression)CallAndReferenceGenerator.access$generateErrorCallExpression(this.this$0, startOffset, endOffset, this.$qualifiedAccess.getCalleeReference(), this.$type));
                    }
                    return irExpression;
                }
                {
                    this.this$0 = callAndReferenceGenerator;
                    this.$qualifiedAccess = firQualifiedAccess;
                    this.$symbol = irSymbol;
                    this.$type = irType;
                    super(2);
                }
            });
            FirQualifiedAccess firQualifiedAccess = qualifiedAccess;
            if (!(firQualifiedAccess instanceof FirCall)) {
                firQualifiedAccess = null;
            }
            return this.applyReceivers(this.applyTypeArguments(this.applyCallArguments$fir2ir(irExpression, (FirCall)((Object)firQualifiedAccess), annotationMode), qualifiedAccess), qualifiedAccess, explicitReceiverExpression);
        }
        catch (Throwable e) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Error while translating ").append(FirRendererKt.render$default(qualifiedAccess, null, 1, null)).append(' ').append("from file ");
            Object object = this.conversionScope.containingFileIfAny();
            if (object == null || (object = IrFileKt.getName((IrFile)object)) == null) {
                object = "???";
            }
            throw (Throwable)new IllegalStateException(stringBuilder2.append((String)object).append(" to BE IR").toString(), e);
        }
    }

    public static /* synthetic */ IrExpression convertToIrCall$default(CallAndReferenceGenerator callAndReferenceGenerator, FirQualifiedAccess firQualifiedAccess, FirTypeRef firTypeRef, IrExpression irExpression, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return callAndReferenceGenerator.convertToIrCall(firQualifiedAccess, firTypeRef, irExpression, bl);
    }

    @NotNull
    public final IrExpression convertToIrSetCall(@NotNull FirVariableAssignment variableAssignment, @Nullable IrExpression explicitReceiverExpression) {
        Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
        IrType type2 = this.getIrBuiltIns().getUnitType();
        FirReference calleeReference = variableAssignment.getCalleeReference();
        IrSymbol symbol2 = ConversionUtilsKt.toSymbol(calleeReference, this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false);
        IrStatementOrigin.EQ origin = IrStatementOrigin.EQ.INSTANCE;
        return this.applyReceivers(this.applyTypeArguments((IrExpression)ConversionUtilsKt.convertWithOffsets(variableAssignment, (Function2)new Function2<Integer, Integer, IrExpression>(this, variableAssignment, symbol2, type2, origin, calleeReference){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ FirVariableAssignment $variableAssignment;
            final /* synthetic */ IrSymbol $symbol;
            final /* synthetic */ IrType $type;
            final /* synthetic */ IrStatementOrigin.EQ $origin;
            final /* synthetic */ FirReference $calleeReference;

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                IrExpression assignedValue = Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), this.$variableAssignment.getRValue(), false, 2, null);
                IrSymbol irSymbol = this.$symbol;
                if (irSymbol instanceof IrFieldSymbol) {
                    IrSetFieldImpl irSetFieldImpl = new IrSetFieldImpl(startOffset, endOffset, (IrFieldSymbol)this.$symbol, this.$type, this.$origin, null, 32, null);
                    boolean bl = false;
                    boolean bl2 = false;
                    IrSetFieldImpl $this$apply = irSetFieldImpl;
                    boolean bl3 = false;
                    $this$apply.setValue(assignedValue);
                    irExpression = irSetFieldImpl;
                } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                    IrFunction setter2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getSetter();
                    if (setter2 != null) {
                        IrFunctionSymbol irFunctionSymbol = setter2.getSymbol();
                        if (irFunctionSymbol == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol");
                        }
                        IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)irFunctionSymbol, setter2.getTypeParameters().size(), 1, this.$origin, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                        boolean bl = false;
                        boolean $this$apply = false;
                        IrCallImpl $this$apply2 = irCallImpl;
                        boolean bl4 = false;
                        $this$apply2.putValueArgument(0, assignedValue);
                        irExpression = irCallImpl;
                    } else {
                        irExpression = CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                    }
                } else if (irSymbol instanceof IrPropertySymbol) {
                    IrProperty irProperty2 = (IrProperty)((IrPropertySymbol)this.$symbol).getOwner();
                    IrSimpleFunction setter3 = irProperty2.getSetter();
                    IrField backingField2 = irProperty2.getBackingField();
                    if (setter3 != null) {
                        IrCallImpl $this$apply = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)setter3.getSymbol(), setter3.getTypeParameters().size(), 1, this.$origin, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                        boolean $this$apply2 = false;
                        boolean bl = false;
                        IrCallImpl $this$apply3 = $this$apply;
                        boolean bl5 = false;
                        $this$apply3.putValueArgument(0, assignedValue);
                        irExpression = $this$apply;
                    } else if (backingField2 != null) {
                        IrSetFieldImpl $this$apply = new IrSetFieldImpl(startOffset, endOffset, (IrFieldSymbol)backingField2.getSymbol(), this.$type, null, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                        boolean $this$apply2 = false;
                        boolean bl = false;
                        IrSetFieldImpl $this$apply4 = $this$apply;
                        boolean bl6 = false;
                        $this$apply4.setValue(assignedValue);
                        irExpression = $this$apply;
                    } else {
                        irExpression = CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                    }
                } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
                    IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)this.$symbol, ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getTypeParameters().size(), 1, this.$origin, null, 128, null);
                    boolean bl = false;
                    boolean bl7 = false;
                    IrCallImpl $this$apply = irCallImpl;
                    boolean bl8 = false;
                    $this$apply.putValueArgument(0, assignedValue);
                    irExpression = irCallImpl;
                } else {
                    irExpression = irSymbol instanceof IrVariableSymbol ? (IrExpression)new IrSetVariableImpl(startOffset, endOffset, this.$type, (IrVariableSymbol)this.$symbol, assignedValue, this.$origin) : (IrExpression)CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                }
                return irExpression;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$variableAssignment = firVariableAssignment;
                this.$symbol = irSymbol;
                this.$type = irType;
                this.$origin = eQ;
                this.$calleeReference = firReference;
                super(2);
            }
        }), variableAssignment), variableAssignment, explicitReceiverExpression);
    }

    @NotNull
    public final IrExpression convertToIrConstructorCall(@NotNull FirAnnotationCall annotationCall) {
        IrType type2;
        ConeLookupTagBasedType coneType;
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        FirTypeRef $this$coneTypeSafe$iv = annotationCall.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
            coneKotlinType = null;
        }
        ConeLookupTagBasedType coneLookupTagBasedType = coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType));
        IrType irType = type2 = coneLookupTagBasedType != null ? this.toIrType(coneLookupTagBasedType) : null;
        IrClassifierSymbol symbol2 = irType != null ? IrTypesKt.getClassifierOrNull(irType) : null;
        return this.applyCallArguments$fir2ir((IrExpression)ConversionUtilsKt.convertWithOffsets(annotationCall, (Function2)new Function2<Integer, Integer, IrExpression>(this, symbol2, annotationCall, coneType, type2){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ IrClassifierSymbol $symbol;
            final /* synthetic */ FirAnnotationCall $annotationCall;
            final /* synthetic */ ConeLookupTagBasedType $coneType;
            final /* synthetic */ IrType $type;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                block14: {
                    block11: {
                        int n;
                        int n2;
                        Object object;
                        Object object2;
                        IrClass irClass2;
                        block13: {
                            void constructorSymbol;
                            block12: {
                                IrClassifierSymbol irClassifierSymbol = this.$symbol;
                                if (!(irClassifierSymbol instanceof IrClassSymbol)) break block11;
                                irClass2 = (IrClass)((IrClassSymbol)this.$symbol).getOwner();
                                FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(this.$annotationCall);
                                if (!(firCallableSymbol instanceof FirConstructorSymbol)) {
                                    firCallableSymbol = null;
                                }
                                if ((object2 = (FirConstructorSymbol)firCallableSymbol) == null) break block12;
                                object = object2;
                                n2 = 0;
                                n = 0;
                                Object it = object;
                                boolean bl = false;
                                object2 = this.this$0.getDeclarationStorage().getIrConstructorSymbol((FirConstructorSymbol)it);
                                if (object2 != null) break block13;
                            }
                            object = this.this$0;
                            n2 = 0;
                            n = 0;
                            Object $this$run = object;
                            boolean bl = false;
                            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(this.$coneType.getLookupTag(), ((CallAndReferenceGenerator)$this$run).getSession());
                            Object object3 = firClassifierSymbol != null ? firClassifierSymbol.getFir() : null;
                            if (!(object3 instanceof FirClass)) {
                                object3 = null;
                            }
                            FirClass fir = (FirClass)object3;
                            Ref.ObjectRef objectRef = new Ref.ObjectRef();
                            objectRef.element = null;
                            Object object4 = fir;
                            if (object4 != null && (object4 = KotlinScopeProviderKt.unsubstitutedScope(object4, ((CallAndReferenceGenerator)$this$run).getSession(), ((CallAndReferenceGenerator)$this$run).getScopeSession())) != null) {
                                ((FirScope)object4).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)new Function1<FirConstructorSymbol, Unit>((Ref.ObjectRef)constructorSymbol){
                                    final /* synthetic */ Ref.ObjectRef $constructorSymbol;

                                    public final void invoke(@NotNull FirConstructorSymbol it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        if (((FirConstructor)it.getFir()).isPrimary() && (FirConstructorSymbol)this.$constructorSymbol.element == null) {
                                            this.$constructorSymbol.element = it;
                                        }
                                    }
                                    {
                                        this.$constructorSymbol = objectRef;
                                        super(1);
                                    }
                                }));
                            }
                            FirConstructorSymbol firConstructorSymbol = (FirConstructorSymbol)constructorSymbol.element;
                            if (firConstructorSymbol != null) {
                                FirConstructorSymbol firConstructorSymbol2 = firConstructorSymbol;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                FirConstructorSymbol it = firConstructorSymbol2;
                                boolean bl4 = false;
                                object2 = ((CallAndReferenceGenerator)$this$run).getDeclarationStorage().getIrConstructorSymbol(it);
                            } else {
                                object2 = null;
                            }
                        }
                        Object irConstructor2 = object2;
                        if (irConstructor2 == null) {
                            irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, "No annotation constructor found: " + irClass2.getName());
                        } else {
                            object = null;
                            n2 = 0;
                            n = 0;
                            int n3 = ((IrConstructor)irConstructor2.getOwner()).getValueParameters().size();
                            irExpression = new IrConstructorCallImpl(startOffset, endOffset, this.$type, (IrConstructorSymbol)irConstructor2, n, n2, n3, (IrStatementOrigin)object, 128, null);
                        }
                        break block14;
                    }
                    IrType irType = this.$type;
                    if (irType == null) {
                        irType = ConversionUtilsKt.createErrorType();
                    }
                    irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, irType, "Unresolved reference: " + FirRendererKt.render$default(this.$annotationCall, null, 1, null));
                }
                return irExpression;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$symbol = irClassifierSymbol;
                this.$annotationCall = firAnnotationCall;
                this.$coneType = coneLookupTagBasedType;
                this.$type = irType;
                super(2);
            }
        }), annotationCall, true);
    }

    @NotNull
    public final IrExpression convertToGetObject(@NotNull FirResolvedQualifier qualifier) {
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        IrExpression irExpression = this.convertToGetObject$fir2ir(qualifier, false);
        Intrinsics.checkNotNull((Object)irExpression);
        return irExpression;
    }

    @Nullable
    public final IrExpression convertToGetObject$fir2ir(@NotNull FirResolvedQualifier qualifier, boolean callableReferenceMode) {
        FirClassLikeSymbol<?> classSymbol;
        Object object;
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        FirTypeRef $this$coneType$iv = qualifier.getTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType2 = null;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = (object = (ConeClassLikeType)coneKotlinType2) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.getSession()) : (classSymbol = null);
        if (callableReferenceMode && classSymbol instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)classSymbol.getClassId(), (Object)qualifier.getClassId()) ^ true) {
            return null;
        }
        IrType irType = this.toIrType(qualifier.getTypeRef());
        return (IrExpression)ConversionUtilsKt.convertWithOffsets(qualifier, (Function2)new Function2<Integer, Integer, IrExpression>(this, classSymbol, irType, qualifier){
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ FirClassLikeSymbol $classSymbol;
            final /* synthetic */ IrType $irType;
            final /* synthetic */ FirResolvedQualifier $qualifier;

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                if (this.$classSymbol != null) {
                    FirClassLikeSymbol firClassLikeSymbol = this.$classSymbol;
                    Intrinsics.checkNotNullExpressionValue((Object)firClassLikeSymbol, (String)"classSymbol");
                    IrClassifierSymbol irClassifierSymbol = ConversionUtilsKt.toSymbol$default(firClassLikeSymbol, this.this$0.getSession(), this.this$0.getClassifierStorage(), null, 4, null);
                    if (irClassifierSymbol == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
                    }
                    irExpression = new IrGetObjectValueImpl(startOffset, endOffset, this.$irType, (IrClassSymbol)irClassifierSymbol);
                } else {
                    irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, this.$irType, "Resolved qualifier " + FirRendererKt.render$default(this.$qualifier, null, 1, null) + " does not have correctly resolved type");
                }
                return irExpression;
            }
            {
                this.this$0 = callAndReferenceGenerator;
                this.$classSymbol = firClassLikeSymbol;
                this.$irType = irType;
                this.$qualifier = firResolvedQualifier;
                super(2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression applyCallArguments$fir2ir(@NotNull IrExpression $this$applyCallArguments, @Nullable FirCall call2, boolean annotationMode) {
        Object object;
        block17: {
            IrExpression irExpression;
            block13: {
                int argumentsCount;
                block14: {
                    List<FirValueParameter> valueParameters2;
                    IrMemberAccessExpression $this$apply;
                    Object $this$arguments$iv;
                    block15: {
                        Map<FirExpression, FirValueParameter> argumentMapping;
                        block16: {
                            FirFunction function2;
                            FirResolvedNamedReference calleeReference;
                            FirReference firReference;
                            Intrinsics.checkNotNullParameter((Object)$this$applyCallArguments, (String)"$this$applyCallArguments");
                            if (call2 == null) {
                                return $this$applyCallArguments;
                            }
                            irExpression = $this$applyCallArguments;
                            if (!(irExpression instanceof IrMemberAccessExpression)) break block13;
                            $this$arguments$iv = call2;
                            boolean $i$f$getArguments = false;
                            argumentsCount = $this$arguments$iv.getArgumentList().getArguments().size();
                            if (argumentsCount > ((IrMemberAccessExpression)$this$applyCallArguments).getValueArgumentsCount()) break block14;
                            $this$arguments$iv = $this$applyCallArguments;
                            boolean bl = false;
                            boolean bl2 = false;
                            $this$apply = (IrMemberAccessExpression)$this$arguments$iv;
                            boolean bl3 = false;
                            FirCall firCall = call2;
                            if (!((firCall instanceof FirFunctionCall ? (FirReference)((FirFunctionCall)call2).getCalleeReference() : (firCall instanceof FirDelegatedConstructorCall ? ((FirDelegatedConstructorCall)call2).getCalleeReference() : (firReference = firCall instanceof FirAnnotationCall ? ((FirAnnotationCall)call2).getCalleeReference() : null))) instanceof FirResolvedNamedReference)) {
                                firReference = null;
                            }
                            FirResolvedNamedReference firResolvedNamedReference = calleeReference = (FirResolvedNamedReference)firReference;
                            AbstractFirBasedSymbol<Object> abstractFirBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
                            if (!(abstractFirBasedSymbol instanceof FirFunctionSymbol)) {
                                abstractFirBasedSymbol = null;
                            }
                            FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)abstractFirBasedSymbol;
                            FirFunction firFunction = function2 = firFunctionSymbol != null ? (FirFunction)firFunctionSymbol.getFir() : null;
                            valueParameters2 = firFunction != null ? firFunction.getValueParameters() : null;
                            Object $this$argumentMapping$iv = call2;
                            boolean $i$f$getArgumentMapping = false;
                            FirArgumentList firArgumentList = $this$argumentMapping$iv.getArgumentList();
                            if (!(firArgumentList instanceof FirResolvedArgumentList)) {
                                firArgumentList = null;
                            }
                            FirResolvedArgumentList firResolvedArgumentList = (FirResolvedArgumentList)firArgumentList;
                            Map<FirExpression, FirValueParameter> map2 = argumentMapping = firResolvedArgumentList != null ? firResolvedArgumentList.getMapping() : null;
                            if (argumentMapping == null) break block15;
                            if (annotationMode) break block16;
                            $this$argumentMapping$iv = argumentMapping;
                            $i$f$getArgumentMapping = false;
                            if (!(!$this$argumentMapping$iv.isEmpty())) break block15;
                        }
                        if (valueParameters2 != null) {
                            return this.applyArgumentsWithReorderingIfNeeded($this$apply, argumentMapping, valueParameters2, annotationMode);
                        }
                    }
                    boolean $this$argumentMapping$iv = false;
                    FirCall $this$arguments$iv2 = call2;
                    boolean $i$f$getArguments = false;
                    for (FirExpression argument : (Iterable)$this$arguments$iv2.getArgumentList().getArguments()) {
                        void index2;
                        List<FirValueParameter> list2 = valueParameters2;
                        FirValueParameter valueParameter = list2 != null ? list2.get((int)index2) : null;
                        IrExpression argumentExpression = this.applyAssigningArrayElementsToVarargInNamedForm(this.applySamConversionIfNeeded(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, argument, false, 2, null), argument, valueParameter), argument, valueParameter);
                        $this$apply.putValueArgument((int)index2, argumentExpression);
                        ++index2;
                    }
                    object = $this$arguments$iv;
                    break block17;
                }
                Comparable name = $this$applyCallArguments instanceof IrCallImpl ? (Comparable)((IrSimpleFunction)((IrCallImpl)$this$applyCallArguments).getSymbol().getOwner()).getName() : (Comparable)((Object)"???");
                IrErrorCallExpressionImpl irErrorCallExpressionImpl = new IrErrorCallExpressionImpl($this$applyCallArguments.getStartOffset(), $this$applyCallArguments.getEndOffset(), $this$applyCallArguments.getType(), "Cannot bind " + argumentsCount + " arguments to " + name + " call with " + ((IrMemberAccessExpression)$this$applyCallArguments).getValueArgumentsCount() + " parameters");
                boolean bl = false;
                boolean $this$apply = false;
                IrErrorCallExpressionImpl $this$apply2 = irErrorCallExpressionImpl;
                boolean bl4 = false;
                FirCall $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                for (FirExpression argument : $this$arguments$iv.getArgumentList().getArguments()) {
                    $this$apply2.addArgument(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, argument, false, 2, null));
                }
                object = irErrorCallExpressionImpl;
                break block17;
            }
            if (irExpression instanceof IrErrorCallExpressionImpl) {
                IrExpression irExpression2 = $this$applyCallArguments;
                boolean bl = false;
                boolean bl5 = false;
                IrErrorCallExpressionImpl $this$apply = (IrErrorCallExpressionImpl)irExpression2;
                boolean bl6 = false;
                FirCall $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                for (FirExpression argument : $this$arguments$iv.getArgumentList().getArguments()) {
                    $this$apply.addArgument(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, argument, false, 2, null));
                }
                object = irExpression2;
            } else {
                object = $this$applyCallArguments;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression applyArgumentsWithReorderingIfNeeded(IrMemberAccessExpression<?> $this$applyArgumentsWithReorderingIfNeeded, Map<FirExpression, ? extends FirValueParameter> argumentMapping, List<? extends FirValueParameter> valueParameters2, boolean annotationMode) {
        if (!annotationMode && this.needArgumentReordering(argumentMapping.values(), valueParameters2)) {
            IrBlockImpl irBlockImpl = new IrBlockImpl($this$applyArgumentsWithReorderingIfNeeded.getStartOffset(), $this$applyArgumentsWithReorderingIfNeeded.getEndOffset(), $this$applyArgumentsWithReorderingIfNeeded.getType(), IrStatementOrigin.ARGUMENTS_REORDERING_FOR_CALL.INSTANCE);
            boolean bl = false;
            boolean bl2 = false;
            IrBlockImpl $this$apply = irBlockImpl;
            boolean bl3 = false;
            Object object = argumentMapping;
            boolean bl4 = false;
            Iterator<Map.Entry<FirExpression, ? extends FirValueParameter>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void argument;
                Map.Entry<FirExpression, ? extends FirValueParameter> entry;
                Map.Entry<FirExpression, ? extends FirValueParameter> entry2 = entry = iterator2.next();
                boolean bl5 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl5 = false;
                FirValueParameter parameter = entry2.getValue();
                int parameterIndex = valueParameters2.indexOf(parameter);
                IrExpression irArgument = this.applyAssigningArrayElementsToVarargInNamedForm(this.applySamConversionIfNeeded(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, (FirExpression)argument, false, 2, null), (FirExpression)argument, parameter), (FirExpression)argument, parameter);
                if (CallGeneratorKt.hasNoSideEffects(irArgument)) {
                    $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(parameterIndex, irArgument);
                    continue;
                }
                IrVariable irVariable2 = this.getDeclarationStorage().declareTemporaryVariable(irArgument, parameter.getName().asString());
                boolean bl6 = false;
                boolean bl7 = false;
                IrVariable $this$apply2 = irVariable2;
                boolean bl8 = false;
                $this$apply2.setParent(this.conversionScope.parentFromStack());
                IrVariable tempVar = irVariable2;
                $this$apply.getStatements().add(tempVar);
                $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(parameterIndex, new IrGetValueImpl($this$apply.getStartOffset(), $this$apply.getEndOffset(), tempVar.getSymbol(), null));
            }
            $this$apply.getStatements().add($this$applyArgumentsWithReorderingIfNeeded);
            return irBlockImpl;
        }
        Object object = argumentMapping;
        boolean $this$apply = false;
        Iterator<Map.Entry<FirExpression, ? extends FirValueParameter>> iterator3 = object.entrySet().iterator();
        while (iterator3.hasNext()) {
            void argument;
            Map.Entry<FirExpression, ? extends FirValueParameter> entry;
            Map.Entry<FirExpression, ? extends FirValueParameter> bl3 = entry = iterator3.next();
            boolean bl = false;
            object = bl3.getKey();
            bl3 = entry;
            bl = false;
            FirValueParameter parameter = bl3.getValue();
            IrExpression argumentExpression = this.applyAssigningArrayElementsToVarargInNamedForm(this.applySamConversionIfNeeded(this.visitor.convertToIrExpression$fir2ir((FirExpression)argument, annotationMode), (FirExpression)argument, parameter), (FirExpression)argument, parameter);
            $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(valueParameters2.indexOf(parameter), argumentExpression);
        }
        if (annotationMode) {
            boolean bl = false;
            for (FirValueParameter parameter : (Iterable)valueParameters2) {
                void index2;
                if (parameter.isVararg() && !argumentMapping.containsValue(parameter)) {
                    IrType elementType = this.toIrType(parameter.getReturnTypeRef());
                    $this$applyArgumentsWithReorderingIfNeeded.putValueArgument((int)index2, new IrVarargImpl(-1, -1, elementType, org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.toArrayOrPrimitiveArrayType(elementType, this.getIrBuiltIns())));
                }
                ++index2;
            }
        }
        return $this$applyArgumentsWithReorderingIfNeeded;
    }

    private final boolean needArgumentReordering(Collection<? extends FirValueParameter> parametersInActualOrder, List<? extends FirValueParameter> valueParameters2) {
        int lastValueParameterIndex = -1;
        for (FirValueParameter firValueParameter : parametersInActualOrder) {
            int index2 = valueParameters2.indexOf(firValueParameter);
            if (index2 < lastValueParameterIndex) {
                return true;
            }
            lastValueParameterIndex = index2;
        }
        return false;
    }

    private final IrExpression applySamConversionIfNeeded(IrExpression $this$applySamConversionIfNeeded, FirExpression argument, FirValueParameter parameter) {
        if (parameter == null || !this.needSamConversion(argument, parameter)) {
            return $this$applySamConversionIfNeeded;
        }
        IrType samType = this.toIrType(parameter.getReturnTypeRef());
        if (!ConversionUtilsKt.isSamType(samType)) {
            return $this$applySamConversionIfNeeded;
        }
        return new IrTypeOperatorCallImpl($this$applySamConversionIfNeeded.getStartOffset(), $this$applySamConversionIfNeeded.getEndOffset(), samType, IrTypeOperator.SAM_CONVERSION, samType, $this$applySamConversionIfNeeded);
    }

    private final boolean needSamConversion(FirExpression argument, FirValueParameter parameter) {
        FirTypeRef $this$coneType$iv = parameter.getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        if (InferenceUtilsKt.isBuiltinFunctionalType(coneKotlinType, this.getSession())) {
            return false;
        }
        return ArgumentsKt.isFunctional(argument, this.getSession());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression applyAssigningArrayElementsToVarargInNamedForm(IrExpression $this$applyAssigningArrayElementsToVarargInNamedForm, FirExpression argument, FirValueParameter parameter) {
        block11: {
            block10: {
                boolean bl;
                block9: {
                    if (!($this$applyAssigningArrayElementsToVarargInNamedForm instanceof IrVarargImpl)) break block10;
                    FirValueParameter firValueParameter = parameter;
                    if (firValueParameter == null) break block10;
                    if (!firValueParameter.isVararg()) break block10;
                    if (!(argument instanceof FirVarargArgumentsExpression)) break block10;
                    Iterable $this$none$iv = ((FirVarargArgumentsExpression)argument).getArguments();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirExpression it = (FirExpression)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof FirNamedArgumentExpression)) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block11;
            }
            return $this$applyAssigningArrayElementsToVarargInNamedForm;
        }
        Iterable $this$forEachIndexed$iv = ((IrVarargImpl)$this$applyAssigningArrayElementsToVarargInNamedForm).getElements();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irVarargElement;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrVarargElement irVarargElement2 = (IrVarargElement)item$iv;
            int i = n;
            boolean bl3 = false;
            if (irVarargElement instanceof IrSpreadElement || !(((FirVarargArgumentsExpression)argument).getArguments().get(i) instanceof FirNamedArgumentExpression) || !(irVarargElement instanceof IrExpression) || !IrTypePredicatesKt.isArray(((IrExpression)irVarargElement).getType())) continue;
            ((IrVarargImpl)$this$applyAssigningArrayElementsToVarargInNamedForm).getElements().set(i, new IrSpreadElementImpl(irVarargElement.getStartOffset(), irVarargElement.getEndOffset(), (IrExpression)irVarargElement));
        }
        return $this$applyAssigningArrayElementsToVarargInNamedForm;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression applyTypeArguments(IrExpression $this$applyTypeArguments, FirQualifiedAccess access) {
        IrExpression irExpression;
        IrExpression irExpression2 = $this$applyTypeArguments;
        if (irExpression2 instanceof IrMemberAccessExpression) {
            int argumentsCount = access.getTypeArguments().size();
            if (argumentsCount <= ((IrMemberAccessExpression)$this$applyTypeArguments).getTypeArgumentsCount()) {
                IrExpression irExpression3 = $this$applyTypeArguments;
                boolean bl = false;
                boolean bl2 = false;
                IrMemberAccessExpression $this$apply = (IrMemberAccessExpression)irExpression3;
                boolean bl3 = false;
                boolean bl4 = false;
                Iterator iterator2 = ((Iterable)access.getTypeArguments()).iterator();
                while (iterator2.hasNext()) {
                    void index2;
                    FirTypeProjection argument;
                    FirTypeProjection firTypeProjection = argument = (FirTypeProjection)iterator2.next();
                    if (firTypeProjection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance");
                    }
                    IrType argumentIrType = this.toIrType(((FirTypeProjectionWithVariance)firTypeProjection).getTypeRef());
                    $this$apply.putTypeArgument((int)index2, argumentIrType);
                    ++index2;
                }
                irExpression = irExpression3;
            } else {
                Comparable name = $this$applyTypeArguments instanceof IrCallImpl ? (Comparable)((IrSimpleFunction)((IrCallImpl)$this$applyTypeArguments).getSymbol().getOwner()).getName() : (Comparable)((Object)"???");
                irExpression = new IrErrorExpressionImpl($this$applyTypeArguments.getStartOffset(), $this$applyTypeArguments.getEndOffset(), $this$applyTypeArguments.getType(), "Cannot bind " + argumentsCount + " type arguments to " + name + " call with " + ((IrMemberAccessExpression)$this$applyTypeArguments).getTypeArgumentsCount() + " type parameters");
            }
        } else if (irExpression2 instanceof IrBlockImpl) {
            IrStatement lastStatement;
            IrExpression irExpression4 = $this$applyTypeArguments;
            boolean bl = false;
            boolean bl5 = false;
            IrBlockImpl $this$apply = (IrBlockImpl)irExpression4;
            boolean bl6 = false;
            Collection bl3 = $this$apply.getStatements();
            boolean bl7 = false;
            if (!bl3.isEmpty() && (lastStatement = (IrStatement)CollectionsKt.last($this$apply.getStatements())) instanceof IrExpression) {
                $this$apply.getStatements().set($this$apply.getStatements().size() - 1, this.applyTypeArguments((IrExpression)lastStatement, access));
            }
            irExpression = irExpression4;
        } else {
            irExpression = $this$applyTypeArguments;
        }
        return irExpression;
    }

    private final IrExpression findIrDispatchReceiver(FirQualifiedAccess $this$findIrDispatchReceiver, IrExpression explicitReceiverExpression) {
        return this.findIrReceiver($this$findIrDispatchReceiver, explicitReceiverExpression, true);
    }

    private final IrExpression findIrExtensionReceiver(FirQualifiedAccess $this$findIrExtensionReceiver, IrExpression explicitReceiverExpression) {
        return this.findIrReceiver($this$findIrExtensionReceiver, explicitReceiverExpression, false);
    }

    private final IrExpression findIrReceiver(FirQualifiedAccess $this$findIrReceiver, IrExpression explicitReceiverExpression, boolean isDispatch) {
        Object object;
        boolean bl;
        boolean bl2;
        FirStatement firStatement;
        block8: {
            block7: {
                FirExpression firReceiver;
                FirExpression firExpression2 = firReceiver = isDispatch ? $this$findIrReceiver.getDispatchReceiver() : $this$findIrReceiver.getExtensionReceiver();
                if (Intrinsics.areEqual((Object)firReceiver, (Object)$this$findIrReceiver.getExplicitReceiver())) {
                    return explicitReceiverExpression;
                }
                if (firReceiver instanceof FirResolvedQualifier) {
                    return this.convertToGetObject$fir2ir((FirResolvedQualifier)firReceiver, $this$findIrReceiver instanceof FirCallableReferenceAccess);
                }
                firStatement = firReceiver;
                bl2 = false;
                bl = false;
                FirExpression it = firStatement;
                boolean bl3 = false;
                object = !(it instanceof FirNoReceiverExpression) ? firStatement : null;
                if (object == null) break block7;
                firStatement = object;
                bl2 = false;
                bl = false;
                it = firStatement;
                boolean bl4 = false;
                object = Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, it, false, 2, null);
                if (object != null) break block8;
            }
            object = explicitReceiverExpression;
        }
        if (object == null) {
            firStatement = $this$findIrReceiver;
            bl2 = false;
            bl = false;
            FirStatement $this$run = firStatement;
            boolean bl5 = false;
            if ($this$run instanceof FirCallableReferenceAccess) {
                return null;
            }
            String name = isDispatch ? "Dispatch" : "Extension";
            String string2 = name + " receiver expected: " + FirRendererKt.render$default($this$run, null, 1, null) + " to " + FirRendererKt.render$default($this$run.getCalleeReference(), null, 1, null);
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return object;
    }

    private final IrExpression findBoundReceiver(FirQualifiedAccess $this$findBoundReceiver, IrExpression explicitReceiverExpression, boolean isDispatch) {
        FirExpression firReceiver;
        FirExpression firExpression2 = firReceiver = isDispatch ? $this$findBoundReceiver.getDispatchReceiver() : $this$findBoundReceiver.getExtensionReceiver();
        if (firReceiver instanceof FirNoReceiverExpression) {
            return null;
        }
        return this.findIrReceiver($this$findBoundReceiver, explicitReceiverExpression, isDispatch);
    }

    private final IrExpression applyReceivers(IrExpression $this$applyReceivers, FirQualifiedAccess qualifiedAccess, IrExpression explicitReceiverExpression) {
        IrExpression irExpression;
        IrExpression irExpression2 = $this$applyReceivers;
        if (irExpression2 instanceof IrMemberAccessExpression) {
            IrFunction ownerFunction;
            IrFunction irFunction2;
            IrSymbolOwner irSymbolOwner = ((IrMemberAccessExpression)$this$applyReceivers).getSymbol().getOwner();
            if (!(irSymbolOwner instanceof IrFunction)) {
                irSymbolOwner = null;
            }
            if ((irFunction2 = (IrFunction)irSymbolOwner) == null) {
                IrSymbolOwner irSymbolOwner2 = ((IrMemberAccessExpression)$this$applyReceivers).getSymbol().getOwner();
                if (!(irSymbolOwner2 instanceof IrProperty)) {
                    irSymbolOwner2 = null;
                }
                IrProperty irProperty2 = (IrProperty)irSymbolOwner2;
                irFunction2 = irProperty2 != null ? irProperty2.getGetter() : null;
            }
            IrFunction irFunction3 = ownerFunction = irFunction2;
            if ((irFunction3 != null ? irFunction3.getDispatchReceiverParameter() : null) != null) {
                ((IrMemberAccessExpression)$this$applyReceivers).setDispatchReceiver(this.findIrDispatchReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            IrFunction irFunction4 = ownerFunction;
            if ((irFunction4 != null ? irFunction4.getExtensionReceiverParameter() : null) != null) {
                ((IrMemberAccessExpression)$this$applyReceivers).setExtensionReceiver(this.findIrExtensionReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = $this$applyReceivers;
        } else if (irExpression2 instanceof IrFieldAccessExpression) {
            IrField ownerField = (IrField)((IrFieldAccessExpression)$this$applyReceivers).getSymbol().getOwner();
            if (!ownerField.isStatic()) {
                ((IrFieldAccessExpression)$this$applyReceivers).setReceiver(this.findIrDispatchReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = $this$applyReceivers;
        } else if (irExpression2 instanceof IrBlockImpl) {
            IrStatement lastStatement;
            IrExpression irExpression3 = $this$applyReceivers;
            boolean bl = false;
            boolean bl2 = false;
            IrBlockImpl $this$apply = (IrBlockImpl)irExpression3;
            boolean bl3 = false;
            Collection collection = $this$apply.getStatements();
            boolean bl4 = false;
            if (!collection.isEmpty() && (lastStatement = (IrStatement)CollectionsKt.last($this$apply.getStatements())) instanceof IrExpression) {
                $this$apply.getStatements().set($this$apply.getStatements().size() - 1, this.applyReceivers((IrExpression)lastStatement, qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = irExpression3;
        } else {
            irExpression = $this$applyReceivers;
        }
        return irExpression;
    }

    private final IrErrorCallExpression generateErrorCallExpression(int startOffset, int endOffset, FirReference calleeReference, IrType type2) {
        IrType irType = type2;
        if (irType == null) {
            irType = ConversionUtilsKt.createErrorType();
        }
        return new IrErrorCallExpressionImpl(startOffset, endOffset, irType, "Unresolved reference: " + FirRendererKt.render$default(calleeReference, null, 1, null));
    }

    static /* synthetic */ IrErrorCallExpression generateErrorCallExpression$default(CallAndReferenceGenerator callAndReferenceGenerator, int n, int n2, FirReference firReference, IrType irType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            irType = null;
        }
        return callAndReferenceGenerator.generateErrorCallExpression(n, n2, firReference, irType);
    }

    public CallAndReferenceGenerator(@NotNull Fir2IrComponents components, @NotNull Fir2IrVisitor visitor2, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.components = components;
        this.visitor = visitor2;
        this.conversionScope = conversionScope;
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    public static final /* synthetic */ boolean access$requiresVarargSpread(CallAndReferenceGenerator $this, FirCallableReferenceAccess callableReferenceAccess, IrSimpleType type2, IrFunction function2) {
        return $this.requiresVarargSpread(callableReferenceAccess, type2, function2);
    }

    public static final /* synthetic */ boolean access$requiresCoercionToUnit(CallAndReferenceGenerator $this, IrSimpleType type2, IrFunction function2) {
        return $this.requiresCoercionToUnit(type2, function2);
    }

    public static final /* synthetic */ boolean access$requiresSuspendConversion(CallAndReferenceGenerator $this, IrSimpleType type2, IrFunction function2) {
        return $this.requiresSuspendConversion(type2, function2);
    }

    public static final /* synthetic */ IrSimpleType access$kFunctionTypeToFunctionType(CallAndReferenceGenerator $this, ConeKotlinType $this$access_u24kFunctionTypeToFunctionType) {
        return $this.kFunctionTypeToFunctionType($this$access_u24kFunctionTypeToFunctionType);
    }

    public static final /* synthetic */ IrExpression access$generateAdaptedCallableReference(CallAndReferenceGenerator $this, FirCallableReferenceAccess callableReferenceAccess, IrExpression explicitReceiverExpression, IrFunctionSymbol adapteeSymbol, IrSimpleType type2) {
        return $this.generateAdaptedCallableReference(callableReferenceAccess, explicitReceiverExpression, adapteeSymbol, type2);
    }

    public static final /* synthetic */ IrExpression access$findBoundReceiver(CallAndReferenceGenerator $this, FirQualifiedAccess $this$access_u24findBoundReceiver, IrExpression explicitReceiverExpression, boolean isDispatch) {
        return $this.findBoundReceiver($this$access_u24findBoundReceiver, explicitReceiverExpression, isDispatch);
    }

    public static final /* synthetic */ IrSimpleFunction access$createAdapterFunction(CallAndReferenceGenerator $this, FirCallableReferenceAccess callableReferenceAccess, int startOffset, int endOffset, FirSimpleFunction firAdaptee, IrFunction adaptee, IrSimpleType type2, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        return $this.createAdapterFunction(callableReferenceAccess, startOffset, endOffset, firAdaptee, adaptee, type2, boundDispatchReceiver, boundExtensionReceiver);
    }

    public static final /* synthetic */ IrExpression access$createAdapteeCall(CallAndReferenceGenerator $this, FirCallableReferenceAccess callableReferenceAccess, IrFunctionSymbol adapteeSymbol, IrFunction adapterFunction, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        return $this.createAdapteeCall(callableReferenceAccess, adapteeSymbol, adapterFunction, boundDispatchReceiver, boundExtensionReceiver);
    }

    public static final /* synthetic */ Fir2IrConversionScope access$getConversionScope$p(CallAndReferenceGenerator $this) {
        return $this.conversionScope;
    }

    public static final /* synthetic */ IrValueParameter access$createAdapterParameter(CallAndReferenceGenerator $this, IrFunction adapterFunction, Name name, int index2, IrType type2) {
        return $this.createAdapterParameter(adapterFunction, name, index2, type2);
    }

    public static final /* synthetic */ Fir2IrVisitor access$getVisitor$p(CallAndReferenceGenerator $this) {
        return $this.visitor;
    }

    public static final /* synthetic */ IrClassSymbol access$superQualifierSymbol(CallAndReferenceGenerator $this, FirExpression $this$access_u24superQualifierSymbol, IrSymbol callSymbol) {
        return $this.superQualifierSymbol($this$access_u24superQualifierSymbol, callSymbol);
    }

    public static final /* synthetic */ IrErrorCallExpression access$generateErrorCallExpression(CallAndReferenceGenerator $this, int startOffset, int endOffset, FirReference calleeReference, IrType type2) {
        return $this.generateErrorCallExpression(startOffset, endOffset, calleeReference, type2);
    }
}

