/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirLightModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirLightModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierListKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirPsiModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J \u0010\u0017\u001a\u00020\u000b*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020 0\u0018H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "containingPropertyVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getContainingPropertyVisibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "isLocalMember", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "check", "", "declaration", "context", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "hasModifier", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "implicitVisibility", "visibility", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visibilityOrNull", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirLightModifier;", "checkers"})
public final class RedundantVisibilityModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierChecker INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$report$iv;
        void source$iv;
        FirSourceElement firSourceElement;
        Visibility visibility;
        FirDeclaration firDeclaration;
        Visibility implicitVisibility;
        Visibility visibilityModifier;
        FirModifierList modifiers2;
        block20: {
            Visibility visibility2;
            FirModifierList firModifierList;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration2 instanceof FirConstructor) {
                FirSourceElement firSourceElement2 = declaration2.getSource();
                if ((firSourceElement2 != null ? firSourceElement2.getKind() : null) instanceof FirFakeSourceElementKind) {
                    return;
                }
            }
            if (declaration2.getSource() instanceof FirFakeSourceElement) {
                return;
            }
            if (!(declaration2 instanceof FirMemberDeclaration)) {
                if (!(declaration2 instanceof FirPropertyAccessor)) return;
                FirPropertyAccessor $this$visibility$iv = (FirPropertyAccessor)declaration2;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)this.getContainingPropertyVisibility(context2))) {
                    return;
                }
            }
            if ((firModifierList = (modifiers2 = FirModifierListKt.getModifierList(declaration2.getSource()))) instanceof FirPsiModifierList) {
                visibility2 = FirHelpersKt.getVisibility(((FirPsiModifierList)modifiers2).getModifierList());
            } else {
                if (!(firModifierList instanceof FirLightModifierList)) return;
                visibility2 = this.visibilityOrNull(((FirLightModifierList)modifiers2).getModifiers());
            }
            if (visibility2 == null) return;
            visibilityModifier = visibility2;
            implicitVisibility = this.implicitVisibility(declaration2, context2);
            CheckerContext this_$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed(this_$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirMemberDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((firDeclaration = (FirDeclaration)((FirMemberDeclaration)firDeclaration2)) == null) {
                    continue;
                }
                break block20;
            }
            firDeclaration = null;
        }
        FirMemberDeclaration containingMemberDeclaration = (FirMemberDeclaration)firDeclaration;
        if (Intrinsics.areEqual((Object)visibilityModifier, (Object)implicitVisibility)) {
            visibility = implicitVisibility;
        } else {
            FirModifierList firModifierList = modifiers2;
            List<FirModifier<Object>> list2 = firModifierList != null ? firModifierList.getModifiers() : null;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.INTERNAL_KEYWORD");
            if (!this.hasModifier(list2, ktModifierKeywordToken)) return;
            FirMemberDeclaration $i$f$findClosest = containingMemberDeclaration;
            boolean bl = false;
            boolean it$iv = false;
            FirMemberDeclaration decl = $i$f$findClosest;
            boolean bl2 = false;
            if (decl == null) return;
            if (!INSTANCE.isLocalMember(decl)) {
                FirModifierList firModifierList2 = modifiers2;
                List<FirModifier<Object>> list3 = firModifierList2 != null ? firModifierList2.getModifiers() : null;
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.PRIVATE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"KtTokens.PRIVATE_KEYWORD");
                if (!INSTANCE.hasModifier(list3, ktModifierKeywordToken2)) return;
            }
            boolean bl3 = true;
            if (!bl3) return;
            visibility = Visibilities.Internal.INSTANCE;
        }
        Visibility redundantVisibility = visibility;
        if (Intrinsics.areEqual((Object)redundantVisibility, (Object)Visibilities.Public.INSTANCE) && declaration2 instanceof FirProperty) {
            FirModifierList firModifierList = modifiers2;
            List<FirModifier<Object>> list4 = firModifierList != null ? firModifierList.getModifiers() : null;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            if (this.hasModifier(list4, ktModifierKeywordToken) && ((FirProperty)declaration2).isVar()) {
                Visibility visibility3;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration2).getSetter();
                if (firPropertyAccessor != null) {
                    FirPropertyAccessor $this$visibility$iv = firPropertyAccessor;
                    boolean $i$f$getVisibility = false;
                    visibility3 = $this$visibility$iv.getStatus().getVisibility();
                } else {
                    visibility3 = null;
                }
                if (Intrinsics.areEqual(visibility3, (Object)Visibilities.Public.INSTANCE)) {
                    return;
                }
            }
        }
        DiagnosticReporter $this$visibility$iv = reporter;
        FirSourceElement firSourceElement3 = declaration2.getSource();
        if (firSourceElement3 != null) {
            TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"KtTokens.VISIBILITY_MODIFIERS");
            firSourceElement = FirSourceChildrenKt.getChild$default(firSourceElement3, tokenSet, 0, 0, 6, null);
        } else {
            firSourceElement = null;
        }
        FirSourceElement $i$f$getVisibility = firSourceElement;
        FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER();
        boolean $i$f$report = false;
        void v20 = source$iv;
        if (v20 == null) return;
        void var13_22 = v20;
        boolean bl = false;
        boolean bl4 = false;
        void it$iv = var13_22;
        boolean bl5 = false;
        $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context2) {
        FirDeclaration firDeclaration;
        Object object;
        block11: {
            Iterator iterator2;
            if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && ((FirPropertyAccessor)$this$implicitVisibility).getStatus().isOverride()) {
                FirPropertyAccessor $this$visibility$iv = (FirPropertyAccessor)$this$implicitVisibility;
                boolean $i$f$getVisibility = false;
                object = $this$visibility$iv.getStatus().getVisibility();
                return object;
            }
            if ($this$implicitVisibility instanceof FirPropertyAccessor) {
                CheckerContext this_$iv = context2;
                boolean $i$f$findClosest = false;
                iterator2 = CollectionsKt.asReversed(this_$iv.getContainingDeclarations()).iterator();
            } else {
                if ($this$implicitVisibility instanceof FirConstructor) {
                    FirClassLikeDeclaration<?> clazz = FirHelpersKt.getContainingClass((FirSymbolOwner)((Object)$this$implicitVisibility), context2);
                    if (clazz instanceof FirClass && (((FirClass)clazz).getClassKind() == ClassKind.ENUM_CLASS || FirHelpersKt.modality((FirClass)clazz) == Modality.SEALED)) {
                        object = Visibilities.Private.INSTANCE;
                        return object;
                    }
                    object = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                    return object;
                }
                if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        object = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context2);
                        return object;
                    }
                }
                object = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                return object;
            }
            while (iterator2.hasNext()) {
                FirDeclaration it$iv = (FirDeclaration)iterator2.next();
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirProperty)) {
                    firDeclaration2 = null;
                }
                if ((firDeclaration = (FirDeclaration)((FirProperty)firDeclaration2)) == null) continue;
                break block11;
            }
            firDeclaration = null;
        }
        if ((object = (FirProperty)firDeclaration) != null) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)object;
            boolean $i$f$getVisibility = false;
            object = $this$visibility$iv.getStatus().getVisibility();
            if (object != null) {
                return object;
            }
        }
        object = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
        return object;
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context2) {
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Visibilities.Unknown.INSTANCE;
        }
        FirClass<?> currentClass = firClass;
        List<FirFunctionSymbol<?>> overriddenFunctions2 = FirHelpersKt.overriddenFunctions(function2, currentClass, context2);
        Visibility visibility = Visibilities.Private.INSTANCE;
        for (FirFunctionSymbol<?> func : overriddenFunctions2) {
            Integer compareResult;
            Visibility currentVisibility = this.visibility((FirFunction)func.getFir());
            if (currentVisibility == null || (compareResult = Visibilities.INSTANCE.compare(currentVisibility, visibility)) == null || compareResult <= 0) continue;
            visibility = currentVisibility;
        }
        return visibility;
    }

    private final Visibility visibility(FirFunction<?> $this$visibility) {
        Object object;
        Object e;
        boolean $i$f$getVisibility;
        Object $this$visibility$iv;
        Object object2;
        Object e2 = $this$visibility.getSymbol().getFir();
        if (!(e2 instanceof FirMemberDeclaration)) {
            e2 = null;
        }
        if ((object2 = (FirMemberDeclaration)e2) != null) {
            $this$visibility$iv = object2;
            $i$f$getVisibility = false;
            object2 = $this$visibility$iv.getStatus().getVisibility();
            if (object2 != null) {
                $this$visibility$iv = object2;
                $i$f$getVisibility = false;
                boolean bl = false;
                Object it = $this$visibility$iv;
                boolean bl2 = false;
                return it;
            }
        }
        if (!((e = $this$visibility.getSymbol().getFir()) instanceof FirPropertyAccessor)) {
            e = null;
        }
        if ((object = (FirPropertyAccessor)e) != null) {
            $this$visibility$iv = object;
            $i$f$getVisibility = false;
            object = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            if (object != null) {
                Object object3 = object;
                boolean bl = false;
                boolean bl3 = false;
                Object it = object3;
                boolean bl4 = false;
                return it;
            }
        }
        return null;
    }

    private final boolean isLocalMember(FirMemberDeclaration $this$isLocalMember) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = $this$isLocalMember;
        if (firMemberDeclaration instanceof FirProperty) {
            bl = ((FirProperty)$this$isLocalMember).isLocal();
        } else if (firMemberDeclaration instanceof FirRegularClass) {
            FirRegularClass $this$isLocal$iv = (FirRegularClass)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getSymbol().getClassId().isLocal();
        } else if (firMemberDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    private final Visibility getContainingPropertyVisibility(CheckerContext $this$containingPropertyVisibility) {
        Visibility visibility;
        Object object = CollectionsKt.last($this$containingPropertyVisibility.getContainingDeclarations());
        if (!(object instanceof FirProperty)) {
            object = null;
        }
        FirProperty firProperty = (FirProperty)object;
        if (firProperty != null) {
            FirMemberDeclaration $this$visibility$iv = firProperty;
            boolean $i$f$getVisibility = false;
            visibility = $this$visibility$iv.getStatus().getVisibility();
        } else {
            visibility = null;
        }
        return visibility;
    }

    private final Visibility visibilityOrNull(List<FirLightModifier> $this$visibilityOrNull) {
        Object object;
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$visibilityOrNull;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirLightModifier it = (FirLightModifier)element$iv;
                boolean bl = false;
                if (!(FirHelpersKt.toVisibilityOrNull(it.getToken()) != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (object = (FirLightModifier)v0) != null && (object = ((FirModifier)object).getToken()) != null ? FirHelpersKt.toVisibilityOrNull((KtModifierKeywordToken)object) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasModifier(List<? extends FirModifier<?>> $this$hasModifier, KtModifierKeywordToken token) {
        FirModifier it;
        if ($this$hasModifier == null) return false;
        Iterable $this$any$iv = $this$hasModifier;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FirModifier)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it.getToken(), (Object)token));
        return true;
    }

    private RedundantVisibilityModifierChecker() {
    }

    static {
        RedundantVisibilityModifierChecker redundantVisibilityModifierChecker;
        INSTANCE = redundantVisibilityModifierChecker = new RedundantVisibilityModifierChecker();
    }
}

