/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.CheckResult;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/OperatorModifierChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkSupportsFeature", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "modifier", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class OperatorModifierChecker {
    @NotNull
    public static final OperatorModifierChecker INSTANCE;

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!functionDescriptor2.isOperator()) {
            return;
        }
        PsiElement psiElement = declaration2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OPERATOR_KEYWORD)) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.modifierList\u2026ERATOR_KEYWORD) ?: return");
        PsiElement modifier = psiElement;
        CheckResult checkResult = OperatorChecks.INSTANCE.check(functionDescriptor2);
        if (checkResult.isSuccess()) {
            Name name = functionDescriptor2.getName();
            if (((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains(name)) {
                this.checkSupportsFeature(LanguageFeature.OperatorRem, languageVersionSettings, diagnosticHolder, modifier);
            } else if (Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.PROVIDE_DELEGATE)) {
                this.checkSupportsFeature(LanguageFeature.OperatorProvideDelegate, languageVersionSettings, diagnosticHolder, modifier);
            }
            if (((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.values()).contains(functionDescriptor2.getName()) && languageVersionSettings.supportsFeature(LanguageFeature.OperatorRem)) {
                Name newNameConvention;
                DiagnosticFactory2<PsiElement, FunctionDescriptor, String> diagnosticFactory = !KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && languageVersionSettings.supportsFeature(LanguageFeature.ProhibitOperatorMod) ? Errors.FORBIDDEN_BINARY_MOD : Errors.DEPRECATED_BINARY_MOD;
                Name name2 = newNameConvention = (Name)((ImmutableMap)((Object)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.inverse())).get(functionDescriptor2.getName());
                Intrinsics.checkNotNull((Object)name2);
                diagnosticHolder.report(diagnosticFactory.on(modifier, functionDescriptor2, name2.asString()));
            }
            return;
        }
        CheckResult checkResult2 = checkResult;
        if (!(checkResult2 instanceof CheckResult.IllegalSignature)) {
            checkResult2 = null;
        }
        if ((object = (CheckResult.IllegalSignature)checkResult2) == null || (object = ((CheckResult.IllegalSignature)object).getError()) == null) {
            object = "illegal function name";
        }
        Object errorDescription = object;
        diagnosticHolder.report(Errors.INAPPLICABLE_OPERATOR_MODIFIER.on(modifier, (String)errorDescription));
    }

    private final void checkSupportsFeature(LanguageFeature feature, LanguageVersionSettings languageVersionSettings, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        if (!languageVersionSettings.supportsFeature(feature)) {
            diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(modifier, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)feature), (Object)languageVersionSettings)));
        }
    }

    private OperatorModifierChecker() {
    }

    static {
        OperatorModifierChecker operatorModifierChecker;
        INSTANCE = operatorModifierChecker = new OperatorModifierChecker();
    }
}

