/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunctionKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NonIEEE754FloatComparison;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "primitiveNumberType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "operatorToken", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "(Lorg/jetbrains/kotlin/builtins/PrimitiveType;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm"})
public final class PrimitiveComparison
extends IntrinsicMethod {
    private final PrimitiveType primitiveNumberType;
    private final KtSingleValueToken operatorToken;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        void left;
        List<IrExpression> list2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(this.primitiveNumberType);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jvmPrimitiveType), (String)"JvmPrimitiveType.get(primitiveNumberType)");
        Type parameterType = Type.getType(jvmPrimitiveType.getDesc());
        List<IrExpression> list3 = list2 = IrIntrinsicFunctionKt.receiverAndArgs(expression2);
        boolean bl = false;
        IrExpression irExpression = list3.get(0);
        list3 = list2;
        bl = false;
        IrExpression right = list3.get(1);
        PromisedValue promisedValue = (PromisedValue)left.accept(codegen2, data);
        Type type2 = parameterType;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"parameterType");
        MaterialValue a = PromisedValueKt.materializedAt(promisedValue, type2, left.getType());
        MaterialValue b = PromisedValueKt.materializedAt((PromisedValue)right.accept(codegen2, data), parameterType, right.getType());
        boolean useNonIEEE754Comparison = !(codegen2.getContext().getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons) || !Intrinsics.areEqual((Object)parameterType, (Object)Type.FLOAT_TYPE) && !Intrinsics.areEqual((Object)parameterType, (Object)Type.DOUBLE_TYPE) || !IrUtilsKt.isSmartcastFromHigherThanNullable((IrExpression)left, codegen2.getContext()) && !IrUtilsKt.isSmartcastFromHigherThanNullable(right, codegen2.getContext()));
        return useNonIEEE754Comparison ? (PromisedValue)new NonIEEE754FloatComparison(this.operatorToken, a, b) : (PromisedValue)new BooleanComparison(this.operatorToken, a, b);
    }

    public PrimitiveComparison(@NotNull PrimitiveType primitiveNumberType, @NotNull KtSingleValueToken operatorToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveNumberType), (String)"primitiveNumberType");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        this.primitiveNumberType = primitiveNumberType;
        this.operatorToken = operatorToken;
    }
}

