/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmStandardLibraryBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "coerceIfPossible", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "backend.jvm"})
public final class JvmStandardLibraryBuiltInsLowering
implements FileLoweringPass {
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> jvm8builtInReplacements;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getState().getTarget().compareTo((Enum)JvmTarget.JVM_1_8) < 0) {
            return;
        }
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(this){
            final /* synthetic */ JvmStandardLibraryBuiltInsLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                expression2.transformChildren(this, null);
                String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(((IrSimpleFunction)expression2.getSymbol().getOwner()).getParent()).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expression.symbol.owner.\u2026rSerialization.asString()");
                String parentClass = string2;
                String string3 = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"expression.symbol.owner.name.asString()");
                String functionName = string3;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)JvmStandardLibraryBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to((Object)parentClass, (Object)functionName));
                if (irSimpleFunctionSymbol != null) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrSimpleFunctionSymbol replacement = irSimpleFunctionSymbol2;
                    boolean bl3 = false;
                    return JvmStandardLibraryBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, replacement);
                }
                return expression2;
            }
            {
                this.this$0 = this$0;
            }
        };
        irFile.transformChildren(transformer2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        int n;
        IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$replaceWithCallTo.getStartOffset(), $this$replaceWithCallTo.getEndOffset(), $this$replaceWithCallTo.getType(), replacement, 0, 0, null, null, 240, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl newCall = irCallImpl;
        boolean bl3 = false;
        int valueArgumentOffset = 0;
        IrExpression irExpression = $this$replaceWithCallTo.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression irExpression2 = irExpression;
            n = 0;
            boolean bl4 = false;
            IrExpression it = irExpression2;
            boolean bl5 = false;
            IrExpression irExpression3 = this.coerceIfPossible(it, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get(valueArgumentOffset).getType());
            if (irExpression3 == null) {
                return $this$replaceWithCallTo;
            }
            IrExpression coercedDispatchReceiver = irExpression3;
            newCall.putValueArgument(valueArgumentOffset, coercedDispatchReceiver);
            int n2 = valueArgumentOffset;
            valueArgumentOffset = n2 + 1;
        }
        int n3 = 0;
        n = $this$replaceWithCallTo.getValueArgumentsCount();
        while (n3 < n) {
            IrExpression coercedValueArgument;
            void index2;
            IrExpression irExpression4 = $this$replaceWithCallTo.getValueArgument((int)index2);
            Intrinsics.checkNotNull((Object)irExpression4);
            if (this.coerceIfPossible(irExpression4, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get((int)index2).getType()) == null) {
                return $this$replaceWithCallTo;
            }
            newCall.putValueArgument((int)(index2 + valueArgumentOffset), coercedValueArgument);
            ++index2;
        }
        return irCallImpl;
    }

    private final IrExpression coerceIfPossible(IrExpression $this$coerceIfPossible, IrType toType) {
        IrExpression irExpression;
        Type toJvmType;
        Type fromJvmType = IrTypeMapper.mapType$default(this.context.getTypeMapper(), $this$coerceIfPossible.getType(), null, null, 6, null);
        if (Intrinsics.areEqual((Object)fromJvmType, (Object)(toJvmType = IrTypeMapper.mapType$default(this.context.getTypeMapper(), toType, null, null, 6, null))) ^ true) {
            irExpression = null;
        } else {
            IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$coerceIfPossible.getStartOffset(), $this$coerceIfPossible.getEndOffset(), toType, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl call2 = irCallImpl;
            boolean bl3 = false;
            call2.putTypeArgument(0, $this$coerceIfPossible.getType());
            call2.putTypeArgument(1, toType);
            call2.putValueArgument(0, $this$coerceIfPossible);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmStandardLibraryBuiltInsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.jvm8builtInReplacements = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"compareTo"), (Object)this.context.getIr().getSymbols().getCompareUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"div"), (Object)this.context.getIr().getSymbols().getDivideUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"rem"), (Object)this.context.getIr().getSymbols().getRemainderUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"toString"), (Object)this.context.getIr().getSymbols().getToUnsignedStringInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"compareTo"), (Object)this.context.getIr().getSymbols().getCompareUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"div"), (Object)this.context.getIr().getSymbols().getDivideUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"rem"), (Object)this.context.getIr().getSymbols().getRemainderUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"toString"), (Object)this.context.getIr().getSymbols().getToUnsignedStringLong())});
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmStandardLibraryBuiltInsLowering $this) {
        return $this.jvm8builtInReplacements;
    }

    public static final /* synthetic */ IrCall access$replaceWithCallTo(JvmStandardLibraryBuiltInsLowering $this, IrCall $this$access_u24replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($this$access_u24replaceWithCallTo, replacement);
    }
}

