/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.lower.WasmSignature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020#0.2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e0.2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020#0.2\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00108\u001a\u00020\u000bH\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010:\u001a\u00020;H\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010=\u001a\u00020\u0015H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020(0.2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\u0018\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010B\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u000bH\u0016J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020@H\u0016J\u0010\u0010D\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010K\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020NH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContextImpl;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "addExport", "", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "addJsFun", "importName", "", "jsCode", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "defineGlobal", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineRTT", "irClass", "defineStructType", "wasmStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "generateTypeInfo", "typeInfo", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "getClassMetadata", "getStructFieldRef", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "referenceClassId", "referenceClassRTT", "referenceFunction", "referenceFunctionType", "referenceGlobal", "referenceInterfaceId", "irInterface", "referenceSignatureId", "signature", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmSignature;", "referenceStringLiteral", "string", "referenceStructType", "referenceVirtualFunctionId", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "registerClass", "registerInterface", "registerVirtualFunction", "setStartFunction", "transformBlockResultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformBoxedType", "transformResultType", "transformType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.wasm"})
public final class WasmModuleCodegenContextImpl
implements WasmModuleCodegenContext {
    private final WasmTypeTransformer typeTransformer;
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;
    @NotNull
    private final WasmBackendContext backendContext;
    private final WasmCompiledModuleFragment wasmFragment;

    @Override
    @NotNull
    public WasmType transformType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        boolean bl2 = false;
        WasmTypeTransformer $this$with = wasmTypeTransformer;
        boolean bl3 = false;
        return $this$with.toWasmValueType(irType);
    }

    @Override
    @NotNull
    public WasmType transformBoxedType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        boolean bl2 = false;
        WasmTypeTransformer $this$with = wasmTypeTransformer;
        boolean bl3 = false;
        return $this$with.toBoxedInlineClassType(irType);
    }

    @Override
    @NotNull
    public WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter((Object)irValueParameter, (String)"irValueParameter");
        WasmTypeTransformer wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        boolean bl2 = false;
        WasmTypeTransformer $this$with = wasmTypeTransformer;
        boolean bl3 = false;
        return $this$with.getContext().getBackendContext().getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$with.toBoxedInlineClassType(irValueParameter.getType()) : $this$with.toWasmValueType(irValueParameter.getType());
    }

    @Override
    @Nullable
    public WasmType transformResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        boolean bl2 = false;
        WasmTypeTransformer $this$with = wasmTypeTransformer;
        boolean bl3 = false;
        return $this$with.toWasmResultType(irType);
    }

    @Override
    @Nullable
    public WasmType transformBlockResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        boolean bl2 = false;
        WasmTypeTransformer $this$with = wasmTypeTransformer;
        boolean bl3 = false;
        return $this$with.toWasmBlockResultType(irType);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceStringLiteral(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        this.wasmFragment.getStringLiterals().add(string2);
        return this.wasmFragment.getStringLiteralId().reference(string2);
    }

    @Override
    public void generateTypeInfo(@NotNull IrClassSymbol irClass2, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass2, typeInfo);
    }

    @Override
    public void setStartFunction(@NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        this.wasmFragment.setStartFunction(wasmFunction);
    }

    @Override
    public void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, (String)"wasmExport");
        Collection collection = this.wasmFragment.getExports();
        boolean bl = false;
        collection.add(wasmExport);
    }

    @Override
    public void registerVirtualFunction(@NotNull IrSimpleFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Collection collection = this.wasmFragment.getVirtualFunctions();
        boolean bl = false;
        collection.add(irFunction);
    }

    @Override
    public void registerInterface(@NotNull IrClassSymbol irInterface) {
        Intrinsics.checkNotNullParameter((Object)irInterface, (String)"irInterface");
        Collection collection = this.wasmFragment.getInterfaces();
        boolean bl = false;
        collection.add(irInterface);
    }

    @Override
    public void registerClass(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Collection collection = this.wasmFragment.getClasses();
        boolean bl = false;
        collection.add(irClass2);
    }

    @Override
    public void defineFunction(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction, wasmFunction);
    }

    @Override
    public void defineGlobal(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobals().define(irField, wasmGlobal);
    }

    @Override
    public void defineStructType(@NotNull IrClassSymbol irClass2, @NotNull WasmStructDeclaration wasmStruct) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmStruct, (String)"wasmStruct");
        this.wasmFragment.getStructTypes().define(irClass2, wasmStruct);
    }

    @Override
    public void defineRTT(@NotNull IrClassSymbol irClass2, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getRuntimeTypes().define(irClass2, wasmGlobal);
    }

    @Override
    public void defineFunctionType(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunctionType, (String)"wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction, wasmFunctionType);
    }

    @Override
    @NotNull
    public ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass2) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            IrClass superClass2;
            boolean bl = false;
            IrClass irClass3 = superClass2 = ClassInfoKt.getSuperClass((IrClass)irClass2.getOwner(), this.getBackendContext().getIrBuiltIns());
            if (irClass3 != null) {
                IrClass irClass4 = irClass3;
                boolean bl2 = false;
                boolean bl3 = false;
                IrClass it = irClass4;
                boolean bl4 = false;
                classMetadata2 = this.getClassMetadata((IrClassSymbol)it.getSymbol());
            } else {
                classMetadata2 = null;
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass2.getOwner(), superClassMetadata, this.getBackendContext().getIrBuiltIns());
            $this$getOrPut$iv.put(irClass2, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceGlobal(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        return this.wasmFragment.getGlobals().reference(irField);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmStructDeclaration> referenceStructType(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        IrType type2 = IrTypesKt.getDefaultType(irClass2);
        boolean bl = !IrTypePredicatesKt.isNothing(type2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can't reference Nothing type";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getStructTypes().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceClassRTT(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getRuntimeTypes().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceClassId(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getClassIds().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceInterfaceId(@NotNull IrClassSymbol irInterface) {
        Intrinsics.checkNotNullParameter((Object)irInterface, (String)"irInterface");
        IrType defaultType = IrTypesKt.getDefaultType(irInterface);
        if (IrTypeUtilsKt.isFunction(defaultType)) {
            int n = ((IrClass)irInterface.getOwner()).getTypeParameters().size() - 1;
            return this.wasmFragment.getInterfaceId().reference(this.getBackendContext().getWasmSymbols().functionN(n));
        }
        return this.wasmFragment.getInterfaceId().reference(irInterface);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceVirtualFunctionId(@NotNull IrSimpleFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        if (((IrSimpleFunction)irFunction.getOwner()).getModality() == Modality.ABSTRACT) {
            String string2 = "Abstract functions are not stored in table";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return this.wasmFragment.getVirtualFunctionId().reference(irFunction);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceSignatureId(@NotNull WasmSignature signature2) {
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        this.wasmFragment.getSignatures().add(signature2);
        return this.wasmFragment.getSignatureId().reference(signature2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        IrClass klass = IrUtilsKt.getParentAsClass(field);
        ClassMetadata metadata = this.getClassMetadata((IrClassSymbol)klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field);
        return new WasmSymbol<Integer>(fieldId);
    }

    @Override
    public void addJsFun(@NotNull String importName, @NotNull String jsCode2) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)jsCode2, (String)"jsCode");
        Collection collection = this.wasmFragment.getJsFuns();
        WasmCompiledModuleFragment.JsCodeSnippet jsCodeSnippet = new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode2);
        boolean bl = false;
        collection.add(jsCodeSnippet);
    }

    @Override
    @NotNull
    public WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    public WasmModuleCodegenContextImpl(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFragment, (String)"wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.getBackendContext().getIrBuiltIns());
        boolean bl = false;
        this.classMetadataCache = new LinkedHashMap();
    }
}

