/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt$WhenMappings;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierListKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\t\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\u0006\u001a \u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u0013*\u00020\u0014H\u0086\b\u00a2\u0006\u0002\u0010\u0015\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u0018\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u001aH\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0005\u001a\u001a\u0010 \u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0005\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u0005\u001a\u0014\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#*\u00020\u001aH\u0002\u001a(\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0#*\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\t\u001a\u00020\u0006\u001a\u0014\u0010)\u001a\u0004\u0018\u00010**\u00020+2\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010)\u001a\u0004\u0018\u00010**\u00020,2\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010)\u001a\u0004\u0018\u00010**\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010-\u001a\u00020$*\u00020\u001c\u001a\f\u0010.\u001a\u0004\u0018\u00010\u0017*\u00020$\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006/"}, d2={"isIterator", "", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "findNonInterfaceSupertype", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "context", "followAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "followAllAlias", "getContainingClass", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "getDeclaration", "T", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Ljava/lang/Object;", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "hasBody", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isSuperclassOf", "other", "isSupertypeOf", "modality", "modifierListOrNull", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "overriddenFunctions", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "containingClass", "toRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toToken", "toVisibilityOrNull", "checkers"})
public final class FirHelpersKt {
    public static final boolean isSuperclassOf(@NotNull FirClass<?> $this$isSuperclassOf, @NotNull FirClass<?> other) {
        Intrinsics.checkNotNullParameter($this$isSuperclassOf, (String)"$this$isSuperclassOf");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        isSuperclassOf.1 $fun$isSuperclassOf$1 = isSuperclassOf.1.INSTANCE;
        boolean bl = false;
        return $fun$isSuperclassOf$1.invoke($this$isSuperclassOf, other, new LinkedHashSet());
    }

    public static final boolean isSupertypeOf(@NotNull FirClass<?> $this$isSupertypeOf, @NotNull FirClass<?> other) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, (String)"$this$isSupertypeOf");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        isSupertypeOf.1 $fun$isSupertypeOf$1 = isSupertypeOf.1.INSTANCE;
        boolean bl = false;
        return $fun$isSupertypeOf$1.invoke($this$isSupertypeOf, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeClassLikeType $this$toRegularClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeSymbol<?> $this$safeAs$iv = LookupTagUtilsKt.toSymbol($this$toRegularClass.getLookupTag(), session2);
        boolean $i$f$safeAs = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
        if (!(firClassLikeSymbol instanceof FirRegularClassSymbol)) {
            firClassLikeSymbol = null;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol;
        return firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeKotlinType $this$toRegularClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
        return coneClassLikeType != null ? FirHelpersKt.toRegularClass(coneClassLikeType, session2) : null;
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull FirTypeRef $this$toRegularClass, @NotNull FirSession session2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        FirTypeRef firTypeRef = $this$safeAs$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        return (object = (FirResolvedTypeRef)firTypeRef) != null && (object = ((FirResolvedTypeRef)object).getType()) != null ? FirHelpersKt.toRegularClass((ConeKotlinType)object, session2) : null;
    }

    public static final /* synthetic */ <T> T getDeclaration(FirQualifiedAccessExpression $this$getDeclaration) {
        Object object;
        int $i$f$getDeclaration = 0;
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaration, (String)"$this$getDeclaration");
        FirReference $this$safeAs$iv = $this$getDeclaration.getCalleeReference();
        boolean $i$f$safeAs = false;
        FirReference firReference = $this$safeAs$iv;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        $this$safeAs$iv = (object = (FirResolvedNamedReference)firReference) != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((AbstractFirBasedSymbol)object).getFir() : null;
        $i$f$safeAs = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$safeAs$iv;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> getContainingClass(@NotNull FirSymbolOwner<?> $this$getContainingClass, @NotNull CheckerContext context2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Intrinsics.checkNotNullParameter($this$getContainingClass, (String)"$this$getContainingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirSymbolOwner<?> $this$safeAs$iv = $this$getContainingClass;
        boolean $i$f$safeAs = false;
        FirSymbolOwner<?> firSymbolOwner = $this$safeAs$iv;
        if (!(firSymbolOwner instanceof FirCallableMemberDeclaration)) {
            firSymbolOwner = null;
        }
        return (firClassLikeSymbol = (FirCallableMemberDeclaration)firSymbolOwner) != null && (firClassLikeSymbol = ClassMembersKt.containingClass((FirCallableDeclaration)((Object)firClassLikeSymbol))) != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)((Object)firClassLikeSymbol), context2.getSession())) != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAlias(@NotNull FirClassLikeDeclaration<?> $this$followAlias, @NotNull FirSession session2) {
        FirAnnotationContainer firAnnotationContainer;
        Intrinsics.checkNotNullParameter($this$followAlias, (String)"$this$followAlias");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeDeclaration<?> $this$safeAs$iv = $this$followAlias;
        boolean $i$f$safeAs = false;
        FirClassLikeDeclaration<?> firClassLikeDeclaration = $this$safeAs$iv;
        if (!(firClassLikeDeclaration instanceof FirTypeAlias)) {
            firClassLikeDeclaration = null;
        }
        if ((firAnnotationContainer = (FirTypeAlias)firClassLikeDeclaration) == null || (firAnnotationContainer = firAnnotationContainer.getExpandedTypeRef()) == null || (firAnnotationContainer = FirSupertypesResolutionKt.firClassLike((FirTypeRef)firAnnotationContainer, session2)) == null) {
            return $this$followAlias;
        }
        return firAnnotationContainer;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAllAlias(@NotNull FirClassLikeDeclaration<?> $this$followAllAlias, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$followAllAlias, (String)"$this$followAllAlias");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeDeclaration<?> it = $this$followAllAlias;
        while (it instanceof FirTypeAlias) {
            it = FirSupertypesResolutionKt.firClassLike(((FirTypeAlias)it).getExpandedTypeRef(), session2);
        }
        return it;
    }

    @Nullable
    public static final FirClass<?> findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestClassOrObject, (String)"$this$findClosestClassOrObject");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClass<?> containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenFunctions, (String)"$this$overriddenFunctions");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirTypeScope firTypeScope = KotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        boolean bl = false;
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName(((FirSimpleFunction)$this$overriddenFunctions.getSymbol().getFir()).getName(), overriddenFunctions.1.INSTANCE);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions.getSymbol(), (Function1)new Function1<FirFunctionSymbol<?>, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List $overriddenFunctions;

            @NotNull
            public final ProcessorAction invoke(@NotNull FirFunctionSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
            {
                this.$overriddenFunctions = list2;
                super(1);
            }
        });
        return overriddenFunctions2;
    }

    @Nullable
    public static final Visibility getVisibility(@Nullable KtModifierList $this$getVisibility) {
        Object object = $this$getVisibility;
        return object != null && (object = KtPsiUtilKt.visibilityModifierType((KtModifierList)object)) != null ? FirHelpersKt.toVisibilityOrNull((KtModifierKeywordToken)object) : null;
    }

    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toVisibilityOrNull, (String)"$this$toVisibilityOrNull");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass<?> $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter($this$modality, (String)"$this$modality");
        FirClass<?> firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)((Object)$this$modality);
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context2) {
        List<KtModifierKeywordToken> klassModifiers;
        Intrinsics.checkNotNullParameter((Object)$this$implicitModality, (String)"$this$implicitModality");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass<?> klass = firClass;
        List<KtModifierKeywordToken> list2 = FirHelpersKt.modifierListOrNull($this$implicitModality);
        if (list2 == null) {
            return Modality.FINAL;
        }
        List<KtModifierKeywordToken> modifiers2 = list2;
        if (modifiers2.contains(KtTokens.OVERRIDE_KEYWORD) && (klassModifiers = FirHelpersKt.modifierListOrNull(klass)) != null) {
            List<KtModifierKeywordToken> list3 = klassModifiers;
            boolean bl = false;
            boolean bl2 = false;
            List<KtModifierKeywordToken> $this$run = list3;
            boolean bl3 = false;
            boolean bl4 = $this$run.contains(KtTokens.ABSTRACT_KEYWORD) || $this$run.contains(KtTokens.OPEN_KEYWORD) || $this$run.contains(KtTokens.SEALED_KEYWORD);
            if (bl4) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE && !modifiers2.contains(KtTokens.PRIVATE_KEYWORD)) {
            return FirHelpersKt.hasBody($this$implicitModality) ? Modality.OPEN : Modality.ABSTRACT;
        }
        return Modality.FINAL;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtModifierKeywordToken> modifierListOrNull(FirDeclaration $this$modifierListOrNull) {
        List list2;
        Object object = FirModifierListKt.getModifierList($this$modifierListOrNull.getSource());
        if (object != null && (object = ((FirModifierList)object).getModifiers()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirModifier firModifier = (FirModifier)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KtModifierKeywordToken ktModifierKeywordToken = it.getToken();
                collection.add(ktModifierKeywordToken);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirDeclaration firDeclaration = $this$hasBody;
        if (firDeclaration instanceof FirSimpleFunction) {
            if (((FirSimpleFunction)$this$hasBody).getBody() == null) return false;
            if (((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) return false;
            return true;
        }
        if (!(firDeclaration instanceof FirProperty)) return false;
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter();
        FirBlock firBlock = firPropertyAccessor != null ? firPropertyAccessor.getBody() : null;
        if (!(firBlock != null ? firBlock instanceof FirEmptyExpressionBlock : true)) return true;
        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$hasBody).getGetter();
        if (firPropertyAccessor2 == null) return false;
        FirBlock firBlock2 = firPropertyAccessor2.getBody();
        if (firBlock2 == null) return false;
        boolean bl = firBlock2 instanceof FirEmptyExpressionBlock;
        if (bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass<?> $this$findNonInterfaceSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$findNonInterfaceSupertype, (String)"$this$findNonInterfaceSupertype");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (FirTypeRef it : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            FirClass fir;
            void $this$safeAs$iv;
            Object object;
            Object $this$safeAs$iv2 = it;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv2;
            if (!(object2 instanceof FirResolvedTypeRef)) {
                object2 = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
            $this$safeAs$iv2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv2;
            if (!(object3 instanceof ConeClassLikeType)) {
                object3 = null;
            }
            if ((object = (ConeClassLikeType)object3) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                continue;
            }
            Object classId = object;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName((ClassId)classId);
            FirClassLikeDeclaration $i$f$safeAs2 = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            boolean $i$f$safeAs3 = false;
            Object v5 = $this$safeAs$iv;
            if (!(v5 instanceof FirClass)) {
                v5 = null;
            }
            if ((FirClass)v5 == null) {
                continue;
            }
            if (fir.getClassKind() == ClassKind.INTERFACE) continue;
            return it;
        }
        return null;
    }

    @NotNull
    public static final KtModifierKeywordToken toToken(@NotNull Modality $this$toToken) {
        KtModifierKeywordToken ktModifierKeywordToken;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toToken), (String)"$this$toToken");
        switch (FirHelpersKt$WhenMappings.$EnumSwitchMapping$0[$this$toToken.ordinal()]) {
            case 1: {
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.FINAL_KEYWORD;
                ktModifierKeywordToken = ktModifierKeywordToken2;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"KtTokens.FINAL_KEYWORD");
                break;
            }
            case 2: {
                KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.SEALED_KEYWORD;
                ktModifierKeywordToken = ktModifierKeywordToken3;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"KtTokens.SEALED_KEYWORD");
                break;
            }
            case 3: {
                KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.OPEN_KEYWORD;
                ktModifierKeywordToken = ktModifierKeywordToken4;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"KtTokens.OPEN_KEYWORD");
                break;
            }
            case 4: {
                KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.ABSTRACT_KEYWORD;
                ktModifierKeywordToken = ktModifierKeywordToken5;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken5, (String)"KtTokens.ABSTRACT_KEYWORD");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktModifierKeywordToken;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterator, (String)"$this$isIterator");
        return Intrinsics.areEqual((Object)$this$isIterator.getCalleeReference().getName().asString(), (Object)"<iterator>");
    }
}

