/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies;", "", "()V", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getDECLARATION_NAME", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DEFAULT", "getDEFAULT", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "checkers"})
public final class LightTreePositioningStrategies {
    @NotNull
    private static final LightTreePositioningStrategy DEFAULT;
    @NotNull
    private static final LightTreePositioningStrategy VAL_OR_VAR_NODE;
    @NotNull
    private static final LightTreePositioningStrategy SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_NAME;
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE;
    @NotNull
    public static final LightTreePositioningStrategies INSTANCE;

    @NotNull
    public final LightTreePositioningStrategy getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    private LightTreePositioningStrategies() {
    }

    static {
        LightTreePositioningStrategies lightTreePositioningStrategies;
        INSTANCE = lightTreePositioningStrategies = new LightTreePositioningStrategies();
        DEFAULT = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                IElementType iElementType = node.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                    LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                    Intrinsics.checkNotNull((Object)lighterASTNode2);
                    LighterASTNode objectKeyword = lighterASTNode2;
                    LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                    if (lighterASTNode3 == null) {
                        lighterASTNode3 = objectKeyword;
                    }
                    return LightTreePositioningStrategyKt.markRange(objectKeyword, lighterASTNode3, tree);
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                    return LightTreePositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark(node, tree);
                }
                return super.mark(node, tree);
            }
        };
        VAL_OR_VAR_NODE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valOrVarKeyword(tree, node);
                if (lighterASTNode2 == null) {
                    lighterASTNode2 = node;
                }
                LighterASTNode target = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(target, tree);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                IElementType iElementType = node.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                    LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                    if (lighterASTNode2 == null) {
                        return LightTreePositioningStrategyKt.markElement(node, tree);
                    }
                    LighterASTNode valueParameterList = lighterASTNode2;
                    LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                    Intrinsics.checkNotNull((Object)lighterASTNode3);
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                    Intrinsics.checkNotNull((Object)lighterASTNode4);
                    return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode4, tree);
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                    IElementType iElementType2 = KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE");
                    LighterASTNode delegationReference = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType2);
                    if (delegationReference != null && LightTreePositioningStrategiesKt.access$firstChild(tree, delegationReference) == null) {
                        IElementType iElementType3 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"KtNodeTypes.SECONDARY_CONSTRUCTOR");
                        LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$findParentOfType(tree, node, iElementType3);
                        Intrinsics.checkNotNull((Object)lighterASTNode5);
                        LighterASTNode constructor2 = lighterASTNode5;
                        LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                        if (lighterASTNode6 == null) {
                            return LightTreePositioningStrategyKt.markElement(constructor2, tree);
                        }
                        LighterASTNode valueParameterList = lighterASTNode6;
                        LighterASTNode lighterASTNode7 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, constructor2);
                        Intrinsics.checkNotNull((Object)lighterASTNode7);
                        LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                        Intrinsics.checkNotNull((Object)lighterASTNode8);
                        return LightTreePositioningStrategyKt.markRange(lighterASTNode7, lighterASTNode8, tree);
                    }
                    LighterASTNode lighterASTNode9 = delegationReference;
                    if (lighterASTNode9 == null) {
                        lighterASTNode9 = node;
                    }
                    return LightTreePositioningStrategyKt.markElement(lighterASTNode9, tree);
                }
                String string2 = "unexpected element " + node;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        };
        DECLARATION_NAME = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                block5: {
                    LighterASTNode nameIdentifier;
                    block6: {
                        LighterASTNode lighterASTNode2;
                        LighterASTNode lighterASTNode3;
                        block8: {
                            block7: {
                                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                                nameIdentifier = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                                if (nameIdentifier == null) break block5;
                                if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CLASS) && !Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.OBJECT_DECLARATION)) break block6;
                                lighterASTNode3 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                                if (lighterASTNode3 == null) break block7;
                                LighterASTNode lighterASTNode4 = lighterASTNode3;
                                boolean bl = false;
                                boolean bl2 = false;
                                LighterASTNode modifierList2 = lighterASTNode4;
                                boolean bl3 = false;
                                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.ENUM_KEYWORD");
                                lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                                if (lighterASTNode3 != null) break block8;
                            }
                            TokenSet tokenSet = TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD);
                            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens\u2026 KtTokens.OBJECT_KEYWORD)");
                            lighterASTNode3 = lighterASTNode2 = LightTreePositioningStrategiesKt.access$findChildByType(tree, node, tokenSet);
                        }
                        if (lighterASTNode3 == null) {
                            lighterASTNode2 = node;
                        }
                        LighterASTNode startElement = lighterASTNode2;
                        return LightTreePositioningStrategyKt.markRange(startElement, nameIdentifier, tree);
                    }
                    return LightTreePositioningStrategyKt.markElement(nameIdentifier, tree);
                }
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUN)) {
                    return LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, tree);
                }
                return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, tree);
            }
        };
        DECLARATION_SIGNATURE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                IElementType iElementType;
                block26: {
                    LighterASTNode lighterASTNode2;
                    LighterASTNode nameAsDeclaration;
                    block28: {
                        block27: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            Intrinsics.checkNotNullParameter(tree, (String)"tree");
                            iElementType = node.getTokenType();
                            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                                if (lighterASTNode3 == null) {
                                    lighterASTNode3 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                                }
                                if (lighterASTNode3 == null) {
                                    return LightTreePositioningStrategyKt.markElement(node, tree);
                                }
                                LighterASTNode begin = lighterASTNode3;
                                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                                if (lighterASTNode4 == null) {
                                    lighterASTNode4 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                                }
                                if (lighterASTNode4 == null) {
                                    return LightTreePositioningStrategyKt.markElement(node, tree);
                                }
                                LighterASTNode end = lighterASTNode4;
                                return LightTreePositioningStrategyKt.markRange(begin, end, tree);
                            }
                            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                                LighterASTNode lighterASTNode5;
                                LighterASTNode endOfSignatureElement;
                                LighterASTNode lighterASTNode6;
                                LighterASTNode lighterASTNode7;
                                LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                                if (lighterASTNode8 == null) {
                                    lighterASTNode8 = lighterASTNode7 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                                }
                                if (lighterASTNode8 == null) {
                                    lighterASTNode7 = lighterASTNode6 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                                }
                                if (lighterASTNode7 == null) {
                                    lighterASTNode6 = endOfSignatureElement = node;
                                }
                                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                                    LighterASTNode lighterASTNode9 = LightTreePositioningStrategiesKt.access$receiverTypeReference(tree, node);
                                    if (lighterASTNode9 == null) {
                                        lighterASTNode9 = lighterASTNode5 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                                    }
                                    if (lighterASTNode9 == null) {
                                        lighterASTNode5 = node;
                                    }
                                } else {
                                    lighterASTNode5 = node;
                                }
                                LighterASTNode startElement = lighterASTNode5;
                                return LightTreePositioningStrategyKt.markRange(startElement, endOfSignatureElement, tree);
                            }
                            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) {
                                LighterASTNode lighterASTNode10;
                                LighterASTNode lighterASTNode11 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                                if (lighterASTNode11 == null) {
                                    lighterASTNode11 = lighterASTNode10 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                                }
                                if (lighterASTNode11 == null) {
                                    lighterASTNode10 = node;
                                }
                                LighterASTNode endOfSignatureElement = lighterASTNode10;
                                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, tree);
                            }
                            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_ACCESSOR)) {
                                LighterASTNode lighterASTNode12;
                                LighterASTNode lighterASTNode13 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                                if (lighterASTNode13 == null) {
                                    lighterASTNode13 = lighterASTNode12 = LightTreePositioningStrategiesKt.access$rightParenthesis(tree, node);
                                }
                                if (lighterASTNode13 == null) {
                                    lighterASTNode12 = LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node);
                                }
                                LighterASTNode endOfSignatureElement = lighterASTNode12;
                                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, tree);
                            }
                            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS)) break block26;
                            LighterASTNode lighterASTNode14 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                            if (lighterASTNode14 == null) {
                                return LightTreePositioningStrategyKt.markElement(node, tree);
                            }
                            nameAsDeclaration = lighterASTNode14;
                            lighterASTNode2 = LightTreePositioningStrategiesKt.access$primaryConstructor(tree, node);
                            if (lighterASTNode2 == null) break block27;
                            LighterASTNode lighterASTNode15 = lighterASTNode2;
                            boolean bl = false;
                            boolean bl2 = false;
                            LighterASTNode constructor2 = lighterASTNode15;
                            boolean bl3 = false;
                            lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                            if (lighterASTNode2 != null) break block28;
                        }
                        return LightTreePositioningStrategyKt.markElement(nameAsDeclaration, tree);
                    }
                    LighterASTNode primaryConstructorParameterList = lighterASTNode2;
                    return LightTreePositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList, tree);
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                    return LightTreePositioningStrategies.INSTANCE.getDECLARATION_NAME().mark(node, tree);
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_INITIALIZER)) {
                    LighterASTNode lighterASTNode16 = LightTreePositioningStrategiesKt.access$initKeyword(tree, node);
                    Intrinsics.checkNotNull((Object)lighterASTNode16);
                    return LightTreePositioningStrategyKt.markElement(lighterASTNode16, tree);
                }
                return super.mark(node, tree);
            }
        };
    }
}

