/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;", "", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateDataClassComponentBody", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "generateDataClassCopyBody", "generateDataClassMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateInlineClassMembers", "Companion", "MyDataClassMethodsGenerator", "fir2ir"})
public final class DataClassMembersGenerator {
    @NotNull
    private final Fir2IrComponents components;
    private static final Name copyName;
    private static final Name equalsName;
    private static final Name hashCodeName;
    private static final Name toStringName;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<FirDeclaration> generateInlineClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_INLINE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateDataClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    public final void generateDataClassComponentBody(@NotNull IrFunction irFunction, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateComponentBody(irFunction);
    }

    public final void generateDataClassCopyBody(@NotNull IrFunction irFunction, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateCopyBody(irFunction);
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    public DataClassMembersGenerator(@NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    static {
        Companion = new Companion(null);
        Name name = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"copy\")");
        copyName = name;
        Name name2 = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"equals\")");
        equalsName = name2;
        Name name3 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"hashCode\")");
        hashCodeName = name3;
        Name name4 = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"Name.identifier(\"toString\")");
        toStringName = name4;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0013H\u0002J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.J\u000e\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u0016\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u00103\u001a\u000204R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0018\u0010\u0019\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0018\u0010\u001b\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irDataClassMembersGenerator", "org/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1;", "getLookupTag", "()Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "createSyntheticIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "otherParameterNeeded", "createSyntheticIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irFunction", "type", "index", "", "generate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "generateComponentBody", "", "generateCopyBody", "generateDispatchReceiverParameter", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/ir/descriptors/WrappedValueParameterDescriptor;", "fir2ir"})
    private final class MyDataClassMethodsGenerator {
        private final irDataClassMembersGenerator.1 irDataClassMembersGenerator;
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final ConeClassLikeLookupTag lookupTag;
        @NotNull
        private final IrDeclarationOrigin origin;

        @NotNull
        public final IrValueParameter generateDispatchReceiverParameter(@NotNull IrFunction irFunction, @NotNull WrappedValueParameterDescriptor valueParameterDescriptor) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
            IrValueParameter irValueParameter = ConversionUtilsKt.declareThisReceiverParameter(irFunction, DataClassMembersGenerator.this.getComponents().getSymbolTable(), IrUtilsKt.getDefaultType(this.irClass), this.origin, -1, -1);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter $this$apply = irValueParameter;
            boolean bl3 = false;
            valueParameterDescriptor.bind((IrDeclaration)$this$apply);
            return irValueParameter;
        }

        private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
            return $this$matchesEqualsSignature.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType()) && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType());
        }

        private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
            return $this$matchesHashCodeSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesHashCodeSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType());
        }

        private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
            return $this$matchesToStringSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesToStringSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType());
        }

        private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
            return Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)equalsName) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)hashCodeName) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)toStringName) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FirDeclaration> generate(@NotNull FirClass<?> klass) {
            void $this$mapNotNullTo$iv$iv22;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Object object = IrUtilsKt.getPrimaryConstructor(this.irClass);
            int propertyParametersCount = object != null && (object = IrUtilsKt.getExplicitParameters((IrFunction)object)) != null ? object.size() : 0;
            Iterable iterable = this.irClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var6_6 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)propertyParametersCount);
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrProperty irProperty2 = (IrProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PropertyDescriptor propertyDescriptor = it.getDescriptor();
                collection.add(propertyDescriptor);
            }
            List properties2 = (List)destination$iv$iv;
            if (properties2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            $i$f$map = false;
            List result2 = new ArrayList();
            Iterable $this$mapNotNull$iv = klass.getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclaration it = (FirDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FirSimpleFunction && this.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)it) ? ((FirSimpleFunction)it).getName() : null) == null) continue;
                name = name;
                boolean bl3 = false;
                boolean bl4 = false;
                Name it$iv$iv = name;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List contributedFunctionsInThisType = (List)destination$iv$iv2;
            $i$f$mapNotNull = false;
            boolean $this$mapNotNullTo$iv$iv22 = false;
            $this$mapNotNullTo$iv$iv22 = false;
            Map map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            boolean bl6 = false;
            Object $this$buildMap = map2;
            boolean bl7 = false;
            for (Name name : CollectionsKt.listOf((Object[])new Name[]{equalsName, hashCodeName, toStringName})) {
                KotlinScopeProviderKt.unsubstitutedScope(klass, DataClassMembersGenerator.this.getComponents().getSession(), DataClassMembersGenerator.this.getComponents().getScopeSession(), true).processFunctionsByName(name, (Function1)new Function1<FirFunctionSymbol<?>, Unit>((Map)$this$buildMap, this, klass){
                    final /* synthetic */ Map $this_buildMap;
                    final /* synthetic */ MyDataClassMethodsGenerator this$0;
                    final /* synthetic */ FirClass $klass$inlined;
                    {
                        this.$this_buildMap = map2;
                        this.this$0 = myDataClassMethodsGenerator;
                        this.$klass$inlined = firClass;
                        super(1);
                    }

                    public final void invoke(@NotNull FirFunctionSymbol<?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        FirFunction declaration2 = (FirFunction)it.getFir();
                        if (declaration2 instanceof FirSimpleFunction && MyDataClassMethodsGenerator.access$getMatchesDataClassSyntheticMemberSignatures$p(this.this$0, (FirSimpleFunction)declaration2)) {
                            this.$this_buildMap.putIfAbsent(((FirSimpleFunction)declaration2).getName(), declaration2);
                        }
                    }
                });
            }
            Map contributedFunctionsInSupertypes = MapsKt.build((Map)map2);
            Function1<Name, Boolean> $fun$isOverridableDeclaration$1 = new Function1<Name, Boolean>(contributedFunctionsInSupertypes){
                final /* synthetic */ Map $contributedFunctionsInSupertypes;

                public final boolean invoke(@NotNull Name name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    FirSimpleFunction firSimpleFunction = (FirSimpleFunction)this.$contributedFunctionsInSupertypes.get(name);
                    if (firSimpleFunction == null) {
                        return false;
                    }
                    FirSimpleFunction declaration2 = firSimpleFunction;
                    FirMemberDeclaration $this$modality$iv = declaration2;
                    boolean $i$f$getModality = false;
                    return $this$modality$iv.getStatus().getModality() != Modality.FINAL;
                }
                {
                    this.$contributedFunctionsInSupertypes = map2;
                    super(1);
                }
            };
            if (!contributedFunctionsInThisType.contains(equalsName) && $fun$isOverridableDeclaration$1.invoke(equalsName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes, (Object)equalsName));
                IrFunction equalsFunction = this.createSyntheticIrFunction(equalsName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType(), true);
                this.irDataClassMembersGenerator.generateEqualsMethod(equalsFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(equalsFunction);
            }
            if (!contributedFunctionsInThisType.contains(hashCodeName) && $fun$isOverridableDeclaration$1.invoke(hashCodeName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes, (Object)hashCodeName));
                IrFunction hashCodeFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, hashCodeName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType(), false, 4, null);
                this.irDataClassMembersGenerator.generateHashCodeMethod(hashCodeFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(hashCodeFunction);
            }
            if (!contributedFunctionsInThisType.contains(toStringName) && $fun$isOverridableDeclaration$1.invoke(toStringName)) {
                result2.add(MapsKt.getValue((Map)contributedFunctionsInSupertypes, (Object)toStringName));
                IrFunction toStringFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, toStringName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType(), false, 4, null);
                this.irDataClassMembersGenerator.generateToStringMethod(toStringFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(toStringFunction);
            }
            return result2;
        }

        public final void generateComponentBody(@NotNull IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            Integer n = Companion.getComponentIndex(irFunction);
            Intrinsics.checkNotNull((Object)n);
            int index2 = n;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            IrValueParameter valueParameter = irConstructor2.getValueParameters().get(index2 - 1);
            IrField irField = this.irDataClassMembersGenerator.getBackingField(null, valueParameter);
            Intrinsics.checkNotNull((Object)irField);
            IrField backingField2 = irField;
            this.irDataClassMembersGenerator.generateComponentFunction(irFunction, backingField2);
        }

        public final void generateCopyBody(@NotNull IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            this.irDataClassMembersGenerator.generateCopyFunction(irFunction, (IrConstructorSymbol)irConstructor2.getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction createSyntheticIrFunction(Name name, IrType returnType2, boolean otherParameterNeeded) {
            Object object;
            block12: {
                Object v3;
                Object $this$apply;
                block11: {
                    void $this$singleOrNull$iv;
                    Iterable $this$toTypedArray$iv;
                    Collection<ConeStarProjection> collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    ConeClassifierLookupTag coneClassifierLookupTag;
                    Object object2;
                    FirTypeRef firTypeRef;
                    WrappedValueParameterDescriptor thisReceiverDescriptor = new WrappedValueParameterDescriptor();
                    boolean $i$f$buildSimpleFunction = false;
                    boolean bl = false;
                    object = new FirSimpleFunctionBuilder();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    FirSimpleFunctionBuilder $this$buildSimpleFunction = object;
                    boolean bl4 = false;
                    $this$buildSimpleFunction.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                    $this$buildSimpleFunction.setName(name);
                    $this$buildSimpleFunction.setSymbol(new FirNamedFunctionSymbol(new CallableId(this.lookupTag.getClassId(), name)));
                    $this$buildSimpleFunction.setStatus(new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL));
                    $this$buildSimpleFunction.setSession(DataClassMembersGenerator.this.getComponents().getSession());
                    IrType irType = returnType2;
                    if (Intrinsics.areEqual((Object)irType, (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType())) {
                        firTypeRef = new FirImplicitBooleanTypeRef(null);
                    } else if (Intrinsics.areEqual((Object)irType, (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType())) {
                        firTypeRef = new FirImplicitIntTypeRef(null);
                    } else if (Intrinsics.areEqual((Object)irType, (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType())) {
                        firTypeRef = new FirImplicitStringTypeRef(null);
                    } else {
                        String string2 = "Unexpected synthetic data class function return type: " + returnType2;
                        boolean bl5 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    $this$buildSimpleFunction.setReturnTypeRef(firTypeRef);
                    if (otherParameterNeeded) {
                        void $this$buildValueParameter;
                        boolean $i$f$buildValueParameter22 = false;
                        boolean bl6 = false;
                        FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
                        boolean bl7 = false;
                        boolean bl8 = false;
                        FirValueParameterBuilder firValueParameterBuilder2 = firValueParameterBuilder;
                        object2 = $this$buildSimpleFunction.getValueParameters();
                        boolean bl9 = false;
                        Name name2 = Name.identifier("other");
                        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"other\")");
                        $this$buildValueParameter.setName(name2);
                        $this$buildValueParameter.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                        $this$buildValueParameter.setSession(DataClassMembersGenerator.this.getComponents().getSession());
                        $this$buildValueParameter.setReturnTypeRef(new FirImplicitNullableAnyTypeRef(null));
                        $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>($this$buildValueParameter.getName()));
                        $this$buildValueParameter.setCrossinline(false);
                        $this$buildValueParameter.setNoinline(false);
                        $this$buildValueParameter.setVararg(false);
                        coneClassifierLookupTag = Unit.INSTANCE;
                        object2.add(firValueParameterBuilder.build());
                    }
                    int $i$f$buildValueParameter22 = 1;
                    Iterable $i$f$buildValueParameter22 = (Iterable)new IntRange($i$f$buildValueParameter22, this.irClass.getTypeParameters().size());
                    coneClassifierLookupTag = this.lookupTag;
                    object2 = $this$buildSimpleFunction;
                    boolean $i$f$map = false;
                    void var14_23 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl9 = $this$mapTo$iv$iv.iterator();
                    while (bl9.hasNext()) {
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)bl9).nextInt();
                        collection = destination$iv$iv;
                        boolean bl10 = false;
                        ConeStarProjection coneStarProjection = ConeStarProjection.INSTANCE;
                        collection.add(coneStarProjection);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = collection;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
                    if (coneStarProjectionArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    ((FirSimpleFunctionBuilder)object2).setDispatchReceiverType(TypeConstructionUtilsKt.constructType$default(coneClassifierLookupTag, coneStarProjectionArray, false, null, 4, null));
                    FirSimpleFunction firFunction = ((FirSimpleFunctionBuilder)object).build();
                    IdSignature signature2 = this.lookupTag.getClassId().isLocal() ? null : Fir2IrSignatureComposer.DefaultImpls.composeSignature$default(DataClassMembersGenerator.this.getComponents().getSignatureComposer(), firFunction, null, 2, null);
                    object = DataClassMembersGenerator.this.getComponents().getDeclarationStorage().declareIrSimpleFunction$fir2ir(signature2, null, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(this, name, returnType2, otherParameterNeeded, firFunction){
                        final /* synthetic */ MyDataClassMethodsGenerator this$0;
                        final /* synthetic */ Name $name;
                        final /* synthetic */ IrType $returnType;
                        final /* synthetic */ boolean $otherParameterNeeded;
                        final /* synthetic */ FirSimpleFunction $firFunction;

                        @NotNull
                        public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                            IrFactory irFactory = this.this$0.DataClassMembersGenerator.this.getComponents().getIrFactory();
                            IrDeclarationOrigin irDeclarationOrigin = this.this$0.getOrigin();
                            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"DescriptorVisibilities.PUBLIC");
                            IrSimpleFunction irSimpleFunction = IrFactory.DefaultImpls.createFunction$default(irFactory, -1, -1, irDeclarationOrigin, symbol2, this.$name, descriptorVisibility, Modality.OPEN, this.$returnType, false, false, false, false, false, false, false, false, null, 65536, null);
                            boolean bl = false;
                            boolean bl2 = false;
                            IrSimpleFunction $this$apply = irSimpleFunction;
                            boolean bl3 = false;
                            if (this.$otherParameterNeeded) {
                                IrValueParameter irValueParameter = MyDataClassMethodsGenerator.createSyntheticIrParameter$default(this.this$0, $this$apply, ((FirValueParameter)CollectionsKt.first(this.$firFunction.getValueParameters())).getName(), this.this$0.DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType(), 0, 8, null);
                                $this$apply.setValueParameters(CollectionsKt.listOf((Object)irValueParameter));
                            }
                            $this$apply.setMetadata(new FirMetadataSource.Function(this.$firFunction));
                            return irSimpleFunction;
                        }
                        {
                            this.this$0 = myDataClassMethodsGenerator;
                            this.$name = name;
                            this.$returnType = irType;
                            this.$otherParameterNeeded = bl;
                            this.$firFunction = firSimpleFunction;
                            super(1);
                        }
                    }));
                    bl2 = false;
                    bl3 = false;
                    $this$apply = object;
                    boolean bl11 = false;
                    $this$apply.setParent(this.irClass);
                    ((IrFunction)$this$apply).setDispatchReceiverParameter(this.generateDispatchReceiverParameter((IrFunction)$this$apply, thisReceiverDescriptor));
                    $this$toTypedArray$iv = ((ClassDescriptor)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyClass().getDescriptor()).getUnsubstitutedMemberScope().getContributedFunctions($this$apply.getName(), NoLookupLocation.FROM_BACKEND);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        SimpleFunctionDescriptor function2 = (SimpleFunctionDescriptor)element$iv;
                        boolean bl12 = false;
                        if (!Intrinsics.areEqual((Object)function2.getName(), (Object)$this$apply.getName())) continue;
                        if (found$iv) {
                            v3 = null;
                            break block11;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = !found$iv ? null : single$iv;
                }
                SimpleFunctionDescriptor simpleFunctionDescriptor = v3;
                if (simpleFunctionDescriptor == null) break block12;
                SimpleFunctionDescriptor simpleFunctionDescriptor2 = simpleFunctionDescriptor;
                boolean bl = false;
                boolean bl13 = false;
                SimpleFunctionDescriptor it = simpleFunctionDescriptor2;
                boolean bl14 = false;
                $this$apply.setOverriddenSymbols(CollectionsKt.listOf((Object)DataClassMembersGenerator.this.getComponents().getSymbolTable().referenceSimpleFunction(it)));
            }
            return (IrFunction)object;
        }

        static /* synthetic */ IrFunction createSyntheticIrFunction$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, Name name, IrType irType, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return myDataClassMethodsGenerator.createSyntheticIrFunction(name, irType, bl);
        }

        private final IrValueParameter createSyntheticIrParameter(IrFunction irFunction, Name name, IrType type2, int index2) {
            WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor();
            IrValueParameter irValueParameter = SymbolTable.declareValueParameter$default(DataClassMembersGenerator.this.getComponents().getSymbolTable(), -1, -1, this.origin, descriptor2, type2, null, null, (Function1)new Function1<IrValueParameterSymbol, IrValueParameter>(this, name, index2, type2){
                final /* synthetic */ MyDataClassMethodsGenerator this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ int $index;
                final /* synthetic */ IrType $type;

                @NotNull
                public final IrValueParameter invoke(@NotNull IrValueParameterSymbol symbol2) {
                    Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                    return IrFactory.DefaultImpls.createValueParameter$default(this.this$0.DataClassMembersGenerator.this.getComponents().getIrFactory(), -1, -1, this.this$0.getOrigin(), symbol2, this.$name, this.$index, this.$type, null, false, false, false, false, 1024, null);
                }
                {
                    this.this$0 = myDataClassMethodsGenerator;
                    this.$name = name;
                    this.$index = n;
                    this.$type = irType;
                    super(1);
                }
            }, 96, null);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter $this$apply = irValueParameter;
            boolean bl3 = false;
            $this$apply.setParent(irFunction);
            descriptor2.bind((IrDeclaration)$this$apply);
            return irValueParameter;
        }

        static /* synthetic */ IrValueParameter createSyntheticIrParameter$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, IrFunction irFunction, Name name, IrType irType, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return myDataClassMethodsGenerator.createSyntheticIrParameter(irFunction, name, irType, n);
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final ConeClassLikeLookupTag getLookupTag() {
            return this.lookupTag;
        }

        @NotNull
        public final IrDeclarationOrigin getOrigin() {
            return this.origin;
        }

        public MyDataClassMethodsGenerator(@NotNull IrClass irClass2, @NotNull ConeClassLikeLookupTag lookupTag, IrDeclarationOrigin origin) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            this.irClass = irClass2;
            this.lookupTag = lookupTag;
            this.origin = origin;
            this.irDataClassMembersGenerator = new org.jetbrains.kotlin.ir.util.DataClassMembersGenerator(this, new IrGeneratorContextBase(DataClassMembersGenerator.this.getComponents().getIrBuiltIns()), DataClassMembersGenerator.this.getComponents().getSymbolTable(), this.irClass, this.origin){
                final /* synthetic */ MyDataClassMethodsGenerator this$0;

                @NotNull
                public IrFunction declareSimpleFunction(int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
                    throw (Throwable)new IllegalStateException("Not expect to see function declaration.");
                }

                public void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction irFunction) {
                    Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public IrField getBackingField(@Nullable ValueParameterDescriptor parameter, @Nullable IrValueParameter irValueParameter) {
                    block6: {
                        block5: {
                            v0 = irValueParameter;
                            if (v0 == null) break block5;
                            var3_3 = v0;
                            var4_4 = false;
                            var5_5 = false;
                            it = var3_3;
                            $i$a$-let-DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1$getBackingField$1 = false;
                            $this$single$iv = IrUtilsKt.getProperties(this.getIrClass());
                            $i$f$single = false;
                            single$iv = null;
                            found$iv = false;
                            for (E element$iv : $this$single$iv) {
                                irProperty = (IrProperty)element$iv;
                                $i$a$-single-DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1$getBackingField$1$1 = false;
                                if (!Intrinsics.areEqual((Object)irProperty.getName(), (Object)irValueParameter.getName())) ** GOTO lbl-1000
                                v1 = irProperty.getBackingField();
                                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getType() : null), (Object)irValueParameter.getType())) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                if (!v2) continue;
                                if (found$iv) {
                                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            if (!found$iv) {
                                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                            }
                            v3 = ((IrProperty)single$iv).getBackingField();
                            break block6;
                        }
                        v3 = null;
                    }
                    return v3;
                }

                @NotNull
                public IrType transform(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                    return this.this$0.DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyType();
                }

                public void commitSubstituted(@NotNull IrMemberAccessExpression<?> irMemberAccessExpression, @NotNull CallableDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter(irMemberAccessExpression, (String)"irMemberAccessExpression");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            };
        }

        public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures$p(MyDataClassMethodsGenerator $this, FirSimpleFunction $this$access_u24matchesDataClassSyntheticMemberSignatures_u24p) {
            return $this.getMatchesDataClassSyntheticMemberSignatures($this$access_u24matchesDataClassSyntheticMemberSignatures_u24p);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$Companion;", "", "()V", "copyName", "Lorg/jetbrains/kotlin/name/Name;", "equalsName", "hashCodeName", "toStringName", "getComponentIndex", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/Integer;", "isComponentN", "", "isCopy", "fir2ir"})
    public static final class Companion {
        public final boolean isCopy(@NotNull IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            return Intrinsics.areEqual((Object)irFunction.getName(), (Object)copyName);
        }

        public final boolean isComponentN(@NotNull IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            if (irFunction.getName().isSpecial()) {
                return false;
            }
            String string2 = irFunction.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.identifier");
            String name = string2;
            if (!StringsKt.startsWith$default((String)name, (String)"component", (boolean)false, (int)2, null)) {
                return false;
            }
            Integer n = this.getComponentIndex(irFunction);
            return n != null && n > 0;
        }

        @Nullable
        public final Integer getComponentIndex(@NotNull IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            String string2 = irFunction.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.identifier");
            String string3 = string2;
            int n = "component".length();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            return StringsKt.toIntOrNull((String)string5);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

