/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00122\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0017J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020/H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;)V", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "getFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ensureConsistent", "", "files", "", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "recordFile", "recordGeneratedClass", "owner", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "recordGeneratedMember", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "FirRecorder", "State", "SymbolProvider", "resolve"})
public final class FirProviderImpl
extends FirProvider {
    @NotNull
    private final FirSymbolProvider symbolProvider;
    private final State state;
    @NotNull
    private final FirSession session;
    @NotNull
    private final KotlinScopeProvider kotlinScopeProvider;

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirProperty fir;
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        FirCallableSymbol<Object> $this$originalIfFakeOverride$iv = symbol2;
        boolean $i$f$originalIfFakeOverride = false;
        FirCallableDeclaration $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        boolean $i$f$originalIfFakeOverride2 = false;
        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        boolean $i$f$getOriginalForSubstitutionOverride = false;
        FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
        if (firCallableDeclaration == null) {
            FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            boolean $i$f$getBaseForIntersectionOverride = false;
            firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        }
        FirCallableSymbol<Object> firCallableSymbol = firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null;
        if (firCallableSymbol != null) {
            $this$originalIfFakeOverride$iv = firCallableSymbol;
            boolean bl = false;
            boolean bl2 = false;
            FirCallableSymbol<Object> it = $this$originalIfFakeOverride$iv;
            boolean bl3 = false;
            return this.getFirCallableContainerFile(it);
        }
        if (symbol2 instanceof FirAccessorSymbol && (fir = (FirProperty)((FirAccessorSymbol)symbol2).getFir()) instanceof FirSyntheticProperty) {
            return this.getFirCallableContainerFile((FirCallableSymbol)((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        return this.state.getCallableContainerMap().get(symbol2);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName2);
        if (firFile == null) {
            String string2 = "Couldn't find container for " + fqName2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.state.getClassifierContainerFileMap().get(fqName2);
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.recordFile(file2, this.state);
    }

    @Override
    @FirProviderInternals
    public void recordGeneratedClass(@NotNull FirAnnotatedDeclaration owner, @NotNull FirRegularClass klass) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        klass.accept(FirRecorder.INSTANCE, TuplesKt.to((Object)this.state, (Object)this.getFile(owner)));
    }

    @Override
    @FirProviderInternals
    public void recordGeneratedMember(@NotNull FirAnnotatedDeclaration owner, @NotNull FirDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        klass.accept(FirRecorder.INSTANCE, TuplesKt.to((Object)this.state, (Object)this.getFile(owner)));
    }

    private final FirFile getFile(FirAnnotatedDeclaration $this$file) {
        FirFile firFile;
        FirAnnotatedDeclaration firAnnotatedDeclaration = $this$file;
        if (firAnnotatedDeclaration instanceof FirFile) {
            firFile = (FirFile)$this$file;
        } else if (firAnnotatedDeclaration instanceof FirRegularClass) {
            firFile = this.getFirClassifierContainerFile(((FirRegularClass)$this$file).getSymbol().getClassId());
        } else {
            String string2 = "Should not be here";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firFile;
    }

    private final void recordFile(FirFile file2, State state) {
        FqName packageName = file2.getPackageFqName();
        state.getFileMap().merge(packageName, CollectionsKt.listOf((Object)file2), recordFile.1.INSTANCE);
        file2.acceptChildren(FirRecorder.INSTANCE, TuplesKt.to((Object)state, (Object)file2));
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        List list2 = this.state.getFileMap().get(fqName2);
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl = !classId.isLocal();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Local " + classId + " should never be used to find its corresponding classifier";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.state.getClassifierMap().get(classId);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        $i$f$forEach = false;
        List failures = new ArrayList();
        Function4 $fun$checkMapDiff$2 = new Function4<String, Map<K, ? extends V>, Map<K, ? extends V>, Function2<? super V, ? super V, ? extends Boolean>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends V> a, @NotNull Map<K, ? extends V> b, @NotNull Function2<? super V, ? super V, Boolean> equal) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                Intrinsics.checkNotNullParameter(equal, (String)"equal");
                boolean hasTitle = false;
                Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Object $this$map$iv = unionKeys;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Triple triple = new Triple((Object)it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    void key;
                    Collection collection;
                    void aValue;
                    $this$map$iv = triple.component1();
                    Object $i$f$map2 = triple.component2();
                    Object bValue = triple.component3();
                    if (((Boolean)equal.invoke((Object)aValue, bValue)).booleanValue()) continue;
                    if (!hasTitle) {
                        collection = this.$failures;
                        boolean bl = false;
                        collection.add(title);
                        hasTitle = true;
                    }
                    collection = this.$failures;
                    String string2 = "diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'';
                    boolean bl = false;
                    collection.add(string2);
                }
            }

            public static /* synthetic */ void invoke$default(ensureConsistent.2 var0, String string2, Map map2, Map map3, Function2 function2, int n, Object object) {
                if ((n & 8) != 0) {
                    function2 = ensureConsistent.1.INSTANCE;
                }
                var0.invoke(string2, map2, map3, function2);
            }
            {
                this.$failures = list2;
                super(4);
            }
        };
        Function3 $fun$checkMMapDiff$3 = new Function3<String, Map<K, ? extends List<? extends V>>, Map<K, ? extends List<? extends V>>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends List<? extends V>> a, @NotNull Map<K, ? extends List<? extends V>> b) {
                Collection it;
                boolean $i$a$-map-FirProviderImpl$ensureConsistent$3$22;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                boolean hasTitle = false;
                Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Object $this$map$iv = unionKeys;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    Triple triple = new Triple((Object)it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    boolean bl;
                    String string2;
                    Collection collection;
                    T it2;
                    T element$iv;
                    void key;
                    void aValue;
                    $this$map$iv = triple.component1();
                    List $i$f$map2 = (List)triple.component2();
                    List bValue = (List)triple.component3();
                    if (aValue == null || bValue == null) {
                        if (!hasTitle) {
                            destination$iv$iv = this.$failures;
                            $i$f$mapTo2 = false;
                            destination$iv$iv.add(title);
                            hasTitle = true;
                        }
                        destination$iv$iv = this.$failures;
                        String $i$f$mapTo2 = "diff at key = '" + key + "': was: " + aValue + ", become: " + bValue;
                        boolean bl2 = false;
                        destination$iv$iv.add($i$f$mapTo2);
                        continue;
                    }
                    Set aSet = CollectionsKt.toSet((Iterable)((Iterable)aValue));
                    Set bSet = CollectionsKt.toSet((Iterable)bValue);
                    Set aLost = SetsKt.minus((Set)aSet, (Iterable)bSet);
                    Set bNew = SetsKt.minus((Set)bSet, (Iterable)aSet);
                    it = aLost;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    if (!(!it.isEmpty())) {
                        it = bNew;
                        $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                        if (!(!it.isEmpty())) continue;
                    }
                    it = this.$failures;
                    String $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "diff at key = '" + key + "':";
                    boolean bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    it = this.$failures;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "    Lost:";
                    bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    Iterable $this$forEach$iv = aLost;
                    boolean $i$f$forEach22 = false;
                    Iterator<T> iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        it2 = element$iv = iterator3.next();
                        boolean bl4 = false;
                        collection = this.$failures;
                        string2 = "     " + it2;
                        bl = false;
                        collection.add(string2);
                    }
                    $this$forEach$iv = this.$failures;
                    String $i$f$forEach22 = "    New:";
                    boolean bl5 = false;
                    $this$forEach$iv.add($i$f$forEach22);
                    $this$forEach$iv = bNew;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator4 = $this$forEach$iv.iterator();
                    while (iterator4.hasNext()) {
                        it2 = element$iv = iterator4.next();
                        boolean bl6 = false;
                        collection = this.$failures;
                        string2 = "     " + it2;
                        bl = false;
                        collection.add(string2);
                    }
                }
            }
            {
                this.$failures = list2;
                super(3);
            }
        };
        $fun$checkMMapDiff$3.invoke("fileMap", this.state.getFileMap(), newState.getFileMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 8, null);
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 8, null);
        $fun$checkMMapDiff$3.invoke("callableMap", this.state.getCallableMap(), newState.getCallableMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 8, null);
        this.state.setFrom(newState);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Set set = this.state.getClassesInPackage().get(fqName2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final KotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    public FirProviderImpl(@NotNull FirSession session2, @NotNull KotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        this.session = session2;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.symbolProvider = new SymbolProvider();
        this.state = new State();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;)V", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelCallableSymbolsTo", "", "destination", "", "resolve"})
    private final class SymbolProvider
    extends FirSymbolProvider {
        @Override
        @Nullable
        public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirProviderImpl.this.getFirClassifierByFqName(classId);
            return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
        }

        @Override
        @NotNull
        public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List list2 = FirProviderImpl.this.state.getCallableMap().get(new CallableId(packageFqName, null, name, null, 8, null));
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Collection collection = destination;
            Iterable iterable = this.getTopLevelCallableSymbols(packageFqName, name);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        @Override
        @Nullable
        public FqName getPackage(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Collection collection = FirProviderImpl.this.getFirFilesByPackage(fqName2);
            boolean bl = false;
            if (!collection.isEmpty()) {
                return fqName2;
            }
            return null;
        }

        public SymbolProvider() {
            super(FirProviderImpl.this.getSession());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0007\u001a\u00020\u0002\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "()V", "visitCallableDeclaration", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "callableDeclaration", "data", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
    private static final class FirRecorder
    extends FirDefaultVisitor<Unit, Pair<? extends State, ? extends FirFile>> {
        @NotNull
        public static final FirRecorder INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Pair<State, ? extends FirFile> data) {
            void state;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            ClassId classId = regularClass.getSymbol().getClassId();
            Object object = data;
            State state2 = (State)object.component1();
            FirFile file2 = (FirFile)object.component2();
            state.getClassifierMap().put(classId, regularClass);
            state.getClassifierContainerFileMap().put(classId, file2);
            if (!classId.isNestedClass() && !classId.isLocal()) {
                Object object2;
                void $this$getOrPut$iv;
                object = state.getClassesInPackage();
                FqName fqName2 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
                FqName key$iv = fqName2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                Set set = (Set)object2;
                Name name = classId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
                set.add(name);
            }
            regularClass.acceptChildren(this, data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Pair<State, ? extends FirFile> data) {
            void state;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            ClassId classId = typeAlias.getSymbol().getClassId();
            Pair<State, ? extends FirFile> pair = data;
            State state2 = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            state.getClassifierMap().put(classId, typeAlias);
            state.getClassifierContainerFileMap().put(classId, file2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <F extends FirCallableDeclaration<F>> void visitCallableDeclaration(@NotNull FirCallableDeclaration<F> callableDeclaration, @NotNull Pair<State, ? extends FirFile> data) {
            void state;
            Intrinsics.checkNotNullParameter(callableDeclaration, (String)"callableDeclaration");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirCallableSymbol<F> symbol2 = callableDeclaration.getSymbol();
            CallableId callableId = symbol2.getCallableId();
            Pair<State, ? extends FirFile> pair = data;
            State state2 = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            state.getCallableMap().merge(callableId, CollectionsKt.listOf(symbol2), visitCallableDeclaration.1.INSTANCE);
            state.getCallableContainerMap().put(symbol2, file2);
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.visitCallableDeclaration((FirCallableDeclaration)constructor2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.visitCallableDeclaration((FirCallableDeclaration)simpleFunction, data);
        }

        @Override
        public void visitProperty(@NotNull FirProperty property2, @NotNull Pair<State, ? extends FirFile> data) {
            block1: {
                FirPropertyAccessor it;
                boolean bl;
                boolean bl2;
                FirPropertyAccessor firPropertyAccessor;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                this.visitCallableDeclaration((FirCallableDeclaration)property2, data);
                FirPropertyAccessor firPropertyAccessor2 = property2.getGetter();
                if (firPropertyAccessor2 != null) {
                    firPropertyAccessor = firPropertyAccessor2;
                    bl2 = false;
                    bl = false;
                    it = firPropertyAccessor;
                    boolean bl3 = false;
                    INSTANCE.visitCallableDeclaration((FirCallableDeclaration)it, data);
                }
                FirPropertyAccessor firPropertyAccessor3 = property2.getSetter();
                if (firPropertyAccessor3 == null) break block1;
                firPropertyAccessor = firPropertyAccessor3;
                bl2 = false;
                bl = false;
                it = firPropertyAccessor;
                boolean bl4 = false;
                INSTANCE.visitCallableDeclaration((FirCallableDeclaration)it, data);
            }
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.visitCallableDeclaration((FirCallableDeclaration)enumEntry, data);
        }

        private FirRecorder() {
        }

        static {
            FirRecorder firRecorder;
            INSTANCE = firRecorder = new FirRecorder();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000R!\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR#\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "", "()V", "callableContainerMap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCallableContainerMap", "()Ljava/util/Map;", "callableMap", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "getCallableMap", "classesInPackage", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "getClassesInPackage", "classifierContainerFileMap", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassifierContainerFileMap", "classifierMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "fileMap", "getFileMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap;
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration<?>> classifierMap;
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap;
        @NotNull
        private final Map<FqName, Set<Name>> classesInPackage;
        @NotNull
        private final Map<CallableId, List<FirCallableSymbol<?>>> callableMap;
        @NotNull
        private final Map<FirCallableSymbol<?>, FirFile> callableContainerMap;

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration<?>> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassesInPackage() {
            return this.classesInPackage;
        }

        @NotNull
        public final Map<CallableId, List<FirCallableSymbol<?>>> getCallableMap() {
            return this.callableMap;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.fileMap.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.callableMap.clear();
            this.callableContainerMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.callableMap.putAll(other.callableMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
            this.classesInPackage.putAll(other.classesInPackage);
        }

        public State() {
            boolean bl = false;
            this.fileMap = new LinkedHashMap();
            bl = false;
            this.classifierMap = new LinkedHashMap();
            bl = false;
            this.classifierContainerFileMap = new LinkedHashMap();
            bl = false;
            this.classesInPackage = new LinkedHashMap();
            bl = false;
            this.callableMap = new LinkedHashMap();
            bl = false;
            this.callableContainerMap = new LinkedHashMap();
        }
    }
}

