/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JD\u0010\u000e\u001a\u00020\u000f\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u000f0\u0016H\u0016J.\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\t2\u001c\u0010\u0015\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f0\u0018H\u0016R$\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractSimpleImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "simpleImports", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getSimpleImports", "()Ljava/util/Map;", "processCallables", "", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerScopeLevel$Token;", "processor", "Lkotlin/Function1;", "processClassifiersByNameWithSubstitution", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "resolve"})
public abstract class FirAbstractSimpleImportingScope
extends FirAbstractImportingScope {
    @NotNull
    public abstract Map<Name, List<FirResolvedImport>> getSimpleImports();

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        List<FirResolvedImport> list2 = this.getSimpleImports().get(name);
        if (list2 == null) {
            return;
        }
        List<FirResolvedImport> imports = list2;
        if (imports.isEmpty()) {
            return;
        }
        FirSymbolProvider provider = MainSessionComponentsKt.getFirSymbolProvider(this.getSession());
        for (FirResolvedImport firResolvedImport : imports) {
            FirClassLikeSymbol<?> symbol2;
            Name importedName;
            if (firResolvedImport.getImportedName() == null) {
                continue;
            }
            ClassId classId = firResolvedImport.getResolvedClassId();
            if (classId == null || (classId = classId.createNestedClassId(importedName)) == null) {
                classId = ClassId.topLevel(firResolvedImport.getPackageFqName().child(importedName));
            }
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"import.resolvedClassId?.\u2026Name.child(importedName))");
            ClassId classId2 = classId;
            if (provider.getClassLikeSymbolByFqName(classId2) == null) {
                continue;
            }
            processor2.invoke(symbol2, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
    }

    @Override
    public <T extends FirCallableSymbol<?>> void processCallables(@NotNull Name name, @NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Function1<? super FirCallableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        List<FirResolvedImport> list2 = this.getSimpleImports().get(name);
        if (list2 == null) {
            return;
        }
        List<FirResolvedImport> imports = list2;
        if (imports.isEmpty()) {
            return;
        }
        for (FirResolvedImport firResolvedImport : imports) {
            Name name2 = firResolvedImport.getImportedName();
            Intrinsics.checkNotNull((Object)name2);
            this.processCallables(firResolvedImport, name2, token, processor2);
        }
    }

    public FirAbstractSimpleImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession, true);
    }
}

