/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt$WhenMappings;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.NewCommonSuperTypeCalculator;
import org.jetbrains.kotlin.types.AbstractStrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a&\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000b\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\u000b*\u00020\u0007\u001a\u0012\u0010\u001c\u001a\u00020\u000b*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001\u001a \u0010\u001f\u001a\u00020\u0007*\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000bH\u0002\u001a\u001a\u0010 \u001a\u0004\u0018\u00010\u0001*\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a\u0012\u0010!\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010!\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010$\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010$\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\"\u001a\u00020#\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010&\u001a\u00020\u000b*\u00020\u0001H\u0002\u001a)\u0010'\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u0001*\u0002H(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\u00a2\u0006\u0002\u0010,\u001a!\u0010-\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u0001*\u0002H(2\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00100\u001a7\u00101\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u0001*\u0002H(2\u0006\u00102\u001a\u0002032\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00104\u001a \u00105\u001a\u000206*\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00108\u001a\u0004\u0018\u000109\u001a\u0014\u0010:\u001a\u00020\u0007*\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010;\u001a\u00020\u0007*\u00020\u0007\u00a8\u0006<"}, d2={"coneFlexibleOrSimpleType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "lowerBound", "upperBound", "approximated", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeApproximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "toSuper", "", "conf", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;", "approximatedIfNeededOrSelf", "approximator", "containingCallableVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "isInlineFunction", "commonSuperTypeOrNull", "types", "", "create", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType;", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType$Companion;", "original", "hasEnhancedNullability", "hasFlexibleNullability", "hasNullableSuperType", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "type", "hideLocalTypeIfNeeded", "intersectTypesOrNull", "isExtensionFunctionType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isUnsafeVarianceType", "makeConeTypeDefinitelyNotNullOrNotNull", "requiresApproximationInPublicPosition", "withArguments", "T", "arguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "withAttributes", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "withNullability", "nullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeNullability;Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;Lorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "withReplacedConeType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "newType", "firFakeSourceElementKind", "Lorg/jetbrains/kotlin/fir/FirFakeSourceElementKind;", "withReplacedReturnType", "withoutEnhancedNullability", "resolve"})
public final class TypeUtilsKt {
    @Nullable
    public static final ConeKotlinType commonSuperTypeOrNull(@NotNull ConeInferenceContext $this$commonSuperTypeOrNull, @NotNull List<? extends ConeKotlinType> types2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$commonSuperTypeOrNull, (String)"$this$commonSuperTypeOrNull");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        switch (types2.size()) {
            case 0: {
                coneKotlinType = null;
                break;
            }
            case 1: {
                coneKotlinType = (ConeKotlinType)CollectionsKt.first(types2);
                break;
            }
            default: {
                NewCommonSuperTypeCalculator newCommonSuperTypeCalculator = NewCommonSuperTypeCalculator.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                NewCommonSuperTypeCalculator $this$with = newCommonSuperTypeCalculator;
                boolean bl3 = false;
                KotlinTypeMarker kotlinTypeMarker = $this$with.commonSuperType($this$commonSuperTypeOrNull, types2);
                if (kotlinTypeMarker == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                coneKotlinType = (ConeKotlinType)kotlinTypeMarker;
            }
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType intersectTypesOrNull(@NotNull ConeInferenceContext $this$intersectTypesOrNull, @NotNull List<? extends ConeKotlinType> types2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$intersectTypesOrNull, (String)"$this$intersectTypesOrNull");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        switch (types2.size()) {
            case 0: {
                coneKotlinType = null;
                break;
            }
            case 1: {
                coneKotlinType = (ConeKotlinType)CollectionsKt.first(types2);
                break;
            }
            default: {
                coneKotlinType = ConeTypeIntersector.INSTANCE.intersectTypes($this$intersectTypesOrNull, types2);
            }
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeDefinitelyNotNullType create(@NotNull ConeDefinitelyNotNullType.Companion $this$create, @NotNull ConeKotlinType original) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return original instanceof ConeDefinitelyNotNullType ? (ConeDefinitelyNotNullType)original : (FirTypeUtilsKt.makesSenseToBeDefinitelyNotNull(original) ? new ConeDefinitelyNotNullType(ConeTypesKt.lowerBoundIfFlexible(original)) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType makeConeTypeDefinitelyNotNullOrNotNull(@NotNull ConeKotlinType $this$makeConeTypeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter((Object)$this$makeConeTypeDefinitelyNotNullOrNotNull, (String)"$this$makeConeTypeDefinitelyNotNullOrNotNull");
        if ($this$makeConeTypeDefinitelyNotNullOrNotNull instanceof ConeIntersectionType) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ConeIntersectionType)$this$makeConeTypeDefinitelyNotNullOrNotNull).getIntersectedTypes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeKotlinType coneKotlinType = (ConeKotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType2 = TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull((ConeKotlinType)it);
                collection.add(coneKotlinType2);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            return new ConeIntersectionType(collection2);
        }
        ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, $this$makeConeTypeDefinitelyNotNullOrNotNull);
        return coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : TypeUtilsKt.withNullability$default($this$makeConeTypeDefinitelyNotNullOrNotNull, ConeNullability.NOT_NULL, null, null, 6, null);
    }

    @NotNull
    public static final <T extends ConeKotlinType> T withArguments(@NotNull T $this$withArguments, @NotNull ConeTypeProjection[] arguments2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$withArguments, (String)"$this$withArguments");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        if ($this$withArguments.getTypeArguments() == arguments2) {
            return $this$withArguments;
        }
        T t = $this$withArguments;
        if (t instanceof ConeClassErrorType) {
            object = $this$withArguments;
        } else if (t instanceof ConeClassLikeTypeImpl) {
            object = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withArguments).getLookupTag(), arguments2, $this$withArguments.getNullability().isNullable(), null, 8, null);
        } else if (t instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, TypeUtilsKt.withArguments(((ConeDefinitelyNotNullType)$this$withArguments).getOriginal(), arguments2));
            Intrinsics.checkNotNull((Object)coneDefinitelyNotNullType);
            if (coneDefinitelyNotNullType == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            object = coneDefinitelyNotNullType;
        } else {
            String string2 = "Not supported: " + $this$withArguments + ": " + TypeRendererKt.render($this$withArguments);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return object;
    }

    @NotNull
    public static final <T extends ConeKotlinType> T withAttributes(@NotNull T $this$withAttributes, @NotNull ConeAttributes attributes) {
        Object object;
        Intrinsics.checkNotNullParameter($this$withAttributes, (String)"$this$withAttributes");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (Intrinsics.areEqual((Object)$this$withAttributes.getAttributes(), (Object)attributes)) {
            return $this$withAttributes;
        }
        T t = $this$withAttributes;
        if (t instanceof ConeClassErrorType) {
            object = $this$withAttributes;
        } else if (t instanceof ConeClassLikeTypeImpl) {
            object = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withAttributes).getLookupTag(), $this$withAttributes.getTypeArguments(), $this$withAttributes.getNullability().isNullable(), attributes);
        } else if (t instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, TypeUtilsKt.withAttributes(((ConeDefinitelyNotNullType)$this$withAttributes).getOriginal(), attributes));
            Intrinsics.checkNotNull((Object)coneDefinitelyNotNullType);
            object = coneDefinitelyNotNullType;
        } else if (t instanceof ConeTypeParameterTypeImpl) {
            object = new ConeTypeParameterTypeImpl(((ConeTypeParameterTypeImpl)$this$withAttributes).getLookupTag(), $this$withAttributes.getNullability().isNullable(), attributes);
        } else if (t instanceof ConeFlexibleType) {
            object = new ConeFlexibleType(TypeUtilsKt.withAttributes(((ConeFlexibleType)$this$withAttributes).getLowerBound(), attributes), TypeUtilsKt.withAttributes(((ConeFlexibleType)$this$withAttributes).getUpperBound(), attributes));
        } else {
            String string2 = "Not supported: " + $this$withAttributes + ": " + TypeRendererKt.render($this$withAttributes);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type T");
        }
        return object;
    }

    public static final boolean hasNullableSuperType(@NotNull ConeTypeContext $this$hasNullableSuperType, @NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNullableSuperType, (String)"$this$hasNullableSuperType");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof ConeClassLikeType) {
            return false;
        }
        if (!(type2 instanceof ConeLookupTagBasedType)) {
            return false;
        }
        ConeClassifierLookupTag symbol2 = ((ConeLookupTagBasedType)type2).getLookupTag();
        for (KotlinTypeMarker superType : $this$hasNullableSuperType.supertypes(symbol2)) {
            if (!$this$hasNullableSuperType.isNullableType(superType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T extends ConeKotlinType> T withNullability(@NotNull T $this$withNullability, @NotNull ConeNullability nullability, @Nullable ConeInferenceContext typeContext2, @NotNull ConeAttributes attributes) {
        Object object;
        block16: {
            T t;
            block24: {
                block23: {
                    block22: {
                        ConeIntersectionType coneIntersectionType;
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block15: {
                                                Intrinsics.checkNotNullParameter($this$withNullability, (String)"$this$withNullability");
                                                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                                                Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                                                if ($this$withNullability.getNullability() == nullability && Intrinsics.areEqual((Object)$this$withNullability.getAttributes(), (Object)attributes)) {
                                                    return $this$withNullability;
                                                }
                                                t = $this$withNullability;
                                                if (!(t instanceof ConeClassErrorType)) break block15;
                                                object = $this$withNullability;
                                                break block16;
                                            }
                                            if (!(t instanceof ConeClassLikeTypeImpl)) break block17;
                                            object = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withNullability).getLookupTag(), $this$withNullability.getTypeArguments(), nullability.isNullable(), attributes);
                                            break block16;
                                        }
                                        if (!(t instanceof ConeTypeParameterTypeImpl)) break block18;
                                        object = new ConeTypeParameterTypeImpl(((ConeTypeParameterTypeImpl)$this$withNullability).getLookupTag(), nullability.isNullable(), attributes);
                                        break block16;
                                    }
                                    if (!(t instanceof ConeFlexibleType)) break block19;
                                    if (nullability == ConeNullability.UNKNOWN && (((ConeFlexibleType)$this$withNullability).getLowerBound().getNullability() != ((ConeFlexibleType)$this$withNullability).getUpperBound().getNullability() || ((ConeFlexibleType)$this$withNullability).getLowerBound().getNullability() == ConeNullability.UNKNOWN)) {
                                        return $this$withNullability;
                                    }
                                    object = TypeUtilsKt.coneFlexibleOrSimpleType(typeContext2, TypeUtilsKt.withNullability$default(((ConeFlexibleType)$this$withNullability).getLowerBound(), nullability, null, null, 6, null), TypeUtilsKt.withNullability$default(((ConeFlexibleType)$this$withNullability).getUpperBound(), nullability, null, null, 6, null));
                                    break block16;
                                }
                                if (!(t instanceof ConeTypeVariableType)) break block20;
                                object = new ConeTypeVariableType(nullability, ((ConeTypeVariableType)$this$withNullability).getLookupTag());
                                break block16;
                            }
                            if (!(t instanceof ConeCapturedType)) break block21;
                            object = new ConeCapturedType(((ConeCapturedType)$this$withNullability).getCaptureStatus(), ((ConeCapturedType)$this$withNullability).getLowerType(), nullability, ((ConeCapturedType)$this$withNullability).getConstructor(), attributes);
                            break block16;
                        }
                        if (!(t instanceof ConeIntersectionType)) break block22;
                        switch (TypeUtilsKt$WhenMappings.$EnumSwitchMapping$0[nullability.ordinal()]) {
                            case 1: {
                                coneIntersectionType = ConeTypesKt.mapTypes((ConeIntersectionType)$this$withNullability, (Function1<? super ConeKotlinType, ? extends ConeKotlinType>)((Function1)new Function1<ConeKotlinType, ConeKotlinType>(nullability){
                                    final /* synthetic */ ConeNullability $nullability;

                                    @NotNull
                                    public final ConeKotlinType invoke(@NotNull ConeKotlinType it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return TypeUtilsKt.withNullability$default(it, this.$nullability, null, null, 6, null);
                                    }
                                    {
                                        this.$nullability = coneNullability;
                                        super(1);
                                    }
                                }));
                                break;
                            }
                            case 2: {
                                coneIntersectionType = (ConeIntersectionType)$this$withNullability;
                                break;
                            }
                            case 3: {
                                coneIntersectionType = (ConeIntersectionType)$this$withNullability;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        object = coneIntersectionType;
                        break block16;
                    }
                    if (!(t instanceof ConeStubType)) break block23;
                    object = new ConeStubType(((ConeStubType)$this$withNullability).getVariable(), nullability);
                    break block16;
                }
                if (!(t instanceof ConeDefinitelyNotNullType)) break block24;
                switch (TypeUtilsKt$WhenMappings.$EnumSwitchMapping$1[nullability.ordinal()]) {
                    case 1: {
                        object = $this$withNullability;
                        break block16;
                    }
                    case 2: {
                        object = TypeUtilsKt.withNullability$default(((ConeDefinitelyNotNullType)$this$withNullability).getOriginal(), nullability, null, null, 6, null);
                        break block16;
                    }
                    case 3: {
                        object = TypeUtilsKt.withNullability$default(((ConeDefinitelyNotNullType)$this$withNullability).getOriginal(), nullability, null, null, 6, null);
                        break block16;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (t instanceof ConeIntegerLiteralType) {
                object = new ConeIntegerLiteralTypeImpl(((ConeIntegerLiteralType)$this$withNullability).getValue(), ((ConeIntegerLiteralType)$this$withNullability).isUnsigned(), nullability);
            } else {
                String string2 = "sealed: " + Reflection.getOrCreateKotlinClass($this$withNullability.getClass());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type T");
        }
        return object;
    }

    public static /* synthetic */ ConeKotlinType withNullability$default(ConeKotlinType coneKotlinType, ConeNullability coneNullability, ConeInferenceContext coneInferenceContext, ConeAttributes coneAttributes, int n, Object object) {
        if ((n & 2) != 0) {
            coneInferenceContext = null;
        }
        if ((n & 4) != 0) {
            coneAttributes = coneKotlinType.getAttributes();
        }
        return TypeUtilsKt.withNullability(coneKotlinType, coneNullability, coneInferenceContext, coneAttributes);
    }

    @NotNull
    public static final ConeKotlinType coneFlexibleOrSimpleType(@Nullable ConeInferenceContext typeContext2, @NotNull ConeKotlinType lowerBound, @NotNull ConeKotlinType upperBound) {
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        if (lowerBound instanceof ConeFlexibleType) {
            return TypeUtilsKt.coneFlexibleOrSimpleType(typeContext2, ((ConeFlexibleType)lowerBound).getLowerBound(), upperBound);
        }
        if (upperBound instanceof ConeFlexibleType) {
            return TypeUtilsKt.coneFlexibleOrSimpleType(typeContext2, lowerBound, ((ConeFlexibleType)upperBound).getUpperBound());
        }
        return typeContext2 != null && AbstractStrictEqualityTypeChecker.INSTANCE.strictEqualTypes(typeContext2, lowerBound, upperBound) ? lowerBound : (typeContext2 == null && Intrinsics.areEqual((Object)lowerBound, (Object)upperBound) ? lowerBound : (ConeKotlinType)new ConeFlexibleType(lowerBound, upperBound));
    }

    public static final boolean isExtensionFunctionType(@NotNull ConeKotlinType $this$isExtensionFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionFunctionType, (String)"$this$isExtensionFunctionType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(ConeTypesKt.lowerBoundIfFlexible($this$isExtensionFunctionType), session2);
        return CompilerConeAttributesKt.getExtensionFunctionType(type2.getAttributes()) != null;
    }

    public static final boolean isExtensionFunctionType(@NotNull FirTypeRef $this$isExtensionFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionFunctionType, (String)"$this$isExtensionFunctionType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef $this$coneTypeSafe$iv = $this$isExtensionFunctionType;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType != null && TypeUtilsKt.isExtensionFunctionType(coneKotlinType, session2);
    }

    public static final boolean isUnsafeVarianceType(@NotNull ConeKotlinType $this$isUnsafeVarianceType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsafeVarianceType, (String)"$this$isUnsafeVarianceType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(ConeTypesKt.lowerBoundIfFlexible($this$isUnsafeVarianceType), session2);
        return CompilerConeAttributesKt.getUnsafeVarianceType(type2.getAttributes()) != null;
    }

    public static final boolean isUnsafeVarianceType(@NotNull FirTypeRef $this$isUnsafeVarianceType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsafeVarianceType, (String)"$this$isUnsafeVarianceType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef $this$coneTypeSafe$iv = $this$isUnsafeVarianceType;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType != null && TypeUtilsKt.isUnsafeVarianceType(coneKotlinType, session2);
    }

    public static final boolean hasEnhancedNullability(@NotNull FirTypeRef $this$hasEnhancedNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnhancedNullability, (String)"$this$hasEnhancedNullability");
        FirTypeRef $this$coneTypeSafe$iv = $this$hasEnhancedNullability;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType != null && CompilerConeAttributesKt.getHasEnhancedNullability(coneKotlinType);
    }

    public static final boolean hasFlexibleNullability(@NotNull FirTypeRef $this$hasFlexibleNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFlexibleNullability, (String)"$this$hasFlexibleNullability");
        FirTypeRef $this$coneTypeSafe$iv = $this$hasFlexibleNullability;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType != null && CompilerConeAttributesKt.getHasFlexibleNullability(coneKotlinType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirTypeRef withoutEnhancedNullability(@NotNull FirTypeRef $this$withoutEnhancedNullability) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$withoutEnhancedNullability, (String)"$this$withoutEnhancedNullability");
        boolean bl = $this$withoutEnhancedNullability instanceof FirResolvedTypeRef;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (!TypeUtilsKt.hasEnhancedNullability($this$withoutEnhancedNullability)) {
            return $this$withoutEnhancedNullability;
        }
        boolean $i$f$buildResolvedTypeRef = false;
        bl2 = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        bl3 = false;
        bl4 = false;
        FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
        boolean bl6 = false;
        $this$buildResolvedTypeRef.setSource($this$withoutEnhancedNullability.getSource());
        Iterable iterable = ((FirResolvedTypeRef)$this$withoutEnhancedNullability).getType().getAttributes();
        ConeAttributes.Companion companion = ConeAttributes.Companion;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$withoutEnhancedNullability).getType();
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = $this$buildResolvedTypeRef;
        boolean $i$f$filter = false;
        void var12_16 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConeAttribute it = (ConeAttribute)element$iv$iv;
            boolean bl7 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)CompilerConeAttributes.EnhancedNullability.INSTANCE) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        firResolvedTypeRefBuilder2.setType(TypeUtilsKt.withAttributes(coneKotlinType, companion.create(list2)));
        iterable = $this$buildResolvedTypeRef.getAnnotations();
        Iterable iterable2 = $this$withoutEnhancedNullability.getAnnotations();
        boolean bl8 = false;
        CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
        return firResolvedTypeRefBuilder.build();
    }

    @NotNull
    public static final FirTypeRef withReplacedReturnType(@NotNull FirTypeRef $this$withReplacedReturnType, @Nullable ConeKotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)$this$withReplacedReturnType, (String)"$this$withReplacedReturnType");
        boolean bl = $this$withReplacedReturnType instanceof FirResolvedTypeRef || newType == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (newType == null) {
            return $this$withReplacedReturnType;
        }
        boolean $i$f$buildResolvedTypeRef = false;
        bl2 = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        bl3 = false;
        bl4 = false;
        FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
        boolean bl6 = false;
        $this$buildResolvedTypeRef.setSource($this$withReplacedReturnType.getSource());
        $this$buildResolvedTypeRef.setType(newType);
        Collection collection = $this$buildResolvedTypeRef.getAnnotations();
        Iterable iterable = $this$withReplacedReturnType.getAnnotations();
        boolean bl7 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return firResolvedTypeRefBuilder.build();
    }

    @NotNull
    public static final FirResolvedTypeRef withReplacedConeType(@NotNull FirTypeRef $this$withReplacedConeType, @Nullable ConeKotlinType newType, @Nullable FirFakeSourceElementKind firFakeSourceElementKind) {
        FirSourceElement firSourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$withReplacedConeType, (String)"$this$withReplacedConeType");
        boolean bl = $this$withReplacedConeType instanceof FirResolvedTypeRef;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (newType == null) {
            return (FirResolvedTypeRef)$this$withReplacedConeType;
        }
        boolean $i$f$buildResolvedTypeRef = false;
        bl2 = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        bl3 = false;
        bl4 = false;
        FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
        boolean bl6 = false;
        if (firFakeSourceElementKind != null) {
            FirSourceElement firSourceElement2 = $this$withReplacedConeType.getSource();
            firSourceElement = firSourceElement2 != null ? FirSourceElementKt.fakeElement(firSourceElement2, firFakeSourceElementKind) : null;
        } else {
            firSourceElement = $this$withReplacedConeType.getSource();
        }
        $this$buildResolvedTypeRef.setSource(firSourceElement);
        $this$buildResolvedTypeRef.setType(newType);
        Collection collection = $this$buildResolvedTypeRef.getAnnotations();
        Iterable iterable = $this$withReplacedConeType.getAnnotations();
        boolean bl7 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return firResolvedTypeRefBuilder.build();
    }

    public static /* synthetic */ FirResolvedTypeRef withReplacedConeType$default(FirTypeRef firTypeRef, ConeKotlinType coneKotlinType, FirFakeSourceElementKind firFakeSourceElementKind, int n, Object object) {
        if ((n & 2) != 0) {
            firFakeSourceElementKind = null;
        }
        return TypeUtilsKt.withReplacedConeType(firTypeRef, coneKotlinType, firFakeSourceElementKind);
    }

    @NotNull
    public static final FirTypeRef approximated(@NotNull FirTypeRef $this$approximated, @NotNull AbstractTypeApproximator typeApproximator, boolean toSuper, @NotNull TypeApproximatorConfiguration conf) {
        KotlinTypeMarker approximatedType;
        KotlinTypeMarker kotlinTypeMarker;
        KotlinTypeMarker kotlinTypeMarker2;
        boolean $i$f$coneTypeUnsafe;
        FirTypeRef $this$coneTypeUnsafe$iv$iv;
        boolean $i$f$getConeType;
        FirTypeRef $this$coneType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$approximated, (String)"$this$approximated");
        Intrinsics.checkNotNullParameter((Object)typeApproximator, (String)"typeApproximator");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        if (toSuper) {
            $this$coneType$iv = $this$approximated;
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            kotlinTypeMarker2 = typeApproximator.approximateToSuperType(coneKotlinType, conf);
        } else {
            $this$coneType$iv = $this$approximated;
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            kotlinTypeMarker2 = typeApproximator.approximateToSubType(coneKotlinType, conf);
        }
        if (!((kotlinTypeMarker = (approximatedType = kotlinTypeMarker2)) instanceof ConeKotlinType)) {
            kotlinTypeMarker = null;
        }
        return TypeUtilsKt.withReplacedConeType$default($this$approximated, (ConeKotlinType)kotlinTypeMarker, null, 2, null);
    }

    public static /* synthetic */ FirTypeRef approximated$default(FirTypeRef firTypeRef, AbstractTypeApproximator abstractTypeApproximator, boolean bl, TypeApproximatorConfiguration typeApproximatorConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            typeApproximatorConfiguration = TypeApproximatorConfiguration.PublicDeclaration.INSTANCE;
        }
        return TypeUtilsKt.approximated(firTypeRef, abstractTypeApproximator, bl, typeApproximatorConfiguration);
    }

    @NotNull
    public static final FirTypeRef approximatedIfNeededOrSelf(@NotNull FirTypeRef $this$approximatedIfNeededOrSelf, @NotNull AbstractTypeApproximator approximator2, @Nullable Visibility containingCallableVisibility, boolean isInlineFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$approximatedIfNeededOrSelf, (String)"$this$approximatedIfNeededOrSelf");
        Intrinsics.checkNotNullParameter((Object)approximator2, (String)"approximator");
        FirTypeRef approximatedType = $this$approximatedIfNeededOrSelf instanceof FirResolvedTypeRef && (Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Public.INSTANCE) || Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Protected.INSTANCE)) ? (TypeUtilsKt.requiresApproximationInPublicPosition(((FirResolvedTypeRef)$this$approximatedIfNeededOrSelf).getType()) ? TypeUtilsKt.approximated$default($this$approximatedIfNeededOrSelf, approximator2, true, null, 4, null) : $this$approximatedIfNeededOrSelf) : $this$approximatedIfNeededOrSelf;
        return TypeUtilsKt.withoutEnhancedNullability(TypeUtilsKt.hideLocalTypeIfNeeded(approximatedType, containingCallableVisibility, isInlineFunction));
    }

    public static /* synthetic */ FirTypeRef approximatedIfNeededOrSelf$default(FirTypeRef firTypeRef, AbstractTypeApproximator abstractTypeApproximator, Visibility visibility2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return TypeUtilsKt.approximatedIfNeededOrSelf(firTypeRef, abstractTypeApproximator, visibility2, bl);
    }

    private static final boolean requiresApproximationInPublicPosition(ConeKotlinType $this$requiresApproximationInPublicPosition) {
        boolean bl;
        block5: {
            ConeKotlinType coneKotlinType = $this$requiresApproximationInPublicPosition;
            if (coneKotlinType instanceof ConeIntegerLiteralType || coneKotlinType instanceof ConeCapturedType || coneKotlinType instanceof ConeDefinitelyNotNullType || coneKotlinType instanceof ConeIntersectionType) {
                bl = true;
            } else if (coneKotlinType instanceof ConeClassLikeType) {
                ConeTypeProjection[] $this$any$iv = $this$requiresApproximationInPublicPosition.getTypeArguments();
                boolean $i$f$any = false;
                ConeTypeProjection[] coneTypeProjectionArray = $this$any$iv;
                int n = coneTypeProjectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = coneTypeProjectionArray[i];
                    boolean bl2 = false;
                    if (!(it instanceof ConeKotlinTypeProjection && TypeUtilsKt.requiresApproximationInPublicPosition(((ConeKotlinTypeProjection)it).getType()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static final FirTypeRef hideLocalTypeIfNeeded(FirTypeRef $this$hideLocalTypeIfNeeded, Visibility containingCallableVisibility, boolean isInlineFunction) {
        if (containingCallableVisibility == null) {
            return $this$hideLocalTypeIfNeeded;
        }
        if (Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Public.INSTANCE) || Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Protected.INSTANCE) || Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Internal.INSTANCE) || Intrinsics.areEqual((Object)containingCallableVisibility, (Object)Visibilities.Private.INSTANCE) && isInlineFunction) {
            Object object;
            FirClass firClass;
            Object object2;
            FirTypeRef firTypeRef = $this$hideLocalTypeIfNeeded;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassLikeType != null ? coneClassLikeType.getLookupTag() : null;
            if (!(coneClassLikeLookupTag instanceof ConeClassLookupTagWithFixedSymbol)) {
                coneClassLikeLookupTag = null;
            }
            if ((object2 = (firClass = (object = (ConeClassLookupTagWithFixedSymbol)coneClassLikeLookupTag) != null && (object = ((ConeClassLookupTagWithFixedSymbol)object).getSymbol()) != null ? (FirClass)((AbstractFirBasedSymbol)object).getFir() : null)) == null || (object2 = FirDeclarationUtilKt.getClassId(object2)) == null || !((ClassId)object2).isLocal()) {
                return $this$hideLocalTypeIfNeeded;
            }
            if (firClass.getSuperTypeRefs().size() > 1) {
                boolean $i$f$buildErrorTypeRef = false;
                boolean bl = false;
                FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirErrorTypeRefBuilder $this$buildErrorTypeRef = firErrorTypeRefBuilder;
                boolean bl4 = false;
                $this$buildErrorTypeRef.setDiagnostic(new ConeSimpleDiagnostic("Cannot hide local type " + FirRendererKt.render$default(firClass, null, 1, null), null, 2, null));
                return firErrorTypeRefBuilder.build();
            }
            FirTypeRef superType = (FirTypeRef)CollectionsKt.single(firClass.getSuperTypeRefs());
            if (superType instanceof FirResolvedTypeRef && !FirTypeUtilsKt.isAny(superType)) {
                return superType;
            }
        }
        return $this$hideLocalTypeIfNeeded;
    }
}

