/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0010\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u00a8\u0006\t"}, d2={"erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asString", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "getJsInlinedClass", "backend.js"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $this$asString) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        IrType irType = $this$asString;
        if (irType instanceof IrErrorType) {
            string2 = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string2 = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string3;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$this$asString).getClassifier())).append(((IrSimpleType)$this$asString).getHasQuestionMark() ? "?" : "");
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)$this$asString).getArguments();
            boolean $i$f$ifNotEmpty = false;
            Collection collection = $this$ifNotEmpty$iv;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$ifNotEmpty;
                List list2 = (List)$this$ifNotEmpty$iv;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl2 = false;
                String string5 = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$ifNotEmpty), (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)asString.1.1.INSTANCE, (int)24, null);
                stringBuilder2 = stringBuilder3;
                string4 = string5;
            } else {
                string4 = string3 = null;
            }
            if (string4 == null) {
                string3 = "";
            }
            string2 = stringBuilder2.append(string3).toString();
        } else {
            String string6 = "Unexpected kind of IrType: " + $this$asString.getClass().getTypeName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string6.toString());
        }
        return string2;
    }

    private static final String asString(IrTypeArgument $this$asString) {
        String string2;
        IrTypeArgument irTypeArgument = $this$asString;
        if (irTypeArgument instanceof IrStarProjection) {
            string2 = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string2 = ((IrTypeProjection)$this$asString).getVariance().getLabel() + (((IrTypeProjection)$this$asString).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$this$asString).getType());
        } else {
            String string3 = "Unexpected kind of IrTypeArgument: " + $this$asString.getClass().getSimpleName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string2;
    }

    private static final String asString(IrClassifierSymbol $this$asString) {
        String string2;
        IrClassifierSymbol irClassifierSymbol = $this$asString;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            string2 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$asString).getOwner()).getName().asString();
        } else if (irClassifierSymbol instanceof IrClassSymbol) {
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrClassSymbol)$this$asString).getOwner());
            Intrinsics.checkNotNull((Object)fqName2);
            string2 = fqName2.asString();
        } else {
            String string3 = "Unexpected kind of IrClassifierSymbol: " + $this$asString.getClass().getTypeName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (this) {\n    is IrT\u2026\" + javaClass.typeName)\n}");
        return string2;
    }

    @Nullable
    public static final IrClass getJsInlinedClass(@NotNull IrType $this$getJsInlinedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsInlinedClass, (String)"$this$getJsInlinedClass");
        if ($this$getJsInlinedClass instanceof IrSimpleType) {
            IrClass irClass2 = IrTypeUtilsKt.erase($this$getJsInlinedClass);
            if (irClass2 == null) {
                return null;
            }
            IrClass erased = irClass2;
            if (erased.isInline()) {
                if (IrTypePredicatesKt.isMarkedNullable($this$getJsInlinedClass)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = InlineClassesKt.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        if (IrTypeUtilsKt.getJsInlinedClass(fieldType) != null) continue;
                        break;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    @Nullable
    public static final IrClass erase(@NotNull IrType type2) {
        IrClass irClass2;
        block4: {
            IrClassifierSymbol irClassifierSymbol;
            IrClassifierSymbol classifier2;
            while (true) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                irClassifierSymbol = classifier2 = IrTypesKt.getClassifierOrFail(type2);
                if (irClassifierSymbol instanceof IrClassSymbol) {
                    irClass2 = (IrClass)((IrClassSymbol)classifier2).getOwner();
                    break block4;
                }
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) break;
                type2 = (IrType)CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes());
            }
            if (irClassifierSymbol instanceof IrScriptSymbol) {
                irClass2 = null;
            } else {
                boolean bl = false;
                throw (Throwable)new IllegalStateException(classifier2.toString());
            }
        }
        return irClass2;
    }

    public static final /* synthetic */ String access$asString(IrTypeArgument $this$access_u24asString) {
        return IrTypeUtilsKt.asString($this$access_u24asString);
    }
}

