/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b#\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u0017\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u0018\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u0019\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u001a\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u001b\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u001c\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u001d\u001a\u00020\b*\u00020\u0015\u001a%\u0010\u001e\u001a\u00020\b*\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00022\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010!\u001a\u001a\u0010\u001e\u001a\u00020\b*\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\b\u001a\u0012\u0010\"\u001a\u00020\b*\u00020#2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010$\u001a\u00020\b*\u00020\u0015\u001a\n\u0010%\u001a\u00020\b*\u00020\u0015\u001a\n\u0010&\u001a\u00020\b*\u00020\u0015\u001a\n\u0010'\u001a\u00020\b*\u00020\u0015\u001a\n\u0010(\u001a\u00020\b*\u00020\u0015\u001a\n\u0010)\u001a\u00020\b*\u00020\u0015\u001a\n\u0010*\u001a\u00020\b*\u00020\u0015\u001a\n\u0010+\u001a\u00020\b*\u00020\u0015\u001a\n\u0010,\u001a\u00020\b*\u00020\u0015\u001a\n\u0010-\u001a\u00020\b*\u00020\u0015\u001a\n\u0010.\u001a\u00020\b*\u00020\u0015\u001a\n\u0010/\u001a\u00020\b*\u00020\u0015\u001a\n\u00100\u001a\u00020\b*\u00020\u0015\u001a\n\u00101\u001a\u00020\b*\u00020\u0015\u001a\u0014\u00102\u001a\u00020\b*\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\n\u00103\u001a\u00020\b*\u00020\u0015\u001a\n\u00104\u001a\u00020\b*\u00020\u0015\u001a\n\u00105\u001a\u00020\b*\u00020\u0015\u001a\u0014\u00106\u001a\u00020\b*\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\n\u00107\u001a\u00020\b*\u00020\u0015\u001a\n\u00108\u001a\u00020\b*\u00020\u0015\u001a\n\u00109\u001a\u00020\b*\u00020\u0015\u001a\n\u0010:\u001a\u00020\b*\u00020\u0015\u001a\u0014\u0010;\u001a\u00020\b*\u00020\u00152\b\b\u0002\u0010 \u001a\u00020\b\u001a\n\u0010<\u001a\u00020\b*\u00020\u0015\u001a\n\u0010=\u001a\u00020\b*\u00020\u0015\u001a\n\u0010>\u001a\u00020\b*\u00020\u0015\u001a\n\u0010?\u001a\u00020\b*\u00020\u0015\u001a\n\u0010@\u001a\u00020\b*\u00020\u0015\u001a\n\u0010A\u001a\u00020\b*\u00020\u0015\u001a\n\u0010B\u001a\u00020\b*\u00020\u0015\u001a\n\u0010C\u001a\u00020\b*\u00020\u0015\u001a\n\u0010D\u001a\u00020\b*\u00020\u0015\u001a\n\u0010E\u001a\u00020\b*\u00020\u0015\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006F"}, d2={"idSignatureToPrimitiveType", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "primitiveArrayTypesSignatures", "getPrimitiveArrayTypesSignatures", "()Ljava/util/Map;", "classFqNameEquals", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getPublicSignature", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "", "isAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isArray", "isBoolean", "isBooleanArray", "isByte", "isByteArray", "isChar", "isCharArray", "isCharSequence", "isClassType", "signature", "hasQuestionMark", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;Ljava/lang/Boolean;)Z", "isClassWithFqName", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isCollection", "isComparable", "isDouble", "isDoubleArray", "isFloat", "isFloatArray", "isInt", "isIntArray", "isIterable", "isKClass", "isKotlinResult", "isLong", "isLongArray", "isMarkedNullable", "isNotNullClassType", "isNothing", "isNullableAny", "isNullableArray", "isNullableClassType", "isNullableContinuation", "isNullablePrimitiveType", "isNullableString", "isNumber", "isPrimitiveType", "isSequence", "isShort", "isShortArray", "isString", "isStringClassType", "isUByte", "isUInt", "isULong", "isUShort", "isUnit", "ir.tree"})
public final class IrTypePredicatesKt {
    private static final Map<IdSignature.PublicSignature, PrimitiveType> idSignatureToPrimitiveType;
    @NotNull
    private static final Map<PrimitiveType, IdSignature.PublicSignature> primitiveArrayTypesSignatures;

    private static final boolean isNotNullClassType(IrType $this$isNotNullClassType, IdSignature.PublicSignature signature2) {
        return IrTypePredicatesKt.isClassType($this$isNotNullClassType, signature2, (Boolean)false);
    }

    private static final boolean isNullableClassType(IrType $this$isNullableClassType, IdSignature.PublicSignature signature2) {
        return IrTypePredicatesKt.isClassType($this$isNullableClassType, signature2, (Boolean)true);
    }

    @NotNull
    public static final IdSignature.PublicSignature getPublicSignature(@NotNull FqName packageFqName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqName.asString()");
        return new IdSignature.PublicSignature(string2, name, null, 0L);
    }

    private static final boolean isClassType(IrType $this$isClassType, IdSignature.PublicSignature signature2, Boolean hasQuestionMark) {
        if (!($this$isClassType instanceof IrSimpleType)) {
            return false;
        }
        if (hasQuestionMark != null && Intrinsics.areEqual((Object)((IrSimpleType)$this$isClassType).getHasQuestionMark(), (Object)hasQuestionMark) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)signature2, (Object)((IrSimpleType)$this$isClassType).getClassifier().getSignature());
    }

    static /* synthetic */ boolean isClassType$default(IrType irType, IdSignature.PublicSignature publicSignature, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return IrTypePredicatesKt.isClassType(irType, publicSignature, bl);
    }

    public static final boolean isClassWithFqName(@NotNull IrClassifierSymbol $this$isClassWithFqName, @NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassWithFqName, (String)"$this$isClassWithFqName");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return $this$isClassWithFqName instanceof IrClassSymbol && IrTypePredicatesKt.classFqNameEquals((IrClassSymbol)$this$isClassWithFqName, fqName2);
    }

    private static final boolean classFqNameEquals(IrClassSymbol symbol2, FqNameUnsafe fqName2) {
        boolean bl = symbol2.isBound();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return IrTypePredicatesKt.classFqNameEquals((IrClass)symbol2.getOwner(), fqName2);
    }

    @NotNull
    public static final Map<PrimitiveType, IdSignature.PublicSignature> getPrimitiveArrayTypesSignatures() {
        return primitiveArrayTypesSignatures;
    }

    private static final boolean classFqNameEquals(IrClass declaration2, FqNameUnsafe fqName2) {
        IrDeclarationWithName irDeclarationWithName = declaration2;
        FqName fqName3 = fqName2.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.toSafe()");
        return AdditionalIrUtilsKt.hasEqualFqName(irDeclarationWithName, fqName3);
    }

    public static final boolean isAny(@NotNull IrType $this$isAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isAny, (String)"$this$isAny");
        return IrTypePredicatesKt.isNotNullClassType($this$isAny, IdSignatureValues.any);
    }

    public static final boolean isNullableAny(@NotNull IrType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"$this$isNullableAny");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableAny, IdSignatureValues.any);
    }

    public static final boolean isString(@NotNull IrType $this$isString) {
        Intrinsics.checkNotNullParameter((Object)$this$isString, (String)"$this$isString");
        return IrTypePredicatesKt.isNotNullClassType($this$isString, IdSignatureValues.string);
    }

    public static final boolean isNullableString(@NotNull IrType $this$isNullableString) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableString, (String)"$this$isNullableString");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableString, IdSignatureValues.string);
    }

    public static final boolean isStringClassType(@NotNull IrType $this$isStringClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isStringClassType, (String)"$this$isStringClassType");
        return IrTypePredicatesKt.isClassType$default($this$isStringClassType, IdSignatureValues.string, null, 2, null);
    }

    public static final boolean isArray(@NotNull IrType $this$isArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isArray, (String)"$this$isArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isArray, IdSignatureValues.array);
    }

    public static final boolean isNullableArray(@NotNull IrType $this$isNullableArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableArray, (String)"$this$isNullableArray");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableArray, IdSignatureValues.array);
    }

    public static final boolean isCollection(@NotNull IrType $this$isCollection) {
        Intrinsics.checkNotNullParameter((Object)$this$isCollection, (String)"$this$isCollection");
        return IrTypePredicatesKt.isNotNullClassType($this$isCollection, IdSignatureValues.collection);
    }

    public static final boolean isNothing(@NotNull IrType $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"$this$isNothing");
        return IrTypePredicatesKt.isNotNullClassType($this$isNothing, IdSignatureValues.nothing);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveType(@NotNull IrType $this$isPrimitiveType, boolean hasQuestionMark) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveType, (String)"$this$isPrimitiveType");
        if (!($this$isPrimitiveType instanceof IrSimpleType)) return false;
        if (hasQuestionMark != ((IrSimpleType)$this$isPrimitiveType).getHasQuestionMark()) return false;
        Map<IdSignature.PublicSignature, PrimitiveType> map2 = idSignatureToPrimitiveType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isPrimitiveType);
        IdSignature idSignature = irClassSymbol != null ? irClassSymbol.getSignature() : null;
        boolean bl = false;
        Map<IdSignature.PublicSignature, PrimitiveType> map3 = map2;
        boolean bl2 = false;
        if (!map3.containsKey(idSignature)) return false;
        return true;
    }

    public static /* synthetic */ boolean isPrimitiveType$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IrTypePredicatesKt.isPrimitiveType(irType, bl);
    }

    public static final boolean isNullablePrimitiveType(@NotNull IrType $this$isNullablePrimitiveType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullablePrimitiveType, (String)"$this$isNullablePrimitiveType");
        return IrTypePredicatesKt.isPrimitiveType($this$isNullablePrimitiveType, true);
    }

    public static final boolean isMarkedNullable(@NotNull IrType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"$this$isMarkedNullable");
        IrType irType = $this$isMarkedNullable;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        return irSimpleType != null ? irSimpleType.getHasQuestionMark() : false;
    }

    public static final boolean isUnit(@NotNull IrType $this$isUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnit, (String)"$this$isUnit");
        return IrTypePredicatesKt.isNotNullClassType($this$isUnit, IdSignatureValues.unit);
    }

    public static final boolean isBoolean(@NotNull IrType $this$isBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoolean, (String)"$this$isBoolean");
        return IrTypePredicatesKt.isNotNullClassType($this$isBoolean, IdSignatureValues._boolean);
    }

    public static final boolean isChar(@NotNull IrType $this$isChar) {
        Intrinsics.checkNotNullParameter((Object)$this$isChar, (String)"$this$isChar");
        return IrTypePredicatesKt.isNotNullClassType($this$isChar, IdSignatureValues._char);
    }

    public static final boolean isByte(@NotNull IrType $this$isByte) {
        Intrinsics.checkNotNullParameter((Object)$this$isByte, (String)"$this$isByte");
        return IrTypePredicatesKt.isNotNullClassType($this$isByte, IdSignatureValues._byte);
    }

    public static final boolean isShort(@NotNull IrType $this$isShort) {
        Intrinsics.checkNotNullParameter((Object)$this$isShort, (String)"$this$isShort");
        return IrTypePredicatesKt.isNotNullClassType($this$isShort, IdSignatureValues._short);
    }

    public static final boolean isInt(@NotNull IrType $this$isInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isInt, (String)"$this$isInt");
        return IrTypePredicatesKt.isNotNullClassType($this$isInt, IdSignatureValues._int);
    }

    public static final boolean isLong(@NotNull IrType $this$isLong) {
        Intrinsics.checkNotNullParameter((Object)$this$isLong, (String)"$this$isLong");
        return IrTypePredicatesKt.isNotNullClassType($this$isLong, IdSignatureValues._long);
    }

    public static final boolean isUByte(@NotNull IrType $this$isUByte) {
        Intrinsics.checkNotNullParameter((Object)$this$isUByte, (String)"$this$isUByte");
        return IrTypePredicatesKt.isNotNullClassType($this$isUByte, IdSignatureValues.uByte);
    }

    public static final boolean isUShort(@NotNull IrType $this$isUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$isUShort, (String)"$this$isUShort");
        return IrTypePredicatesKt.isNotNullClassType($this$isUShort, IdSignatureValues.uShort);
    }

    public static final boolean isUInt(@NotNull IrType $this$isUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isUInt, (String)"$this$isUInt");
        return IrTypePredicatesKt.isNotNullClassType($this$isUInt, IdSignatureValues.uInt);
    }

    public static final boolean isULong(@NotNull IrType $this$isULong) {
        Intrinsics.checkNotNullParameter((Object)$this$isULong, (String)"$this$isULong");
        return IrTypePredicatesKt.isNotNullClassType($this$isULong, IdSignatureValues.uLong);
    }

    public static final boolean isFloat(@NotNull IrType $this$isFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$isFloat, (String)"$this$isFloat");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloat, IdSignatureValues._float);
    }

    public static final boolean isDouble(@NotNull IrType $this$isDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$isDouble, (String)"$this$isDouble");
        return IrTypePredicatesKt.isNotNullClassType($this$isDouble, IdSignatureValues._double);
    }

    public static final boolean isNumber(@NotNull IrType $this$isNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isNumber, (String)"$this$isNumber");
        return IrTypePredicatesKt.isNotNullClassType($this$isNumber, IdSignatureValues.number);
    }

    public static final boolean isComparable(@NotNull IrType $this$isComparable) {
        Intrinsics.checkNotNullParameter((Object)$this$isComparable, (String)"$this$isComparable");
        return IrTypePredicatesKt.isNotNullClassType($this$isComparable, IdSignatureValues.comparable);
    }

    public static final boolean isCharSequence(@NotNull IrType $this$isCharSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharSequence, (String)"$this$isCharSequence");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharSequence, IdSignatureValues.charSequence);
    }

    public static final boolean isIterable(@NotNull IrType $this$isIterable) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterable, (String)"$this$isIterable");
        return IrTypePredicatesKt.isNotNullClassType($this$isIterable, IdSignatureValues.iterable);
    }

    public static final boolean isSequence(@NotNull IrType $this$isSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$isSequence, (String)"$this$isSequence");
        return IrTypePredicatesKt.isNotNullClassType($this$isSequence, IdSignatureValues.sequence);
    }

    public static final boolean isBooleanArray(@NotNull IrType $this$isBooleanArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBooleanArray, (String)"$this$isBooleanArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.BOOLEAN);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isBooleanArray, publicSignature);
    }

    public static final boolean isCharArray(@NotNull IrType $this$isCharArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharArray, (String)"$this$isCharArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.CHAR);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isCharArray, publicSignature);
    }

    public static final boolean isByteArray(@NotNull IrType $this$isByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isByteArray, (String)"$this$isByteArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.BYTE);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isByteArray, publicSignature);
    }

    public static final boolean isShortArray(@NotNull IrType $this$isShortArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isShortArray, (String)"$this$isShortArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.SHORT);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isShortArray, publicSignature);
    }

    public static final boolean isIntArray(@NotNull IrType $this$isIntArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntArray, (String)"$this$isIntArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.INT);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isIntArray, publicSignature);
    }

    public static final boolean isLongArray(@NotNull IrType $this$isLongArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isLongArray, (String)"$this$isLongArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.LONG);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isLongArray, publicSignature);
    }

    public static final boolean isFloatArray(@NotNull IrType $this$isFloatArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isFloatArray, (String)"$this$isFloatArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.FLOAT);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isFloatArray, publicSignature);
    }

    public static final boolean isDoubleArray(@NotNull IrType $this$isDoubleArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isDoubleArray, (String)"$this$isDoubleArray");
        IdSignature.PublicSignature publicSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.DOUBLE);
        Intrinsics.checkNotNull((Object)publicSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isDoubleArray, publicSignature);
    }

    public static final boolean isClassType(@NotNull IrType $this$isClassType, @NotNull FqNameUnsafe fqName2, boolean hasQuestionMark) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassType, (String)"$this$isClassType");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (!($this$isClassType instanceof IrSimpleType)) {
            return false;
        }
        if (((IrSimpleType)$this$isClassType).getHasQuestionMark() != hasQuestionMark) {
            return false;
        }
        return IrTypePredicatesKt.isClassWithFqName(((IrSimpleType)$this$isClassType).getClassifier(), fqName2);
    }

    public static final boolean isKotlinResult(@NotNull IrType $this$isKotlinResult) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinResult, (String)"$this$isKotlinResult");
        FqNameUnsafe fqNameUnsafe = StandardNames.RESULT_FQ_NAME.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.RESULT_FQ_NAME.toUnsafe()");
        return IrTypePredicatesKt.isClassType($this$isKotlinResult, fqNameUnsafe, false);
    }

    public static final boolean isNullableContinuation(@NotNull IrType $this$isNullableContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableContinuation, (String)"$this$isNullableContinuation");
        FqNameUnsafe fqNameUnsafe = StandardNames.CONTINUATION_INTERFACE_FQ_NAME_RELEASE.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.CONTINUATI\u2026Q_NAME_RELEASE.toUnsafe()");
        return IrTypePredicatesKt.isClassType($this$isNullableContinuation, fqNameUnsafe, true);
    }

    public static final boolean isKClass(@NotNull IrType $this$isKClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isKClass, (String)"$this$isKClass");
        return IrTypePredicatesKt.isClassType($this$isKClass, StandardNames.FqNames.kClass, false);
    }

    static {
        HashMap hashMap = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
        boolean bl = false;
        boolean bl2 = false;
        HashMap $this$apply = hashMap;
        boolean bl3 = false;
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            Map map2 = $this$apply;
            String string2 = primitiveType.getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primitiveType.typeName.asString()");
            map2.put(IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, string2), primitiveType);
        }
        idSignatureToPrimitiveType = hashMap;
        hashMap = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
        bl = false;
        bl2 = false;
        $this$apply = hashMap;
        boolean bl4 = false;
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            ((Map)$this$apply).put(primitiveType, IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, primitiveType.getTypeName().asString() + "Array"));
        }
        primitiveArrayTypesSignatures = hashMap;
    }
}

