/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0014\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006*\u00020\u0001H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u001a)\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0014\u0010\u0015\u001a\u00020\u0002*\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0016"}, d2={"file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "unzipTo", "", "directory", "withZipFileSystem", "T", "action", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipDirAs", "unixFile", "zipFileSystem", "kotlin-util-io"})
public final class ZipUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"$this$zipFileSystem");
        HashMap attributes = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create2))});
        List<FileSystemProvider> list2 = FileSystemProvider.installedProviders();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"FileSystemProvider.installedProviders()");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl = false;
            FileSystemProvider fileSystemProvider = it;
            Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider, (String)"it");
            if (!Intrinsics.areEqual((Object)fileSystemProvider.getScheme(), (Object)"jar")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileSystem fileSystem;
            FileSystem fileSystem2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl2 = false;
            try {
                fileSystem2 = it.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof UnsupportedOperationException) && !(exception instanceof IllegalArgumentException)) {
                    throw (Throwable)e;
                }
                fileSystem2 = null;
            }
            if (fileSystem2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            FileSystem it$iv$iv = fileSystem;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (FileSystem)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(File file2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.zipFileSystem(file2, bl);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"$this$file");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Path path2 = $this$file.getPath(file2.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(file.path)");
        return new File(path2);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"$this$file");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path path3 = $this$file.getPath(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.getPath(path)");
        return new File(path3);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    public static final void zipDirAs(@NotNull File $this$zipDirAs, @NotNull File unixFile) {
        Intrinsics.checkNotNullParameter((Object)$this$zipDirAs, (String)"$this$zipDirAs");
        Intrinsics.checkNotNullParameter((Object)unixFile, (String)"unixFile");
        ZipUtilKt.withZipFileSystem(unixFile, true, (Function1)new Function1<FileSystem, Unit>($this$zipDirAs){
            final /* synthetic */ File $this_zipDirAs;

            public final void invoke(@NotNull FileSystem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$this_zipDirAs.recursiveCopyTo(ZipUtilKt.file(it, "/"), true);
            }
            {
                this.$this_zipDirAs = file2;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"$this$unzipTo");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        URI zipUri = URI.create("jar:" + $this$unzipTo.toUri());
        AutoCloseable $this$use$iv = FileSystems.newFileSystem(zipUri, MapsKt.emptyMap(), null);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Path zipPath;
            FileSystem zipfs = (FileSystem)$this$use$iv;
            boolean bl = false;
            Path path2 = zipPath = zipfs.getPath("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"zipPath");
            FileKt.recursiveCopyTo$default(path2, directory, false, 2, null);
            zipfs = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create2, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"$this$withZipFileSystem");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"$this$withZipFileSystem");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }
}

