/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.SerializedDeclaration;
import org.jetbrains.kotlin.library.impl.IrMemoryWriter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrMemoryDeclarationWriter;", "Lorg/jetbrains/kotlin/library/impl/IrMemoryWriter;", "declarations", "", "Lorg/jetbrains/kotlin/library/SerializedDeclaration;", "(Ljava/util/List;)V", "INDEX_HEADER_SIZE", "", "SINGLE_INDEX_RECORD_SIZE", "writeData", "", "dataOutput", "Ljava/io/DataOutput;", "kotlin-util-klib"})
public final class IrMemoryDeclarationWriter
extends IrMemoryWriter {
    private final int SINGLE_INDEX_RECORD_SIZE;
    private final int INDEX_HEADER_SIZE;
    private final List<SerializedDeclaration> declarations;

    @Override
    protected void writeData(@NotNull DataOutput dataOutput) {
        Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
        dataOutput.writeInt(this.declarations.size());
        int dataOffset = this.INDEX_HEADER_SIZE + this.SINGLE_INDEX_RECORD_SIZE * this.declarations.size();
        for (SerializedDeclaration d : this.declarations) {
            dataOutput.writeInt(d.getId());
            dataOutput.writeInt(dataOffset);
            dataOutput.writeInt(d.getSize());
            dataOffset += d.getSize();
        }
        for (SerializedDeclaration d : this.declarations) {
            dataOutput.write(d.getBytes());
        }
    }

    public IrMemoryDeclarationWriter(@NotNull List<? extends SerializedDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        this.declarations = declarations2;
        this.SINGLE_INDEX_RECORD_SIZE = 12;
        this.INDEX_HEADER_SIZE = 4;
    }
}

