/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class DataClassDeclarationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            Object parameters2;
            KtPrimaryConstructor primaryConstructor2;
            Object object;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null) {
                Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)descriptor2).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.constructors");
                Object object2 = collection;
                boolean bl = false;
                if (!object2.isEmpty()) {
                    PsiElement psiElement = ((KtClassOrObject)declaration2).getNameIdentifier();
                    if (psiElement != null) {
                        object2 = psiElement;
                        bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        context2.getTrace().report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on((PsiElement)it));
                    }
                }
            }
            if ((object = (primaryConstructor2 = ((KtClassOrObject)declaration2).getPrimaryConstructor())) == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
                object = parameters2 = CollectionsKt.emptyList();
            }
            if (parameters2.isEmpty()) {
                KtElementImplStub ktElementImplStub = primaryConstructor2;
                PsiElement psiElement = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : ((KtClassOrObject)declaration2).getNameIdentifier();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    boolean bl = false;
                    boolean bl4 = false;
                    PsiElement it = psiElement2;
                    boolean bl5 = false;
                    context2.getTrace().report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on(it));
                }
            }
            Iterator iterator2 = parameters2.iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter;
                KtParameter ktParameter = parameter = (KtParameter)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"parameter");
                if (ktParameter.isVarArg()) {
                    context2.getTrace().report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                context2.getTrace().report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

