/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend.java"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmOverloadsAnnotation(descriptor2);
            if (annotationDescriptor == null) break block1;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationDescriptor annotation2 = annotationDescriptor2;
            boolean bl3 = false;
            KtAnnotationEntry annotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
            if (annotationEntry != null) {
                this.checkDeclaration(annotationEntry, descriptor2, context2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtAnnotationEntry annotationEntry, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        block7: {
            block14: {
                block13: {
                    block5: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block6: {
                                                diagnosticHolder = context.getTrace();
                                                if (!(descriptor instanceof CallableDescriptor)) {
                                                    return;
                                                }
                                                v0 = ((CallableDescriptor)descriptor).getContainingDeclaration();
                                                if (!(v0 instanceof ClassDescriptor)) {
                                                    v0 = null;
                                                }
                                                v1 = (ClassDescriptor)v0;
                                                if ((v1 != null ? v1.getKind() : null) != ClassKind.INTERFACE) break block6;
                                                diagnosticHolder.report(ErrorsJvm.OVERLOADS_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                                break block7;
                                            }
                                            if (!(descriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)descriptor).getModality() != Modality.ABSTRACT) break block8;
                                            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                            break block7;
                                        }
                                        if (!DescriptorUtils.isLocal(descriptor)) break block9;
                                        diagnosticHolder.report(ErrorsJvm.OVERLOADS_LOCAL.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                        break block7;
                                    }
                                    if (!DescriptorUtilsKt.isAnnotationConstructor(descriptor)) break block10;
                                    diagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitJvmOverloadsOnConstructorsOfAnnotationClasses) != false ? ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR : ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR_WARNING;
                                    diagnosticHolder.report(diagnostic.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                    break block7;
                                }
                                if (((CallableDescriptor)descriptor).getVisibility().isPublicAPI() || !(Intrinsics.areEqual((Object)((CallableDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.INTERNAL) ^ true)) break block11;
                                diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                break block7;
                            }
                            v2 = ((CallableDescriptor)descriptor).getValueParameters();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"descriptor.valueParameters");
                            $this$none$iv = v2;
                            $i$f$none = false;
                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block12;
                            v3 = true;
                            break block5;
                        }
                        for (T element$iv : $this$none$iv) {
                            it = (ValueParameterDescriptor)element$iv;
                            $i$a$-none-OverloadsAnnotationChecker$checkDeclaration$1 = false;
                            if (it.declaresDefaultValue()) ** GOTO lbl-1000
                            v4 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                            if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(v4)) lbl-1000:
                            // 2 sources

                            {
                                v5 = true;
                            } else {
                                v5 = false;
                            }
                            if (!v5) continue;
                            v3 = false;
                            break block5;
                        }
                        v3 = true;
                    }
                    if (!v3) break block13;
                    diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                    break block7;
                }
                if (!(descriptor instanceof SimpleFunctionDescriptor) || !InlineClassManglingRulesKt.requiresFunctionNameManglingForParameterTypes((CallableMemberDescriptor)descriptor) && !InlineClassManglingRulesKt.requiresFunctionNameManglingForReturnType((CallableMemberDescriptor)descriptor)) break block14;
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_MANGLED_FUNCTION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                break block7;
            }
            if (!(descriptor instanceof ClassConstructorDescriptor) || !InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((CallableMemberDescriptor)descriptor)) break block7;
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_HIDDEN_CONSTRUCTOR.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }
}

