/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0004\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0018"}, d2={"getAbstractMembers", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getFunctionTypeForAbstractMethod", "Lorg/jetbrains/kotlin/types/SimpleType;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "shouldConvertFirstParameterToDescriptor", "", "getFunctionTypeForSamType", "Lorg/jetbrains/kotlin/types/KotlinType;", "samType", "samResolver", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;", "samConversionOracle", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;", "getSingleAbstractMethodOrNull", "klass", "nonProjectionParametrization", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "possibleSamType", "descriptors"})
public final class SamConversionResolverImplKt {
    @Nullable
    public static final FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull ClassDescriptor klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        String string2 = DescriptorUtilsKt.getFqNameSafe(klass).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"klass.fqNameSafe.asString()");
        if (StringsKt.endsWith$default((String)string2, (String)".databinding.DataBindingComponent", (boolean)false, (int)2, null)) {
            return null;
        }
        if (klass.isDefinitelyNotSamInterface()) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull(SamConversionResolverImplKt.getAbstractMembers(klass));
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor abstractMember = callableMemberDescriptor;
        return abstractMember instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)abstractMember).getTypeParameters().isEmpty() ? (FunctionDescriptor)abstractMember : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CallableMemberDescriptor> getAbstractMembers(@NotNull ClassDescriptor classDescriptor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(classDescriptor2.getUnsubstitutedMemberScope());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"DescriptorUtils\n        \u2026unsubstitutedMemberScope)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)it).getModality() == Modality.ABSTRACT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SimpleType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2, boolean shouldConvertFirstParameterToDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        KotlinType kotlinType = function2.getReturnType();
        if (kotlinType == null) {
            String string2 = "function is not initialized: " + function2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"function.returnType ?: e\u2026 initialized: $function\")");
        KotlinType returnType2 = kotlinType;
        List<ValueParameterDescriptor> list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"function.valueParameters");
        List<ValueParameterDescriptor> valueParameters2 = list2;
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        int startIndex = 0;
        KotlinType receiverType = null;
        ReceiverParameterDescriptor extensionReceiver = function2.getExtensionReceiverParameter();
        if (extensionReceiver != null) {
            receiverType = extensionReceiver.getType();
        } else if (shouldConvertFirstParameterToDescriptor) {
            List<ValueParameterDescriptor> list3 = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"function.valueParameters");
            Collection collection = list3;
            n = 0;
            if (!collection.isEmpty()) {
                ValueParameterDescriptor valueParameterDescriptor = valueParameters2.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameters[0]");
                receiverType = valueParameterDescriptor.getType();
                startIndex = 1;
            }
        }
        int n2 = startIndex;
        n = valueParameters2.size();
        while (n2 < n) {
            void i;
            ValueParameterDescriptor parameter;
            ValueParameterDescriptor valueParameterDescriptor = parameter = valueParameters2.get((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
            parameterTypes.add(valueParameterDescriptor.getType());
            parameterNames.add(function2.hasSynthesizedParameterNames() ? SpecialNames.NO_NAME_PROVIDED : parameter.getName());
            ++i;
        }
        return FunctionTypesKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function2), Annotations.Companion.getEMPTY(), receiverType, (List<? extends KotlinType>)parameterTypes, (List<Name>)parameterNames, returnType2, function2.isSuspend());
    }

    @Nullable
    public static final UnwrappedType getFunctionTypeForPossibleSamType(@NotNull SamConversionResolver $this$getFunctionTypeForPossibleSamType, @NotNull UnwrappedType possibleSamType, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionTypeForPossibleSamType, (String)"$this$getFunctionTypeForPossibleSamType");
        Intrinsics.checkNotNullParameter((Object)possibleSamType, (String)"possibleSamType");
        Intrinsics.checkNotNullParameter((Object)samConversionOracle, (String)"samConversionOracle");
        KotlinType kotlinType = SamConversionResolverImplKt.getFunctionTypeForSamType(possibleSamType, $this$getFunctionTypeForPossibleSamType, samConversionOracle);
        return kotlinType != null ? kotlinType.unwrap() : null;
    }

    @Nullable
    public static final KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType, @NotNull SamConversionResolver samResolver, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
        Intrinsics.checkNotNullParameter((Object)samResolver, (String)"samResolver");
        Intrinsics.checkNotNullParameter((Object)samConversionOracle, (String)"samConversionOracle");
        UnwrappedType unwrappedType = samType.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            SimpleType lower2 = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getLowerBound(), samResolver, samConversionOracle);
            SimpleType upper = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getUpperBound(), samResolver, samConversionOracle);
            boolean bl = lower2 == null == (upper == null);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Illegal flexible type: " + unwrappedType;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (lower2 == null || upper == null) {
                return null;
            }
            return KotlinTypeFactory.flexibleType(lower2, upper);
        }
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return SamConversionResolverImplKt.getFunctionTypeForSamType((SimpleType)unwrappedType2, samResolver, samConversionOracle);
    }

    private static final SimpleType getFunctionTypeForSamType(SimpleType samType, SamConversionResolver samResolver, SamConversionOracle samConversionOracle) {
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            return null;
        }
        if (!samConversionOracle.isPossibleSamType(samType)) {
            return null;
        }
        SimpleType simpleType2 = samResolver.resolveFunctionTypeIfSamInterface((ClassDescriptor)classifier2);
        if (simpleType2 == null) {
            return null;
        }
        SimpleType functionTypeDefault = simpleType2;
        SimpleType simpleType3 = SamConversionResolverImplKt.nonProjectionParametrization(samType);
        if (simpleType3 == null) {
            return null;
        }
        SimpleType noProjectionsSamType = simpleType3;
        KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
        boolean bl = type2 != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinType kotlinType = type2;
        Intrinsics.checkNotNull((Object)kotlinType);
        SimpleType simpleType4 = TypeSubstitutionKt.asSimpleType(kotlinType);
        return simpleType4.makeNullableAsSpecified(samType.isMarkedNullable());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SimpleType nonProjectionParametrization(@NotNull SimpleType samType) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TypeProjection it;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            Iterable $this$none$iv = samType.getArguments();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return samType;
        }
        List<TypeParameterDescriptor> list2 = samType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"samType.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        Set parametersSet = CollectionsKt.toSet((Iterable)parameters2);
        Iterable iterable = CollectionsKt.zip((Iterable)samType.getArguments(), (Iterable)parameters2);
        SimpleType simpleType2 = samType;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void projection;
            void it2;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Object object2 = it2;
            TypeProjection typeProjection = (TypeProjection)object2.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)object2.component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                object = projection;
            } else if (projection.isStarProjection()) {
                TypeParameterDescriptor typeParameterDescriptor = parameter;
                Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"parameter");
                List<KotlinType> list3 = typeParameterDescriptor.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"parameter.upperBounds");
                object2 = CollectionsKt.first(list3);
                boolean bl4 = false;
                boolean bl5 = false;
                KotlinType t = (KotlinType)object2;
                boolean bl6 = false;
                KotlinType kotlinType = t;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"t");
                object = (KotlinType)(!TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(parametersSet){
                    final /* synthetic */ Set $parametersSet$inlined;
                    {
                        this.$parametersSet$inlined = set;
                        super(1);
                    }

                    public final boolean invoke(@NotNull UnwrappedType it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CollectionsKt.contains((Iterable)this.$parametersSet$inlined, (Object)it.getConstructor().getDeclarationDescriptor());
                    }
                })) ? object2 : null);
                if (object == null || (object = TypeUtilsKt.asTypeProjection((KotlinType)object)) == null) {
                    return null;
                }
            } else {
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"projection.type");
                object = TypeUtilsKt.asTypeProjection(kotlinType);
            }
            void var21_24 = object;
            collection.add(var21_24);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(simpleType2, (List)collection, null, 2, null);
    }
}

