/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.container.SetterInfo;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\u0013"}, d2={"collectInterfacesRecursive", "", "type", "Ljava/lang/reflect/Type;", "result", "", "getConstructorInfo", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "c", "Ljava/lang/Class;", "getDefaultImplementation", "klass", "getRegistrations", "", "getSetterInfos", "Lorg/jetbrains/kotlin/container/SetterInfo;", "traverseClass", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getInfo", "container"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(@NotNull Class<?> $this$getInfo) {
        Intrinsics.checkNotNullParameter($this$getInfo, (String)"<this>");
        return ClassTraversalCache.INSTANCE.getClassInfo($this$getInfo);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c), CacheKt.getDefaultImplementation(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Method[] methodArray = c.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"c.methods");
        Method[] methodArray2 = methodArray;
        int n = 0;
        int n2 = methodArray2.length;
        while (n < n2) {
            Method method = methodArray2[n];
            ++n;
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                Type[] typeArray = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2)).getName();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"annotation.annotationClass.java.name");
                if (!StringsKt.endsWith$default((String)typeArray, (String)".Inject", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"method.genericParameterTypes");
                setterInfos.add(new SetterInfo(method, ArraysKt.toList((Object[])typeArray)));
            }
        }
        return setterInfos;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        List list2;
        void $this$filterTo$iv$iv;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructorArray = c.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"c.constructors");
        SpreadBuilder $this$filter$iv = (SpreadBuilder)constructorArray;
        boolean $i$f$filter = false;
        SpreadBuilder spreadBuilder2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Constructor it = (Constructor)element$iv$iv;
            boolean bl = false;
            if (!(Modifier.isPublic(it.getModifiers()) && !it.isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List publicConstructors = (List)destination$iv$iv;
        if (publicConstructors.size() != 1) {
            return null;
        }
        Constructor constructor2 = (Constructor)CollectionsKt.single((List)publicConstructors);
        if (c.getDeclaringClass() != null && !Modifier.isStatic(c.getModifiers())) {
            spreadBuilder2 = new SpreadBuilder(2);
            spreadBuilder2.add(c.getDeclaringClass());
            Type[] typeArray = constructor2.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"constructor.genericParameterTypes");
            spreadBuilder2.addSpread((Object)typeArray);
            list2 = CollectionsKt.listOf((Object[])spreadBuilder2.toArray((Object[])new Type[spreadBuilder2.size()]));
        } else {
            spreadBuilder2 = constructor2.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue((Object)spreadBuilder2, (String)"constructor.genericParameterTypes");
            list2 = ArraysKt.toList((Object[])spreadBuilder2);
        }
        List parameterTypes = list2;
        Intrinsics.checkNotNullExpressionValue((Object)constructor2, (String)"constructor");
        return new ConstructorInfo(constructor2, parameterTypes);
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        Type[] typeArray;
        Type type3 = type2;
        Class clazz = type3 instanceof Class ? (Class)type2 : (type3 instanceof ParameterizedType ? ((typeArray = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)typeArray : null) : null);
        Class klass = clazz;
        type3 = klass;
        if (type3 != null && (typeArray = ((Class)type3).getGenericInterfaces()) != null) {
            Type[] $this$forEach$iv = typeArray;
            boolean $i$f$forEach = false;
            Type[] typeArray2 = $this$forEach$iv;
            int n = typeArray2.length;
            for (int i = 0; i < n; ++i) {
                Type element$iv;
                Type it = element$iv = typeArray2[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!result2.add(it)) continue;
                CacheKt.collectInterfacesRecursive(it, result2);
            }
        }
    }

    private static final Class<?> getDefaultImplementation(Class<?> klass) {
        Class<?> clazz;
        DefaultImplementation defaultImplementation = klass.getAnnotation(DefaultImplementation.class);
        return defaultImplementation == null ? null : (clazz = defaultImplementation.impl());
    }

    private static final List<Type> getRegistrations(Class<?> klass) {
        ArrayList registrations = new ArrayList();
        Sequence superClasses2 = SequencesKt.generateSequence(klass, (Function1)getRegistrations.superClasses.1.INSTANCE);
        CollectionsKt.addAll((Collection)registrations, (Sequence)superClasses2);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence $this$forEach$iv = superClasses2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it = (Type)element$iv;
            boolean bl = false;
            CacheKt.collectInterfacesRecursive(it, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    public static final /* synthetic */ ClassInfo access$traverseClass(Class c) {
        return CacheKt.traverseClass(c);
    }
}

