/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a<\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0007\u001aB\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0007\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DOC_AND_COMMENT_TOKENS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "hasSyntaxErrors", "", "node", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "markElement", "", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "originalNode", "markRange", "from", "to", "checkers"})
public final class LightTreePositioningStrategyKt {
    @NotNull
    private static final Set<IElementType> DOC_AND_COMMENT_TOKENS;

    @NotNull
    public static final List<TextRange> markElement(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)originalNode, (String)"originalNode");
        if (node == originalNode) {
            return CollectionsKt.listOf((Object)new TextRange(startOffset, endOffset));
        }
        int startDelta = tree.getStartOffset(node) - tree.getStartOffset(originalNode);
        int endDelta = tree.getEndOffset(node) - tree.getEndOffset(originalNode);
        return CollectionsKt.listOf((Object)new TextRange(startDelta + startOffset, endDelta + endOffset));
    }

    public static /* synthetic */ List markElement$default(LighterASTNode lighterASTNode2, int n, int n2, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LighterASTNode lighterASTNode3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            lighterASTNode3 = lighterASTNode2;
        }
        return LightTreePositioningStrategyKt.markElement(lighterASTNode2, n, n2, flyweightCapableTreeStructure, lighterASTNode3);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull LighterASTNode from, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)originalNode, (String)"originalNode");
        int startDelta = tree.getStartOffset(from) - tree.getStartOffset(originalNode);
        int endDelta = tree.getEndOffset(to) - tree.getEndOffset(originalNode);
        return CollectionsKt.listOf((Object)new TextRange(startDelta + startOffset, endDelta + endOffset));
    }

    private static final boolean hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Boolean bl;
        Object v0;
        Object object;
        block5: {
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)TokenType.ERROR_ELEMENT)) {
                return true;
            }
            Ref<T[]> childrenRef = new Ref<T[]>();
            tree.getChildren(node, childrenRef);
            object = (LighterASTNode[])childrenRef.get();
            if (object == null) {
                return false;
            }
            Object[] children2 = object;
            List $this$lastOrNull$iv = ArraysKt.filterNotNull((Object[])children2);
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl2 = false;
                IElementType tokenType = it.getTokenType();
                if (!(!(tokenType instanceof KtSingleValueToken) && !DOC_AND_COMMENT_TOKENS.contains(tokenType))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        object = v0;
        if (object == null) {
            bl = null;
        } else {
            Object object2 = object;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            bl = LightTreePositioningStrategyKt.hasSyntaxErrors((LighterASTNode)it, tree);
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    public static final /* synthetic */ boolean access$hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure tree) {
        return LightTreePositioningStrategyKt.hasSyntaxErrors(node, tree);
    }

    static {
        Object[] objectArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.IDENTIFIER, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        DOC_AND_COMMENT_TOKENS = SetsKt.setOf((Object[])objectArray);
    }
}

