/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.OneElementWeakMap;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u001a\u0018\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\b2\u0006\u0010\t\u001a\u00020\f\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004\u001a\u0018\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004\u001a\u0016\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0006*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"bindSymbolToLookupTag", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/ConeClassLikeLookupTagImpl;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getSymbolByLookupTag", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "toFirRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "toSymbol", "useSiteSession", "toSymbolOrError", "resolve"})
public final class LookupTagUtilsKt {
    @Nullable
    public static final FirClassifierSymbol<?> toSymbol(@NotNull ConeClassifierLookupTag $this$toSymbol, @NotNull FirSession useSiteSession) {
        FirClassifierSymbol<?> firClassifierSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$toSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        ConeClassifierLookupTag coneClassifierLookupTag = $this$toSymbol;
        if (coneClassifierLookupTag instanceof ConeClassLikeLookupTag) {
            firClassifierSymbol = (FirClassifierSymbol<?>)LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)$this$toSymbol, useSiteSession);
        } else if (coneClassifierLookupTag instanceof ConeClassifierLookupTagWithFixedSymbol) {
            firClassifierSymbol = ((ConeClassifierLookupTagWithFixedSymbol)$this$toSymbol).getSymbol();
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unknown lookupTag type: ", (Object)Reflection.getOrCreateKotlinClass($this$toSymbol.getClass()));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firClassifierSymbol;
    }

    @Nullable
    public static final FirClassLikeSymbol<?> toSymbol(@NotNull ConeClassLikeLookupTag $this$toSymbol, @NotNull FirSession useSiteSession) {
        ConeClassLikeLookupTagImpl coneClassLikeLookupTagImpl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        if ($this$toSymbol instanceof ConeClassLookupTagWithFixedSymbol) {
            return ((ConeClassLookupTagWithFixedSymbol)$this$toSymbol).getSymbol();
        }
        FirSymbolProvider firSymbolProvider = MainSessionComponentsKt.getFirSymbolProvider(useSiteSession);
        Object object2 = $this$toSymbol instanceof ConeClassLikeLookupTagImpl ? (ConeClassLikeLookupTagImpl)$this$toSymbol : null;
        Object object3 = object = object2 == null ? null : ((ConeClassLikeLookupTagImpl)object2).getBoundSymbol();
        if (object != null) {
            Object object4 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object4;
            boolean bl3 = false;
            Object object5 = object2 = ((OneElementWeakMap)it).getKey() == useSiteSession ? object4 : null;
            if (object2 != null) {
                object4 = object2;
                bl = false;
                bl2 = false;
                it = object4;
                boolean bl4 = false;
                return (FirClassLikeSymbol)((OneElementWeakMap)it).getValue();
            }
        }
        object = firSymbolProvider.getClassLikeSymbolByFqName($this$toSymbol.getClassId());
        boolean bl = false;
        boolean bl5 = false;
        Object it = object;
        boolean bl6 = false;
        ConeClassLikeLookupTagImpl coneClassLikeLookupTagImpl2 = coneClassLikeLookupTagImpl = $this$toSymbol instanceof ConeClassLikeLookupTagImpl ? (ConeClassLikeLookupTagImpl)$this$toSymbol : null;
        if (coneClassLikeLookupTagImpl != null) {
            LookupTagUtilsKt.bindSymbolToLookupTag(coneClassLikeLookupTagImpl, useSiteSession, it);
        }
        return object;
    }

    @NotNull
    public static final FirClassLikeSymbol<?> toSymbolOrError(@NotNull ConeClassLikeLookupTag $this$toSymbolOrError, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)$this$toSymbolOrError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$toSymbolOrError, useSiteSession);
        if (firClassLikeSymbol == null) {
            String string2 = "Class symbol with classId " + $this$toSymbolOrError.getClassId() + " was not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firClassLikeSymbol;
    }

    @Nullable
    public static final FirRegularClass toFirRegularClass(@NotNull ConeClassLikeLookupTag $this$toFirRegularClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirRegularClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.getSymbolByLookupTag(MainSessionComponentsKt.getFirSymbolProvider(session2), $this$toFirRegularClass);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
        return firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
    }

    public static final void bindSymbolToLookupTag(@NotNull ConeClassLikeLookupTagImpl $this$bindSymbolToLookupTag, @NotNull FirSession session2, @Nullable FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkNotNullParameter((Object)$this$bindSymbolToLookupTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        $this$bindSymbolToLookupTag.setBoundSymbol(new OneElementWeakMap(session2, symbol2));
    }

    @Nullable
    public static final FirClassifierSymbol<?> getSymbolByLookupTag(@NotNull FirSymbolProvider $this$getSymbolByLookupTag, @NotNull ConeClassifierLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)$this$getSymbolByLookupTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        return LookupTagUtilsKt.toSymbol(lookupTag, $this$getSymbolByLookupTag.getSession());
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getSymbolByLookupTag(@NotNull FirSymbolProvider $this$getSymbolByLookupTag, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)$this$getSymbolByLookupTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        return LookupTagUtilsKt.toSymbol(lookupTag, $this$getSymbolByLookupTag.getSession());
    }
}

