/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithCfgOwner;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.UnionFunctionCallArgumentsNode;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u0013*\u00020\bH\u0002J\u0014\u0010\u001f\u001a\u00020\u0013*\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0013*\u00020\u0010H\u0002J\u0014\u0010#\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0014\u0010$\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "allGraphs", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "clusterCounter", "", "indices", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodeCounter", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "topLevelGraphs", "initializeNodes", "", "graph", "visitControlFlowGraphReference", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "collectNodes", "enterCluster", "color", "", "exitCluster", "renderEdges", "renderNodes", "Companion", "resolve"})
public final class FirControlFlowGraphRenderVisitor
extends FirVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    @NotNull
    private final Map<CFGNode<?>, Integer> indices;
    @NotNull
    private final Set<ControlFlowGraph> topLevelGraphs;
    @NotNull
    private final Set<ControlFlowGraph> allGraphs;
    @NotNull
    private static final EnumMap<EdgeKind, String> EDGE_STYLE;

    public FirControlFlowGraphRenderVisitor(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.printer = new Printer(builder2);
        boolean bl = false;
        this.indices = new LinkedHashMap();
        bl = false;
        this.topLevelGraphs = new LinkedHashSet();
        bl = false;
        this.allGraphs = new LinkedHashSet();
    }

    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = new Object[]{"digraph " + StringsKt.replace$default((String)file2.getName(), (String)".", (String)"_", (boolean)false, (int)4, null) + " {"};
        Printer printer = this.printer.println((Object[])object).pushIndent();
        object = new Object[]{"graph [nodesep=3]"};
        Printer printer2 = printer.println((Object[])object);
        object = new Object[]{"node [shape=box penwidth=2]"};
        Printer printer3 = printer2.println((Object[])object);
        object = new Object[]{"edge [penwidth=2]"};
        printer3.println((Object[])object).println(new Object[0]);
        this.visitElement(file2);
        for (ControlFlowGraph topLevelGraph : this.topLevelGraphs) {
            this.renderNodes(this.printer, topLevelGraph);
            this.renderEdges(this.printer, topLevelGraph);
            this.printer.println(new Object[0]);
        }
        object = new Object[]{"}"};
        this.printer.popIndent().println((Object[])object);
    }

    private final void collectNodes(ControlFlowGraph $this$collectNodes) {
        for (CFGNode<?> node : $this$collectNodes.getNodes()) {
            Map<CFGNode<?>, Integer> map = this.indices;
            Object object = this;
            int n = ((FirControlFlowGraphRenderVisitor)object).nodeCounter;
            ((FirControlFlowGraphRenderVisitor)object).nodeCounter = n + 1;
            object = n;
            n = 0;
            map.put(node, (Integer)object);
        }
    }

    private final void renderNodes(Printer $this$renderNodes, ControlFlowGraph graph2) {
        String color = "red";
        List sortedNodes2 = ControlFlowGraphRendererKt.access$sortedNodes(graph2);
        for (CFGNode node : sortedNodes2) {
            if (node instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = "blue";
            }
            boolean bl = false;
            List attributes = new ArrayList();
            Object[] objectArray = (Object[])attributes;
            String string2 = "label=\"" + StringsKt.replace$default((String)CFGNodeRendererKt.render(node), (String)"\"", (String)"", (boolean)false, (int)4, null) + '\"';
            boolean bl2 = false;
            objectArray.add(string2);
            if (Intrinsics.areEqual((Object)node, node.getOwner().getEnterNode()) || Intrinsics.areEqual((Object)node, node.getOwner().getExitNode())) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes, "red");
            }
            if (node.isDead()) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes, "gray");
            } else if (node instanceof UnionFunctionCallArgumentsNode) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes, "yellow");
            }
            objectArray = new Object[]{MapsKt.getValue(this.indices, (Object)node), CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", (CharSequence)" [", (CharSequence)"];", (int)0, null, null, (int)56, null)};
            $this$renderNodes.println(objectArray);
            if (!(node instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderEdges(Printer $this$renderEdges, ControlFlowGraph graph2) {
        for (CFGNode<?> node : graph2.getNodes()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            if (node.getFollowingNodes().isEmpty()) continue;
            for (EdgeKind kind : EdgeKind.values()) {
                FirControlFlowGraphRenderVisitor.renderEdges$renderEdges(node, $this$renderEdges, this, kind);
            }
            if (!(node instanceof CFGNodeWithCfgOwner)) continue;
            List<ControlFlowGraph> subNodes = ((CFGNodeWithCfgOwner)node).getSubGraphs();
            Object[] objectArray = (Object[])subNodes;
            int n = 0;
            if (!(!objectArray.isEmpty())) continue;
            objectArray = new Object[3];
            objectArray[0] = MapsKt.getValue(this.indices, node);
            objectArray[1] = " -> ";
            Iterable iterable = subNodes;
            int n2 = 2;
            Object[] objectArray2 = objectArray;
            Printer printer = $this$renderEdges;
            boolean $i$f$mapNotNull = false;
            void var9_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer n3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ControlFlowGraph it = (ControlFlowGraph)element$iv$iv;
                boolean bl2 = false;
                if (this.indices.get(it.getEnterNode()) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Integer it$iv$iv = n3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            objectArray2[n2] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
            printer.print(objectArray);
            objectArray = new Object[]{" [style=dashed]"};
            $this$renderEdges.printWithNoIndent(objectArray);
            objectArray = new Object[]{";"};
            $this$renderEdges.printlnWithNoIndent(objectArray);
        }
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.renderEdges($this$renderEdges, subGraph);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this);
    }

    @Override
    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        ControlFlowGraph controlFlowGraph;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
        FirControlFlowGraphReferenceImpl firControlFlowGraphReferenceImpl = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
        ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReferenceImpl == null ? null : firControlFlowGraphReferenceImpl.getControlFlowGraph();
        if (controlFlowGraph == null) {
            return;
        }
        ControlFlowGraph controlFlowGraph3 = controlFlowGraph;
        this.initializeNodes(controlFlowGraph3);
    }

    private final void initializeNodes(ControlFlowGraph graph2) {
        boolean bl;
        Collection collection;
        Object object;
        if (this.allGraphs.contains(graph2)) {
            return;
        }
        this.collectNodes(graph2);
        if (graph2.getOwner() == null) {
            object = this;
            collection = ((FirControlFlowGraphRenderVisitor)object).topLevelGraphs;
            bl = false;
            collection.add(graph2);
        }
        object = this;
        collection = ((FirControlFlowGraphRenderVisitor)object).allGraphs;
        bl = false;
        collection.add(graph2);
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.initializeNodes(subGraph);
        }
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        FirControlFlowGraphRenderVisitor firControlFlowGraphRenderVisitor = this;
        int n = firControlFlowGraphRenderVisitor.clusterCounter;
        firControlFlowGraphRenderVisitor.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        objectArray = new Object[]{Intrinsics.stringPlus((String)"color=", (Object)color)};
        $this$enterCluster.println(objectArray);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        Object[] objectArray = new Object[]{"}"};
        $this$exitCluster.println(objectArray);
    }

    private static final void renderNodes$fillColor(List<String> attributes, String color) {
        Collection collection = attributes;
        String string2 = "style=\"filled\"";
        boolean bl = false;
        collection.add(string2);
        collection = attributes;
        string2 = Intrinsics.stringPlus((String)"fillcolor=", (Object)color);
        bl = false;
        collection.add(string2);
    }

    private static final void renderEdges$renderEdges$renderEdgesWithoutLabel(Printer $this_renderEdges, FirControlFlowGraphRenderVisitor this$0, CFGNode<?> node, EdgeKind $kind, List<? extends CFGNode<?>> edges) {
        Object object = new Object[]{MapsKt.getValue(this$0.indices, node), " -> ", CollectionsKt.joinToString$default((Iterable)edges, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)new Function1<CFGNode<?>, CharSequence>(this$0){
            final /* synthetic */ FirControlFlowGraphRenderVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull CFGNode<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return String.valueOf(((Number)MapsKt.getValue((Map)FirControlFlowGraphRenderVisitor.access$getIndices$p(this.this$0), it)).intValue());
            }
        }, (int)24, null)};
        $this_renderEdges.print(object);
        Object[] objectArray = MapsKt.getValue((Map)EDGE_STYLE, (Object)((Object)$kind));
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Object[] objectArray2 = it;
        boolean bl4 = false;
        object = (String)(!StringsKt.isBlank((CharSequence)objectArray2) ? objectArray : null);
        if (object != null) {
            objectArray = object;
            bl = false;
            bl2 = false;
            it = objectArray;
            boolean bl5 = false;
            objectArray2 = new Object[]{Intrinsics.stringPlus((String)" ", (Object)it)};
            $this_renderEdges.printWithNoIndent(objectArray2);
        }
        object = new Object[]{";"};
        $this_renderEdges.printlnWithNoIndent(object);
    }

    /*
     * WARNING - void declaration
     */
    private static final void renderEdges$renderEdges(CFGNode<?> node, Printer $this_renderEdges, FirControlFlowGraphRenderVisitor this$0, EdgeKind kind) {
        boolean bl;
        List edges;
        Object[] it;
        block13: {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getFollowingNodes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (CFGNode)element$iv$iv;
                boolean bl2 = false;
                if (!(((Edge)MapsKt.getValue(node.getOutgoingEdges(), (Object)it)).getKind() == kind)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            edges = (List)destination$iv$iv;
            if (edges.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = edges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CFGNode it2 = (CFGNode)element$iv;
                    boolean bl3 = false;
                    element$iv$iv = node.getOutgoingEdges().get(it2);
                    if (!((element$iv$iv == null ? null : ((it = ((Edge)element$iv$iv).getLabel()) == null ? null : it.getLabel())) != null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$groupByTo$iv$iv;
            Object element$iv;
            Iterable $this$groupBy$iv = edges;
            boolean $i$f$groupBy2 = false;
            element$iv = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                EdgeLabel edgeLabel;
                CFGNode it3 = (CFGNode)element$iv$iv;
                boolean bl4 = false;
                Edge edge = node.getOutgoingEdges().get(it3);
                Boolean key$iv$iv = (edge == null ? null : ((edgeLabel = edge.getLabel()) == null ? null : edgeLabel.getLabel())) != null;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map edgeGroups = destination$iv$iv;
            List list2 = (List)edgeGroups.get(false);
            if (list2 != null) {
                List $i$f$groupBy2 = list2;
                boolean bl6 = false;
                boolean bl7 = false;
                List it4 = $i$f$groupBy2;
                boolean bl8 = false;
                FirControlFlowGraphRenderVisitor.renderEdges$renderEdges$renderEdgesWithoutLabel($this_renderEdges, this$0, node, kind, it4);
            }
            List $i$f$groupBy2 = (List)edgeGroups.get(true);
            Intrinsics.checkNotNull((Object)$i$f$groupBy2);
            for (CFGNode edge : $i$f$groupBy2) {
                Object object = new Object[]{MapsKt.getValue(this$0.indices, node), " -> ", "{", MapsKt.getValue(this$0.indices, (Object)edge), "}"};
                $this_renderEdges.print(object);
                Object object2 = MapsKt.getValue((Map)EDGE_STYLE, (Object)((Object)kind));
                boolean bl9 = false;
                boolean bl10 = false;
                it = (String)object2;
                boolean bl11 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Object[] objectArray = it;
                boolean bl12 = false;
                object = (String)(!StringsKt.isBlank((CharSequence)objectArray) ? object2 : null);
                if (object != null) {
                    object2 = object;
                    bl9 = false;
                    bl10 = false;
                    it = object2;
                    boolean bl13 = false;
                    objectArray = new Object[]{Intrinsics.stringPlus((String)" ", (Object)it)};
                    $this_renderEdges.printWithNoIndent(objectArray);
                }
                object = new Object[1];
                StringBuilder stringBuilder2 = new StringBuilder().append("[label=");
                object2 = node.getOutgoingEdges().get(edge);
                Intrinsics.checkNotNull((Object)object2);
                object[0] = stringBuilder2.append(((Edge)object2).getLabel()).append(']').toString();
                $this_renderEdges.print(object);
                object = new Object[]{";"};
                $this_renderEdges.printlnWithNoIndent(object);
            }
        } else {
            FirControlFlowGraphRenderVisitor.renderEdges$renderEdges$renderEdgesWithoutLabel($this_renderEdges, this$0, node, kind, edges);
        }
    }

    public static final /* synthetic */ Map access$getIndices$p(FirControlFlowGraphRenderVisitor $this) {
        return $this.indices;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EdgeKind.Forward), (Object)""), TuplesKt.to((Object)((Object)EdgeKind.DeadForward), (Object)"[style=dotted]"), TuplesKt.to((Object)((Object)EdgeKind.CfgForward), (Object)"[color=green]"), TuplesKt.to((Object)((Object)EdgeKind.DfgForward), (Object)"[color=red]"), TuplesKt.to((Object)((Object)EdgeKind.CfgBackward), (Object)"[color=green style=dashed]"), TuplesKt.to((Object)((Object)EdgeKind.DeadBackward), (Object)"[color=green style=dotted]")};
        EDGE_STYLE = new EnumMap(MapsKt.mapOf((Pair[])pairArray));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor$Companion;", "", "()V", "BLUE", "", "EDGE", "EDGE_STYLE", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeKind;", "kotlin.jvm.PlatformType", "RED", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

