/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.EnumIntrinsicsTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EnumIntrinsicsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformEnumTopLevelIntrinsic", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "staticMethodPredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "", "transformEnumValueOfIntrinsic", "transformEnumValuesIntrinsic", "transformFunctionAccess", "doNotIntrinsify", "backend.js"})
public final class EnumIntrinsicsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public EnumIntrinsicsTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    private final IrExpression transformEnumTopLevelIntrinsic(IrFunctionAccessExpression call2, Function1<? super IrSimpleFunction, Boolean> staticMethodPredicate) {
        IrSimpleFunction staticMethod;
        Object v2;
        Object v1;
        block5: {
            IrClass irClass2;
            IrType irType = call2.getTypeArgument(0);
            IrClass irClass3 = irClass2 = irType == null ? null : IrTypesKt.getClass(irType);
            if (irClass2 == null) {
                return call2;
            }
            IrClass irClass4 = irClass2;
            if (!IrUtilsKt.isEnumClass(irClass4)) {
                return call2;
            }
            IrDeclarationContainer $this$findDeclaration$iv = irClass4;
            boolean $i$f$findDeclaration = false;
            Iterable iterable = $this$findDeclaration$iv.getDeclarations();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IrDeclaration it$iv = (IrDeclaration)t;
                boolean bl3 = false;
                if (!(it$iv instanceof IrSimpleFunction && (Boolean)staticMethodPredicate.invoke((Object)it$iv) != false)) continue;
                v1 = t;
                break block5;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrSimpleFunction)) {
            v2 = null;
        }
        if ((staticMethod = (IrSimpleFunction)((IrDeclaration)v2)) == null || !IrFunctionKt.isStaticMethodOfClass(staticMethod)) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Enum class should have static method for ", (Object)((IrFunctionSymbol)call2.getSymbol()).getOwner().getName()));
        }
        return IrUtilsKt.irCall$default(call2, staticMethod.getSymbol(), false, false, null, null, 60, null);
    }

    private final IrExpression transformEnumValueOfIntrinsic(IrFunctionAccessExpression call2) {
        return this.transformEnumTopLevelIntrinsic(call2, (Function1<? super IrSimpleFunction, Boolean>)((Function1)transformEnumValueOfIntrinsic.1.INSTANCE));
    }

    private final IrExpression transformEnumValuesIntrinsic(IrFunctionAccessExpression call2) {
        return this.transformEnumTopLevelIntrinsic(call2, (Function1<? super IrSimpleFunction, Boolean>)((Function1)transformEnumValuesIntrinsic.1.INSTANCE));
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)call2.getSymbol();
        return Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.context.getIntrinsics().getEnumValueOfIntrinsic()) ? this.transformEnumValueOfIntrinsic(call2) : (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.context.getIntrinsics().getEnumValuesIntrinsic()) ? this.transformEnumValuesIntrinsic(call2) : (IrExpression)call2);
    }
}

