/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Lambda;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Lambda;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFields", "()Ljava/util/List;", "invokeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "typeArguments", "getTypeArguments", "getIrFunctionByIrCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "toString", "", "ir.interpreter"})
public final class Lambda
implements State {
    @NotNull
    private final IrFunction irFunction;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> fields;
    @NotNull
    private final List<Variable> typeArguments;
    @NotNull
    private final IrFunctionSymbol invokeSymbol;

    /*
     * WARNING - void declaration
     */
    public Lambda(@NotNull IrFunction irFunction2, @NotNull IrClass irClass2) {
        Object var12_13;
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.irFunction = irFunction2;
        this.irClass = irClass2;
        boolean bl = false;
        this.fields = new ArrayList();
        bl = false;
        this.typeArguments = new ArrayList();
        Iterable iterable = this.getIrClass().getDeclarations();
        Lambda lambda = this;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)"invoke")) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object $this$cast$iv = var12_13 = single$iv;
        boolean $i$f$cast = false;
        Object v0 = $this$cast$iv;
        if (v0 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        }
        lambda.invokeSymbol = UtilsKt.getLastOverridden(v0).getSymbol();
    }

    @NotNull
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public List<Variable> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return Intrinsics.areEqual((Object)this.invokeSymbol, (Object)expression2.getSymbol()) ? this.irFunction : null;
    }

    @NotNull
    public String toString() {
        IrType irType;
        Object object = this.irFunction.getDispatchReceiverParameter();
        IrType irType2 = irType = object == null ? null : ((IrValueDeclaration)object).getType();
        IrType irType3 = irType == null ? ((object = this.irFunction.getExtensionReceiverParameter()) == null ? null : ((IrValueDeclaration)object).getType()) : irType;
        String receiver = irType3 == null ? null : RenderIrElementKt.render(irType3);
        String arguments2 = CollectionsKt.joinToString$default((Iterable)this.irFunction.getValueParameters(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)toString.arguments.1.INSTANCE, (int)25, null);
        String returnType2 = RenderIrElementKt.render(this.irFunction.getReturnType());
        object = arguments2 + " -> " + returnType2;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        return receiver != null ? receiver + '.' + (String)it : it;
    }

    @Override
    public void addTypeArguments(@NotNull List<Variable> typeArguments2) {
        State.DefaultImpls.addTypeArguments(this, typeArguments2);
    }

    @Override
    @Nullable
    public State getState(@NotNull IrSymbol symbol2) {
        return State.DefaultImpls.getState(this, symbol2);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        State.DefaultImpls.setField(this, newVar);
    }
}

