/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J.\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;)V", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "setTypeTranslator", "(Lorg/jetbrains/kotlin/ir/util/TypeTranslator;)V", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "generateConstantOrAnnotationValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateConstantValueAsExpression", "getArrayElementType", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
public final class ConstantValueGenerator {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    public TypeTranslator typeTranslator;

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final TypeTranslator getTypeTranslator() {
        TypeTranslator typeTranslator = this.typeTranslator;
        if (typeTranslator != null) {
            return typeTranslator;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typeTranslator");
        throw null;
    }

    public final void setTypeTranslator(@NotNull TypeTranslator typeTranslator) {
        Intrinsics.checkNotNullParameter((Object)typeTranslator, (String)"<set-?>");
        this.typeTranslator = typeTranslator;
    }

    private final IrType toIrType(KotlinType $this$toIrType) {
        return this.getTypeTranslator().translateType($this$toIrType);
    }

    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @Nullable KotlinType varargElementType) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        IrExpression irExpression = this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, varargElementType);
        Intrinsics.checkNotNull((Object)irExpression);
        return irExpression;
    }

    public static /* synthetic */ IrExpression generateConstantValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateConstantValueAsExpression(n, n2, constantValue, kotlinType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateConstantOrAnnotationValueAsExpression(int startOffset, int endOffset, ConstantValue<?> constantValue, KotlinType varargElementType) {
        IrExpression irExpression;
        KotlinType constantKtType = constantValue.getType(this.moduleDescriptor);
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            List list2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = varargElementType;
            KotlinType arrayElementType = object == null ? this.getArrayElementType(constantKtType) : object;
            object = (Iterable)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            boolean $i$f$mapNotNull = false;
            void var11_22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrExpression irExpression2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue it = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                if (this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, it, null) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                IrExpression it$iv$iv = irExpression2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = list2 = (List)destination$iv$iv;
            IrType irType3 = irType;
            IrType irType4 = irType2;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, irType4, irType3, list3);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor $this$mapNotNull$iv = constantKtType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if ($this$mapNotNull$iv == null) {
                throw new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType));
            }
            ClassifierDescriptor enumEntryDescriptor = $this$mapNotNull$iv;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor"));
            }
            if (!DescriptorUtils.isEnumEntry(enumEntryDescriptor)) {
                return null;
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue());
        } else if (constantValue2 instanceof KClassValue) {
            IrClassReferenceImpl irClassReferenceImpl;
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            if (KotlinTypeKt.isError(classifierKtType)) {
                irClassReferenceImpl = null;
            } else {
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2 = classifierKtType.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor2 == null) {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected KClassValue: ", (Object)classifierKtType));
                }
                ClassifierDescriptor classifierDescriptor3 = classifierDescriptor = classifierDescriptor2;
                irClassReferenceImpl = new IrClassReferenceImpl(startOffset, endOffset, this.toIrType(constantValue.getType(this.moduleDescriptor)), IrUtilsKt.referenceClassifier(this.symbolTable, classifierDescriptor3), this.toIrType(classifierKtType));
            }
            irExpression = irClassReferenceImpl;
        } else if (constantValue2 instanceof ErrorValue) {
            irExpression = null;
        } else {
            String string2 = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    @Nullable
    public final IrConstructorCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor) {
        int n;
        PsiElement psiElement;
        boolean bl;
        int n2;
        PsiElement psiElement2;
        PsiElement psiElement3;
        PsiElement psi;
        ClassConstructorDescriptor classConstructorDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"annotationDescriptor");
        KotlinType annotationType = annotationDescriptor.getType();
        ClassifierDescriptor annotationClassDescriptor = annotationType.getConstructor().getDeclarationDescriptor();
        if (!(annotationClassDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        if (annotationClassDescriptor instanceof NotFoundClasses.MockClassDescriptor) {
            return null;
        }
        boolean bl2 = DescriptorUtils.isAnnotationClass(annotationClassDescriptor);
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 = false;
            String $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 = Intrinsics.stringPlus((String)"Annotation class expected: ", (Object)annotationClassDescriptor);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22));
        }
        ClassConstructorDescriptor $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 = ((ClassDescriptor)annotationClassDescriptor).getUnsubstitutedPrimaryConstructor();
        if ($i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 == null) {
            Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)annotationClassDescriptor).getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"annotationClassDescriptor.constructors");
            object = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (object == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"No constructor for annotation class ", (Object)annotationClassDescriptor));
            }
            classConstructorDescriptor2 = object;
        } else {
            classConstructorDescriptor2 = $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22;
        }
        ClassConstructorDescriptor primaryConstructorDescriptor = classConstructorDescriptor = classConstructorDescriptor2;
        IrConstructorSymbol primaryConstructorSymbol = this.symbolTable.referenceConstructor(primaryConstructorDescriptor);
        SourceElement $this$safeAs$iv = annotationDescriptor.getSource();
        boolean $i$f$safeAs22 = false;
        SourceElement sourceElement = $this$safeAs$iv;
        if (!(sourceElement instanceof PsiSourceElement)) {
            sourceElement = null;
        }
        if (($i$f$safeAs22 = (psi = (object = (PsiSourceElement)sourceElement) == null ? null : object.getPsi())) == null) {
            psiElement3 = null;
        } else {
            psiElement2 = $i$f$safeAs22;
            n2 = 0;
            bl = false;
            PsiElement it = psiElement2;
            boolean bl4 = false;
            psiElement3 = !it.getContainingFile().getFileType().isBinary() ? psiElement2 : null;
        }
        $this$safeAs$iv = psiElement3;
        int startOffset = $this$safeAs$iv == null ? -1 : ($i$f$safeAs22 = PsiUtilsKt.getStartOffset((PsiElement)((Object)$this$safeAs$iv)));
        psiElement2 = psi;
        if (psiElement2 == null) {
            psiElement = null;
        } else {
            PsiElement psiElement4 = psiElement2;
            bl = false;
            boolean it = false;
            PsiElement it2 = psiElement4;
            boolean bl5 = false;
            psiElement = !it2.getContainingFile().getFileType().isBinary() ? psiElement4 : null;
        }
        PsiElement $i$f$safeAs22 = psiElement;
        int endOffset = $i$f$safeAs22 == null ? -1 : (n = PsiUtilsKt.getEndOffset($i$f$safeAs22));
        IrType irType = this.toIrType(annotationType);
        n2 = primaryConstructorDescriptor.getValueParameters().size();
        IrConstructorCallImpl irCall = new IrConstructorCallImpl(startOffset, endOffset, irType, primaryConstructorSymbol, 0, 0, n2, null, 128, null);
        for (ValueParameterDescriptor valueParameter : primaryConstructorDescriptor.getValueParameters()) {
            ConstantValue<?> argumentValue;
            IrExpression irArgument;
            int argumentIndex = valueParameter.getIndex();
            ConstantValue<?> it2 = annotationDescriptor.getAllValueArguments().get(valueParameter.getName());
            if (it2 == null || (irArgument = this.generateConstantOrAnnotationValueAsExpression(-1, -1, argumentValue = it2, valueParameter.getVarargElementType())) == null) continue;
            irCall.putValueArgument(argumentIndex, irArgument);
        }
        return irCall;
    }

    private final KotlinType getArrayElementType(KotlinType $this$getArrayElementType) {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns($this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(this)");
        return kotlinType;
    }
}

