/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/SuspendTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "()V", "conversionDefinitelyNotNeeded", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedParameterType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "conversionIsNeededAfterSubtypingCheck", "conversionIsNeededBeforeSubtypingCheck", "convertParameterType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "resolution"})
public final class SuspendTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final SuspendTypeConversions INSTANCE = new SuspendTypeConversions();

    private SuspendTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull UnwrappedType expectedParameterType) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        if (!(argument instanceof SimpleKotlinCallArgument)) {
            return true;
        }
        UnwrappedType argumentType = ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver());
        if (FunctionTypesKt.isSuspendFunctionType(argumentType)) {
            return true;
        }
        return !FunctionTypesKt.isSuspendFunctionType(expectedParameterType);
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UnwrappedType convertParameterType(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull ParameterDescriptor parameter, @NotNull UnwrappedType expectedParameterType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedParameterType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedParameterType);
        Annotations annotations2 = expectedParameterType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = candidate2.getCallComponents().getBuiltIns();
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
            KotlinType kotlinType3 = kotlinType2;
            collection.add(kotlinType3);
        }
        collection = (List)destination$iv$iv;
        SimpleType nonSuspendParameterType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(expectedParameterType), false);
        candidate2.getResolvedCall().registerArgumentWithSuspendConversion(argument, nonSuspendParameterType);
        ResolutionCandidateKt.markCandidateForCompatibilityResolve(candidate2);
        return nonSuspendParameterType;
    }
}

