/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\b\u00a8\u0006\t"}, d2={"createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class SynthesizedInvokesKt {
    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkNotNullParameter(functions2, (String)"functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            CallableDescriptor callableDescriptor;
            FunctionDescriptor functionDescriptor2;
            if (!Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)OperatorNameConventions.INVOKE) || functionDescriptor.getValueParameters().isEmpty()) continue;
            ClassId containerClassId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)functionDescriptor.getContainingDeclaration()));
            if (containerClassId != null && FunctionTypesKt.isBuiltinFunctionClass(containerClassId)) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                Object object = functionDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(object, (String)"invoke.overriddenDescriptors");
                callableDescriptor = (FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object));
                if (callableDescriptor == null) {
                    object = "No single overridden invoke for " + functionDescriptor + ": " + functionDescriptor.getOverriddenDescriptors();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                CallableDescriptor invokeDeclaration = callableDescriptor;
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver((FunctionDescriptor)invokeDeclaration);
                FunctionDescriptor functionDescriptor22 = synthesizedSuperFun.copy(functionDescriptor.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
                Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor22, (String)"synthesizedSuperFun.copy(\n                invoke.containingDeclaration,\n                synthesizedSuperFun.modality,\n                synthesizedSuperFun.visibility,\n                CallableMemberDescriptor.Kind.FAKE_OVERRIDE,\n                /* copyOverrides = */ false\n            )");
                FunctionDescriptor fakeOverride = functionDescriptor22;
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                functionDescriptor2 = fakeOverride;
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            callableDescriptor = functionDescriptor.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)callableDescriptor);
            FunctionDescriptor functionDescriptor3 = synthesized.substitute(TypeSubstitutor.create(callableDescriptor.getType()));
            if (functionDescriptor3 == null) continue;
            result2.add(functionDescriptor3);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        Collection<ValueParameterDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder = descriptor2.getOriginal().newCopyBuilder();
        boolean bl = false;
        boolean bl2 = false;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u2d1 = copyBuilder;
        boolean bl3 = false;
        CallableDescriptor callableDescriptor = descriptor2.getOriginal();
        Iterable<ValueParameterDescriptor> iterable = descriptor2.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"descriptor.original.valueParameters");
        $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u2d1.setExtensionReceiverParameter(DescriptorFactory.createExtensionReceiverParameterForCallable(callableDescriptor, ((ValueParameterDescriptor)CollectionsKt.first(iterable)).getType(), Annotations.Companion.getEMPTY()));
        iterable = descriptor2.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"descriptor.original.valueParameters");
        iterable = CollectionsKt.drop((Iterable)iterable, (int)1);
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder2 = $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u2d1;
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Object object = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.original");
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)object;
            object = Name.identifier(Intrinsics.stringPlus((String)"p", (Object)(p.getIndex() + 1)));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"p${p.index + 1}\")");
            ValueParameterDescriptor valueParameterDescriptor2 = p.copy(callableDescriptor2, (Name)object, p.getIndex() - 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        copyBuilder2.setValueParameters((List<ValueParameterDescriptor>)collection);
        FunctionDescriptor functionDescriptor = copyBuilder.build();
        Intrinsics.checkNotNull((Object)functionDescriptor);
        return functionDescriptor;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE)) return false;
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor2;
        while (!var1_2.getKind().isReal()) {
            Collection<? extends FunctionDescriptor> collection = var1_2.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"real.overriddenDescriptors");
            declarationDescriptor = (FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        }
        if (var1_2.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        declarationDescriptor = var1_2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"real.containingDeclaration");
        if (FunctionTypesKt.getFunctionalClassKind(declarationDescriptor) == null) return false;
        return true;
    }
}

