/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSingleAbstractMember", "abstractMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "funInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$filterIsInstanceTo$iv$iv;
        Object reportOn;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration2).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember : abstractMembers) {
            Object object;
            if (!(abstractMember instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual((Object)((PropertyDescriptor)abstractMember).getContainingDeclaration(), (Object)descriptor2);
            if (reportOnProperty) {
                KtProperty ktProperty;
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember).getSource();
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"abstractMember.source");
                Object object2 = KotlinSourceElementKt.getPsi(sourceElement);
                KtProperty ktProperty2 = ktProperty = object2 instanceof KtProperty ? (KtProperty)object2 : null;
                object = ktProperty == null ? funKeyword : ((object2 = ktProperty.getValOrVarKeyword()) == null ? funKeyword : object2);
            } else {
                object = funKeyword;
            }
            PsiElement psiElement2 = object;
            reportOn = psiElement2;
            context2.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FunctionDescriptor abstractMember = (FunctionDescriptor)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (abstractMember == null) {
            context2.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember(abstractMember, funKeyword, context2);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context2) {
        Object reportOn;
        KtNamedFunction ktFunction;
        Object object = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abstractMember.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi((SourceElement)object);
        KtNamedFunction ktNamedFunction = ktFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (!(!abstractMember.isSuspend() || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces) && context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmIrEnabledByDefault))) {
            KtModifierList ktModifierList;
            PsiElement psiElement2 = ktFunction;
            KtModifierList ktModifierList2 = ktModifierList = psiElement2 == null ? null : psiElement2.getModifierList();
            object = ktModifierList == null ? funInterfaceKeyword : ((psiElement2 = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null ? funInterfaceKeyword : psiElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ktFunction?.modifierList?.getModifier(KtTokens.SUSPEND_KEYWORD) ?: funInterfaceKeyword");
            reportOn = object;
            context2.getTrace().report(Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on((PsiElement)reportOn));
            return;
        }
        reportOn = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(reportOn, (String)"abstractMember.typeParameters");
        reportOn = (Collection)reportOn;
        boolean bl = false;
        if (!reportOn.isEmpty()) {
            PsiElement psiElement3;
            KtTypeParameterList ktTypeParameterList;
            KtNamedFunction ktNamedFunction2 = ktFunction;
            KtTypeParameterList ktTypeParameterList2 = ktTypeParameterList = ktNamedFunction2 == null ? null : ktNamedFunction2.getTypeParameterList();
            PsiElement psiElement4 = ktTypeParameterList == null ? ((ktNamedFunction2 = ktFunction) == null ? funInterfaceKeyword : ((psiElement3 = ktNamedFunction2.getFunKeyword()) == null ? funInterfaceKeyword : psiElement3)) : (PsiElement)ktTypeParameterList;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"ktFunction?.typeParameterList ?: ktFunction?.funKeyword ?: funInterfaceKeyword");
            reportOn = psiElement4;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on((PsiElement)reportOn));
            return;
        }
        for (ValueParameterDescriptor parameter : abstractMember.getValueParameters()) {
            PsiElement psiElement5;
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            Object object2 = parameter.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameter.source");
            PsiElement psiElement6 = KotlinSourceElementKt.getPsi((SourceElement)object2);
            PsiElement reportOn2 = psiElement6 == null ? ((object2 = ktFunction) == null ? funInterfaceKeyword : ((psiElement5 = ((KtNamedFunction)object2).getFunKeyword()) == null ? funInterfaceKeyword : psiElement5)) : psiElement6;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn2));
            return;
        }
    }
}

