/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "CONCURRENT_HASH_MAP_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class InconsistentOperatorFromJavaCallChecker
implements CallChecker {
    @NotNull
    public static final InconsistentOperatorFromJavaCallChecker INSTANCE = new InconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final FqName CONCURRENT_HASH_MAP_FQ_NAME = new FqName("java.util.concurrent.ConcurrentHashMap");

    private InconsistentOperatorFromJavaCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        if (!Intrinsics.areEqual((Object)candidateDescriptor.getName(), (Object)OperatorNameConventions.CONTAINS)) {
            return;
        }
        Object object = candidateDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"candidateDescriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(object);
        if (!Intrinsics.areEqual(valueParameterDescriptor == null ? null : ((object = valueParameterDescriptor.getType()) == null ? null : Boolean.valueOf(TypeUtilsKt.isAnyOrNullableAny((KotlinType)object))), (Object)true)) {
            return;
        }
        if (!(resolvedCall2.getCall().getCallElement() instanceof KtBinaryExpression) || !resolvedCall2.getStatus().possibleTransformToSuccess()) {
            return;
        }
        for (CallableDescriptor callableDescriptor : DescriptorUtilsKt.overriddenTreeUniqueAsSequence(candidateDescriptor, false)) {
            ClassDescriptor containingClass;
            DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor2 == null || !Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull(containingClass = classDescriptor2), (Object)CONCURRENT_HASH_MAP_FQ_NAME)) continue;
            DiagnosticFactory0<PsiElement> diagnosticFactory = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitConcurrentHashMapContains) ? ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR_ERROR : ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR;
            context2.getTrace().report(diagnosticFactory.on(reportOn));
            break;
        }
    }
}

