/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/NullableFieldsDeclarationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformGetter", "", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
public final class NullableFieldsDeclarationLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext backendContext;

    public NullableFieldsDeclarationLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        IrProperty irProperty2;
        IrPropertySymbol irPropertySymbol;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IrDeclaration irDeclaration2 = declaration2;
        if (irDeclaration2 instanceof IrProperty) {
            if (LateinitLoweringKt.access$isRealLateinit((IrProperty)declaration2)) {
                IrProperty irProperty3 = (IrProperty)declaration2;
                IrField irField = ((IrProperty)declaration2).getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                irProperty3.setBackingField(LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, irField));
            }
        } else if (irDeclaration2 instanceof IrSimpleFunction && (irPropertySymbol = ((IrSimpleFunction)declaration2).getCorrespondingPropertySymbol()) != null && (irProperty2 = (IrProperty)irPropertySymbol.getOwner()) != null) {
            IrProperty irProperty4 = irProperty2;
            boolean bl = false;
            boolean bl2 = false;
            IrProperty property2 = irProperty4;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)declaration2, (Object)property2.getGetter()) && LateinitLoweringKt.access$isRealLateinit(property2)) {
                CommonBackendContext commonBackendContext = this.getBackendContext();
                IrField irField = property2.getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                this.transformGetter(LateinitLoweringKt.access$buildOrGetNullableField(commonBackendContext, irField), (IrFunction)declaration2);
            }
        }
        return null;
    }

    private final void transformGetter(IrField backingField2, IrFunction getter2) {
        IrType type2 = backingField2.getType();
        boolean bl = !IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "'lateinit' modifier is not allowed on primitive types";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        int startOffset = getter2.getStartOffset();
        int endOffset = getter2.getEndOffset();
        getter2.setBody(this.backendContext.getIrFactory().createBlockBody(startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this, getter2, startOffset, endOffset, backingField2){
            final /* synthetic */ NullableFieldsDeclarationLowering this$0;
            final /* synthetic */ IrFunction $getter;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrField $backingField;
            {
                this.this$0 = $receiver;
                this.$getter = $getter;
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
                this.$backingField = $backingField;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                Object object;
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), this.$getter.getSymbol(), this.$startOffset, this.$endOffset);
                IrFunction irFunction2 = this.$getter;
                IrField irField = this.$backingField;
                NullableFieldsDeclarationLowering nullableFieldsDeclarationLowering = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                DeclarationIrBuilder $this$invoke_u24lambda_u2d1 = declarationIrBuilder;
                boolean bl3 = false;
                Scope scope2 = $this$invoke_u24lambda_u2d1.getScope();
                IrBuilderWithScope irBuilderWithScope = $this$invoke_u24lambda_u2d1;
                IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
                if (irValueParameter == null) {
                    irGetValueImpl = null;
                } else {
                    void it;
                    object = irValueParameter;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    IrValueParameter irValueParameter2 = object;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope3 = scope2;
                    boolean bl6 = false;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$invoke_u24lambda_u2d1, (IrValueDeclaration)it);
                    scope2 = scope3;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                }
                IrVariable resultVar = IrBuildersKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, irField), null, false, null, null, 30, null);
                resultVar.setParent(irFunction2);
                $this$createBlockBody.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope3 = $this$invoke_u24lambda_u2d1;
                IrType irType = $this$invoke_u24lambda_u2d1.getContext().getIrBuiltIns().getNothingType();
                IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$invoke_u24lambda_u2d1, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u2d1, resultVar), ExpressionHelpersKt.irNull($this$invoke_u24lambda_u2d1));
                IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$invoke_u24lambda_u2d1, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u2d1, resultVar));
                CommonBackendContext commonBackendContext = nullableFieldsDeclarationLowering.getBackendContext();
                IrBuilderWithScope irBuilderWithScope4 = $this$invoke_u24lambda_u2d1;
                object = irField.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"backingField.name.asString()");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope4, (String)object), null, 16, null);
                $this$createBlockBody.getStatements().add(throwIfNull);
            }
        })));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }
}

