/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "isSafeToInline", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "AccessorInliner", "ir.backend.common"})
public final class PropertyAccessorInlineLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public PropertyAccessorInlineLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    private final boolean isSafeToInline(IrProperty $this$isSafeToInline) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel($this$isSafeToInline) || $this$isSafeToInline.getModality() == Modality.FINAL || Intrinsics.areEqual((Object)$this$isSafeToInline.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) || ((IrClass)$this$isSafeToInline.getParent()).getModality() == Modality.FINAL;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new AccessorInliner());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering$AccessorInliner;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;)V", "unitType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isSimpleGetter", "", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isSimpleSetter", "tryInlineSimpleGetter", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryInlineSimpleSetter", "visitCall", "expression", "ir.backend.common"})
    private final class AccessorInliner
    extends IrElementTransformerVoid {
        @NotNull
        private final IrType unitType;

        public AccessorInliner() {
            Intrinsics.checkNotNullParameter((Object)PropertyAccessorInlineLowering.this, (String)"this$0");
            this.unitType = PropertyAccessorInlineLowering.this.context.getIrBuiltIns().getUnitType();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrProperty irProperty2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            IrPropertySymbol irPropertySymbol = callee.getCorrespondingPropertySymbol();
            IrProperty irProperty3 = irProperty2 = irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
            if (irProperty2 == null) {
                return expression2;
            }
            IrProperty property2 = irProperty2;
            if (!PropertyAccessorInlineLowering.this.isSafeToInline(property2)) {
                return expression2;
            }
            IrDeclarationParent parent2 = property2.getParent();
            if (parent2 instanceof IrClass) {
                if (((IrClass)parent2).isExpect() || property2.isExpect()) {
                    return expression2;
                }
                if (((IrClass)parent2).getParent() instanceof IrExternalPackageFragment) {
                    return expression2;
                }
                if (((IrClass)parent2).isInline()) {
                    return expression2;
                }
            }
            if (IrUtilsKt.isEffectivelyExternal(property2)) {
                return expression2;
            }
            IrElementBase irElementBase = property2.getBackingField();
            if (irElementBase == null) {
                return expression2;
            }
            IrField backingField2 = irElementBase;
            if (property2.isConst()) {
                IrGeneratorWithScope p1;
                void p02;
                IrExpressionBody irExpressionBody = backingField2.getInitializer();
                if (irExpressionBody == null) {
                    String string2 = "Constant property has to have a backing field with initializer";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                IrExpressionBody initializer2 = irExpressionBody;
                IrElement $this$deepCopyWithSymbols_u24default$iv = initializer2.getExpression();
                IrDeclarationParent initialParent$iv = null;
                boolean $i$f$deepCopyWithSymbols = false;
                DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                TypeRemapper typeRemapper = typeRemapper$iv;
                SymbolRemapper symbolRemapper = symbolRemapper$iv;
                IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p02, (TypeRemapper)((Object)p1));
                IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                IrExpression constExpression = (IrExpression)((IrElement)((IrExpression)irElement2));
                IrExpression receiver = expression2.getDispatchReceiver();
                if (receiver != null && !IrUtilsKt.isPure$default(receiver, true, false, 2, null)) {
                    void this_$iv$iv$iv;
                    void startOffset$iv$iv;
                    void $this$irBlock$iv$iv;
                    DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(PropertyAccessorInlineLowering.this.context, expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                    IrGeneratorWithScope $this$irBlock_u24default$iv = builder2;
                    IrStatementOrigin origin$iv = null;
                    IrType resultType$iv = ((IrExpression)expression2).getType();
                    boolean $i$f$irBlock = false;
                    p1 = $this$irBlock_u24default$iv;
                    int p02 = ((IrExpression)expression2).getStartOffset();
                    int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
                    boolean $i$f$irBlock2 = false;
                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                    boolean $i$f$block = false;
                    void $this$visitCall_u24lambda_u2d0 = this_$iv$iv$iv;
                    boolean bl = false;
                    $this$visitCall_u24lambda_u2d0.unaryPlus(receiver);
                    $this$visitCall_u24lambda_u2d0.unaryPlus(constExpression);
                    return this_$iv$iv$iv.doBuild();
                }
                return constExpression;
            }
            if (property2.getGetter() == callee) {
                irElementBase = this.tryInlineSimpleGetter(expression2, callee, backingField2);
                return irElementBase == null ? (IrExpression)expression2 : irElementBase;
            }
            if (property2.getSetter() == callee) {
                irElementBase = this.tryInlineSimpleSetter(expression2, callee, backingField2);
                return irElementBase == null ? (IrExpression)expression2 : irElementBase;
            }
            return expression2;
        }

        private final IrExpression tryInlineSimpleGetter(IrCall call2, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleGetter(callee, backingField2)) {
                return null;
            }
            DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(PropertyAccessorInlineLowering.this.context, call2.getSymbol(), call2.getStartOffset(), call2.getEndOffset());
            IrCall irCall = call2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$tryInlineSimpleGetter_u24lambda_u2d1 = irCall;
            boolean bl3 = false;
            IrGetFieldImpl getField = new IrGetFieldImpl($this$tryInlineSimpleGetter_u24lambda_u2d1.getStartOffset(), $this$tryInlineSimpleGetter_u24lambda_u2d1.getEndOffset(), backingField2.getSymbol(), backingField2.getType(), call2.getDispatchReceiver(), $this$tryInlineSimpleGetter_u24lambda_u2d1.getOrigin(), null, 64, null);
            return !Intrinsics.areEqual((Object)backingField2.getType(), (Object)call2.getType()) ? (IrExpression)ExpressionHelpersKt.irImplicitCast(builder2, getField, call2.getType()) : (IrExpression)getField;
        }

        private final boolean isSimpleGetter(IrSimpleFunction callee, IrField backingField2) {
            IrGetField irGetField;
            IrElementBase irElementBase;
            IrStatementContainer irStatementContainer;
            IrElement irElement = callee.getBody();
            if (irElement == null) {
                irStatementContainer = null;
            } else {
                irElementBase = irElement;
                boolean bl = false;
                boolean bl2 = false;
                IrBody it = irElementBase;
                boolean bl3 = false;
                irStatementContainer = (IrBlockBody)it;
            }
            IrStatementContainer irStatementContainer2 = irStatementContainer;
            if (irStatementContainer2 == null) {
                return false;
            }
            IrStatementContainer body2 = irStatementContainer2;
            irElement = (IrStatement)CollectionsKt.singleOrNull(body2.getStatements());
            if (irElement == null) {
                return false;
            }
            IrElement stmt = irElement;
            IrElementBase irElementBase2 = irElementBase = stmt instanceof IrReturn ? (IrReturn)stmt : null;
            if (irElementBase == null) {
                return false;
            }
            IrElementBase returnStmt = irElementBase;
            IrExpression irExpression = ((IrReturn)returnStmt).getValue();
            IrGetField irGetField2 = irGetField = irExpression instanceof IrGetField ? (IrGetField)irExpression : null;
            if (irGetField == null) {
                return false;
            }
            IrGetField getFieldStmt = irGetField;
            if (getFieldStmt.getSymbol() != backingField2.getSymbol()) {
                return false;
            }
            IrExpression receiver = getFieldStmt.getReceiver();
            if (receiver == null) {
                boolean bl = callee.getDispatchReceiverParameter() == null;
                boolean bl4 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }

        private final IrExpression tryInlineSimpleSetter(IrCall call2, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleSetter(callee, backingField2)) {
                return null;
            }
            IrCall irCall = call2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$tryInlineSimpleSetter_u24lambda_u2d3 = irCall;
            boolean bl3 = false;
            IrExpression irExpression = $this$tryInlineSimpleSetter_u24lambda_u2d3.getValueArgument(0);
            if (irExpression == null) {
                String string2 = "Setter should have a value argument";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            IrExpression value2 = irExpression;
            return new IrSetFieldImpl($this$tryInlineSimpleSetter_u24lambda_u2d3.getStartOffset(), $this$tryInlineSimpleSetter_u24lambda_u2d3.getEndOffset(), backingField2.getSymbol(), call2.getDispatchReceiver(), value2, this.unitType, $this$tryInlineSimpleSetter_u24lambda_u2d3.getOrigin(), null, 128, null);
        }

        private final boolean isSimpleSetter(IrSimpleFunction callee, IrField backingField2) {
            IrGetValue irGetValue;
            IrElementBase irElementBase;
            IrStatementContainer irStatementContainer;
            IrElement irElement = callee.getBody();
            if (irElement == null) {
                irStatementContainer = null;
            } else {
                irElementBase = irElement;
                boolean bl = false;
                boolean bl2 = false;
                IrBody it = irElementBase;
                boolean bl3 = false;
                irStatementContainer = (IrBlockBody)it;
            }
            IrStatementContainer irStatementContainer2 = irStatementContainer;
            if (irStatementContainer2 == null) {
                return false;
            }
            IrStatementContainer body2 = irStatementContainer2;
            irElement = (IrStatement)CollectionsKt.singleOrNull(body2.getStatements());
            if (irElement == null) {
                return false;
            }
            IrElement stmt = irElement;
            IrElementBase irElementBase2 = irElementBase = stmt instanceof IrSetField ? (IrSetField)stmt : null;
            if (irElementBase == null) {
                return false;
            }
            IrElementBase setFieldStmt = irElementBase;
            if (((IrFieldAccessExpression)setFieldStmt).getSymbol() != backingField2.getSymbol()) {
                return false;
            }
            IrExpression irExpression = ((IrSetField)setFieldStmt).getValue();
            IrGetValue irGetValue2 = irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            if (irGetValue == null) {
                return false;
            }
            IrGetValue setValue = irGetValue;
            IrValueParameterSymbol valueSymbol = ((IrValueParameter)CollectionsKt.single(callee.getValueParameters())).getSymbol();
            if (setValue.getSymbol() != valueSymbol) {
                return false;
            }
            IrExpression receiver = ((IrFieldAccessExpression)setFieldStmt).getReceiver();
            if (receiver == null) {
                boolean bl = callee.getDispatchReceiverParameter() == null;
                boolean bl4 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }
    }
}

