/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J!\u0010#\u001a\u0002H'\"\u0004\b\u0000\u0010'2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0(H\u0016\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,J\b\u0010-\u001a\u00020.H\u0014J\u0016\u0010-\u001a\u00020.2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u000eJ\b\u00102\u001a\u000203H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/NondeterministicJumpInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstructionImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/JumpInstruction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "targetLabels", "", "Lorg/jetbrains/kotlin/cfg/Label;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "inputValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "_next", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "_resolvedTargets", "", "inputValues", "getInputValues", "()Ljava/util/List;", "value", "next", "getNext", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "setNext", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;)V", "nextInstructions", "", "getNextInstructions", "()Ljava/util/Collection;", "resolvedTargets", "", "getResolvedTargets", "()Ljava/util/Map;", "getTargetLabels", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "copy", "newTargetLabels", "", "createCopy", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionImpl;", "setResolvedTarget", "label", "resolvedTarget", "toString", "", "frontend"})
public final class NondeterministicJumpInstruction
extends KtElementInstructionImpl
implements JumpInstruction {
    @Nullable
    private final PseudoValue inputValue;
    @Nullable
    private Instruction _next;
    @NotNull
    private final Map<Label, Instruction> _resolvedTargets;
    @NotNull
    private final List<Label> targetLabels;

    public NondeterministicJumpInstruction(@NotNull KtElement element, @NotNull List<? extends Label> targetLabels, @NotNull BlockScope blockScope, @Nullable PseudoValue inputValue) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(targetLabels, (String)"targetLabels");
        Intrinsics.checkNotNullParameter((Object)blockScope, (String)"blockScope");
        super(element, blockScope);
        this.inputValue = inputValue;
        boolean bl = false;
        this._resolvedTargets = new LinkedHashMap();
        this.targetLabels = new ArrayList(targetLabels);
    }

    @NotNull
    public final List<Label> getTargetLabels() {
        return this.targetLabels;
    }

    private final Map<Label, Instruction> getResolvedTargets() {
        return this._resolvedTargets;
    }

    public final void setResolvedTarget(@NotNull Label label, @NotNull Instruction resolvedTarget) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)resolvedTarget, (String)"resolvedTarget");
        Map<Label, Instruction> map = this._resolvedTargets;
        Instruction instruction = this.outgoingEdgeTo(resolvedTarget);
        Intrinsics.checkNotNull((Object)instruction);
        boolean bl = false;
        map.put(label, instruction);
    }

    @NotNull
    public final Instruction getNext() {
        Instruction instruction = this._next;
        Intrinsics.checkNotNull((Object)instruction);
        return instruction;
    }

    public final void setNext(@NotNull Instruction value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this._next = this.outgoingEdgeTo(value2);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        ArrayList<Instruction> targetInstructions = new ArrayList<Instruction>(this.getResolvedTargets().values());
        targetInstructions.add(this.getNext());
        return targetInstructions;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.listOfNotNull((Object)this.inputValue);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitNondeterministicJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitNondeterministicJump(this);
    }

    @NotNull
    public String toString() {
        String inVal = this.inputValue != null ? Intrinsics.stringPlus((String)"|", (Object)this.inputValue) : "";
        String labels2 = CollectionsKt.joinToString$default((Iterable)this.targetLabels, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.labels.1.INSTANCE, (int)30, null);
        return "jmp?(" + labels2 + inVal + ')';
    }

    @Override
    @NotNull
    protected InstructionImpl createCopy() {
        return this.createCopy(this.targetLabels);
    }

    @NotNull
    public final Instruction copy(@NotNull List<Label> newTargetLabels) {
        Intrinsics.checkNotNullParameter(newTargetLabels, (String)"newTargetLabels");
        return this.updateCopyInfo(this.createCopy(newTargetLabels));
    }

    private final InstructionImpl createCopy(List<? extends Label> newTargetLabels) {
        return new NondeterministicJumpInstruction(this.getElement(), newTargetLabels, this.getBlockScope(), this.inputValue);
    }
}

