/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.ProperTrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceTrackingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.common.TrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "CapturedVarDescriptor", "Transformer", "backend"})
public final class CapturedVarsOptimizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new Transformer(internalClassName, methodNode).run();
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010/\u001a\u000200H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\f\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceValueDescriptor;", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "refType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueType", "(Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldInsns", "", "Lorg/jetbrains/org/objectweb/asm/tree/FieldInsnNode;", "getGetFieldInsns", "()Ljava/util/Collection;", "hazard", "", "getHazard", "()Z", "setHazard", "(Z)V", "initCallInsn", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "getInitCallInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "setInitCallInsn", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;)V", "localVar", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getLocalVar", "()Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "setLocalVar", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;)V", "localVarIndex", "", "getLocalVarIndex", "()I", "setLocalVarIndex", "(I)V", "getNewInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "putFieldInsns", "getPutFieldInsns", "getRefType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getValueType", "wrapperInsns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getWrapperInsns", "onUseAsTainted", "", "backend"})
    private static final class CapturedVarDescriptor
    implements ReferenceValueDescriptor {
        @NotNull
        private final TypeInsnNode newInsn;
        @NotNull
        private final Type refType;
        @NotNull
        private final Type valueType;
        private boolean hazard;
        @Nullable
        private MethodInsnNode initCallInsn;
        @Nullable
        private LocalVariableNode localVar;
        private int localVarIndex;
        @NotNull
        private final Collection<AbstractInsnNode> wrapperInsns;
        @NotNull
        private final Collection<FieldInsnNode> getFieldInsns;
        @NotNull
        private final Collection<FieldInsnNode> putFieldInsns;

        public CapturedVarDescriptor(@NotNull TypeInsnNode newInsn, @NotNull Type refType, @NotNull Type valueType) {
            Intrinsics.checkNotNullParameter((Object)newInsn, (String)"newInsn");
            Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.newInsn = newInsn;
            this.refType = refType;
            this.valueType = valueType;
            this.localVarIndex = -1;
            this.wrapperInsns = new LinkedHashSet();
            this.getFieldInsns = new LinkedHashSet();
            this.putFieldInsns = new LinkedHashSet();
        }

        @NotNull
        public final TypeInsnNode getNewInsn() {
            return this.newInsn;
        }

        @NotNull
        public final Type getRefType() {
            return this.refType;
        }

        @NotNull
        public final Type getValueType() {
            return this.valueType;
        }

        public final boolean getHazard() {
            return this.hazard;
        }

        public final void setHazard(boolean bl) {
            this.hazard = bl;
        }

        @Nullable
        public final MethodInsnNode getInitCallInsn() {
            return this.initCallInsn;
        }

        public final void setInitCallInsn(@Nullable MethodInsnNode methodInsnNode) {
            this.initCallInsn = methodInsnNode;
        }

        @Nullable
        public final LocalVariableNode getLocalVar() {
            return this.localVar;
        }

        public final void setLocalVar(@Nullable LocalVariableNode localVariableNode) {
            this.localVar = localVariableNode;
        }

        public final int getLocalVarIndex() {
            return this.localVarIndex;
        }

        public final void setLocalVarIndex(int n) {
            this.localVarIndex = n;
        }

        @NotNull
        public final Collection<AbstractInsnNode> getWrapperInsns() {
            return this.wrapperInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getGetFieldInsns() {
            return this.getFieldInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getPutFieldInsns() {
            return this.putFieldInsns;
        }

        @Override
        public void onUseAsTainted() {
            this.hazard = true;
        }
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J%\u0010\u001a\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\t*\u00020\u0014H\u0002J\f\u0010 \u001a\u00020!*\u00020\u001dH\u0002J\u0014\u0010\"\u001a\u00020\u0010*\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "refValues", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lkotlin/collections/ArrayList;", "refValuesByNewInsn", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "Lkotlin/collections/LinkedHashMap;", "assignLocalVars", "", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "createRefValues", "rewriteRefValue", "capturedVar", "run", "trackPops", "findCleanInstructions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getCapturedVarOrNull", "getIndex", "", "removeOrReplaceByNop", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "insn", "Interpreter", "backend"})
    private static final class Transformer {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final ArrayList<CapturedVarDescriptor> refValues;
        @NotNull
        private final LinkedHashMap<TypeInsnNode, CapturedVarDescriptor> refValuesByNewInsn;

        public Transformer(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.refValues = new ArrayList();
            this.refValuesByNewInsn = new LinkedHashMap();
        }

        public final void run() {
            this.createRefValues();
            if (this.refValues.isEmpty()) {
                return;
            }
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new Interpreter());
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassName, methodNode, Interpreter())");
            Frame<V>[] frames2 = frameArray;
            this.trackPops(frames2);
            this.assignLocalVars(frames2);
            for (CapturedVarDescriptor refValue : this.refValues) {
                if (refValue.getHazard()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)refValue, (String)"refValue");
                this.rewriteRefValue(refValue);
            }
            UtilKt.removeEmptyCatchBlocks(this.methodNode);
            UtilKt.removeUnusedLocalVariables(this.methodNode);
        }

        private final int getIndex(AbstractInsnNode $this$getIndex) {
            return this.methodNode.instructions.indexOf($this$getIndex);
        }

        private final void createRefValues() {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
            Iterator<AbstractInsnNode> iterator2 = UtilKt.asSequence(insnList).iterator();
            while (iterator2.hasNext()) {
                Type type2;
                Object object;
                Type type3;
                AbstractInsnNode insn = iterator2.next();
                if (insn.getOpcode() != 187 || !(insn instanceof TypeInsnNode) || !AsmTypes.isSharedVarType(type3 = Type.getObjectType(((TypeInsnNode)insn).desc)) || (object = CapturedVarsOptimizationMethodTransformerKt.getREF_TYPE_TO_ELEMENT_TYPE().get(type3.getInternalName())) == null) continue;
                Type valueType = type2 = object;
                TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"type");
                CapturedVarDescriptor refValue = new CapturedVarDescriptor(typeInsnNode, type3, valueType);
                this.refValues.add(refValue);
                object = this.refValuesByNewInsn;
                AbstractInsnNode abstractInsnNode = insn;
                boolean bl = false;
                object.put(abstractInsnNode, refValue);
            }
        }

        private final void trackPops(Frame<BasicValue>[] frames2) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
            Iterator<AbstractInsnNode> iterator2 = UtilKt.asSequence(insnList).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                AbstractInsnNode insn = iterator2.next();
                Frame<BasicValue> frame = frames2[i];
                if (frame == null) continue;
                Frame<BasicValue> frame2 = frame;
                int n2 = insn.getOpcode();
                switch (n2) {
                    case 87: {
                        Object object;
                        BasicValue basicValue = StackTransformationUtilsKt.top(frame2);
                        if (basicValue == null || (object = this.getCapturedVarOrNull(basicValue)) == null) break;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object $this$trackPops_u24lambda_u2d0 = object2;
                        boolean bl3 = false;
                        ((CapturedVarDescriptor)$this$trackPops_u24lambda_u2d0).getWrapperInsns().add(insn);
                        break;
                    }
                    case 88: {
                        BasicValue top = StackTransformationUtilsKt.top(frame2);
                        Object object = top;
                        Integer n3 = object == null ? null : Integer.valueOf(((BasicValue)object).getSize());
                        int n4 = 1;
                        if (n3 == null || n3 != n4) break;
                        CapturedVarDescriptor capturedVarDescriptor = this.getCapturedVarOrNull(top);
                        if (capturedVarDescriptor != null) {
                            capturedVarDescriptor.setHazard(true);
                        }
                        Object object2 = StackTransformationUtilsKt.peek(frame2, 1);
                        CapturedVarDescriptor capturedVarDescriptor2 = capturedVarDescriptor = object2 == null ? null : this.getCapturedVarOrNull((BasicValue)object2);
                        if (capturedVarDescriptor == null) break;
                        capturedVarDescriptor.setHazard(true);
                    }
                }
            }
        }

        private final CapturedVarDescriptor getCapturedVarOrNull(BasicValue $this$getCapturedVarOrNull) {
            CapturedVarDescriptor capturedVarDescriptor;
            ProperTrackedReferenceValue properTrackedReferenceValue;
            BasicValue $this$safeAs$iv = $this$getCapturedVarOrNull;
            boolean $i$f$safeAs = false;
            BasicValue basicValue = $this$safeAs$iv;
            if (!(basicValue instanceof ProperTrackedReferenceValue)) {
                basicValue = null;
            }
            if ((properTrackedReferenceValue = (ProperTrackedReferenceValue)basicValue) == null) {
                capturedVarDescriptor = null;
            } else {
                ReferenceValueDescriptor referenceValueDescriptor = properTrackedReferenceValue.getDescriptor();
                if (referenceValueDescriptor == null) {
                    capturedVarDescriptor = null;
                } else {
                    ReferenceValueDescriptor $this$safeAs$iv2 = referenceValueDescriptor;
                    boolean $i$f$safeAs2 = false;
                    ReferenceValueDescriptor referenceValueDescriptor2 = $this$safeAs$iv2;
                    if (!(referenceValueDescriptor2 instanceof CapturedVarDescriptor)) {
                        referenceValueDescriptor2 = null;
                    }
                    capturedVarDescriptor = (CapturedVarDescriptor)referenceValueDescriptor2;
                }
            }
            return capturedVarDescriptor;
        }

        private final void assignLocalVars(Frame<BasicValue>[] frames2) {
            for (LocalVariableNode localVar : this.methodNode.localVariables) {
                Object descriptor2;
                Object refValue;
                ReferenceValueDescriptor referenceValueDescriptor;
                Frame<BasicValue> startFrame;
                Object object;
                Type type2 = Type.getType(localVar.desc);
                if (!AsmTypes.isSharedVarType(type2)) continue;
                Object object2 = localVar.start;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"localVar.start");
                Frame<BasicValue> frame = frames2[this.getIndex((AbstractInsnNode)object2)];
                if (frame == null || (object2 = (object = (startFrame = frame).getLocal(localVar.index)) instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)object : null) == null || (object = (referenceValueDescriptor = ((ProperTrackedReferenceValue)(refValue = object2)).getDescriptor()) instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null) == null || ((CapturedVarDescriptor)(descriptor2 = object)).getHazard()) continue;
                if (((CapturedVarDescriptor)descriptor2).getLocalVar() == null) {
                    ((CapturedVarDescriptor)descriptor2).setLocalVar(localVar);
                    continue;
                }
                ((CapturedVarDescriptor)descriptor2).setHazard(true);
            }
            for (CapturedVarDescriptor refValue : this.refValues) {
                Object object;
                if (refValue.getHazard()) continue;
                if (refValue.getLocalVar() == null || refValue.getValueType().getSize() != 1) {
                    refValue.setLocalVarIndex(this.methodNode.maxLocals);
                    object = this.methodNode;
                    ((MethodNode)object).maxLocals += refValue.getValueType().getSize();
                    continue;
                }
                object = refValue.getLocalVar();
                Intrinsics.checkNotNull((Object)object);
                refValue.setLocalVarIndex(((LocalVariableNode)object).index);
            }
        }

        private final Sequence<AbstractInsnNode> findCleanInstructions(LocalVariableNode $this$findCleanInstructions) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
            return SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)new InsnSequence(insnList), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull AbstractInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$this_findCleanInstructions.start);
                }
            })), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull AbstractInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$this_findCleanInstructions.end);
                }
            })), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull AbstractInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!(it instanceof VarInsnNode)) return false;
                    if (((VarInsnNode)it).getOpcode() != 58) return false;
                    if (((VarInsnNode)it).var != this.$this_findCleanInstructions.index) return false;
                    AbstractInsnNode abstractInsnNode = ((VarInsnNode)it).getPrevious();
                    if (abstractInsnNode == null) {
                        return false;
                    }
                    Integer n = abstractInsnNode.getOpcode();
                    int n2 = 1;
                    if (n == null) return false;
                    if (n != n2) return false;
                    return true;
                }
            }));
        }

        private final void removeOrReplaceByNop(InsnList $this$removeOrReplaceByNop, AbstractInsnNode insn) {
            if (insn.getPrevious() instanceof LineNumberNode && insn.getNext() instanceof LabelNode && insn.getNext().getNext() instanceof LineNumberNode) {
                $this$removeOrReplaceByNop.set(insn, new InsnNode(0));
            } else {
                $this$removeOrReplaceByNop.remove(insn);
            }
        }

        private final void rewriteRefValue(CapturedVarDescriptor capturedVar) {
            AbstractInsnNode it;
            Object $this$none$iv;
            InsnList insnList = this.methodNode.instructions;
            boolean bl = false;
            boolean bl2 = false;
            InsnList $this$rewriteRefValue_u24lambda_u2d5 = insnList;
            boolean bl3 = false;
            int loadOpcode = capturedVar.getValueType().getOpcode(21);
            int storeOpcode = capturedVar.getValueType().getOpcode(54);
            LocalVariableNode localVar = capturedVar.getLocalVar();
            if (localVar != null) {
                boolean bl4;
                block10: {
                    $this$none$iv = capturedVar.getPutFieldInsns();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        Iterator iterator2 = $this$none$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            it = (FieldInsnNode)element$iv;
                            boolean bl5 = false;
                            int n = this.getIndex(it);
                            LabelNode labelNode = localVar.start;
                            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"localVar.start");
                            if (!(n < this.getIndex(labelNode))) continue;
                            bl4 = false;
                            break block10;
                        }
                        bl4 = true;
                    }
                }
                if (bl4) {
                    $this$rewriteRefValue_u24lambda_u2d5.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                    $this$rewriteRefValue_u24lambda_u2d5.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
                }
                for (AbstractInsnNode insn : this.findCleanInstructions(localVar)) {
                    if (storeOpcode == 58) {
                        $this$rewriteRefValue_u24lambda_u2d5.set(insn.getPrevious(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                        continue;
                    }
                    $this$rewriteRefValue_u24lambda_u2d5.remove(insn.getPrevious());
                    $this$rewriteRefValue_u24lambda_u2d5.remove(insn);
                }
                localVar.index = capturedVar.getLocalVarIndex();
                localVar.desc = capturedVar.getValueType().getDescriptor();
                localVar.signature = null;
            }
            $this$rewriteRefValue_u24lambda_u2d5.remove(capturedVar.getNewInsn());
            $this$none$iv = capturedVar.getInitCallInsn();
            Intrinsics.checkNotNull((Object)$this$none$iv);
            $this$rewriteRefValue_u24lambda_u2d5.remove((AbstractInsnNode)$this$none$iv);
            Iterable $this$forEach$iv = capturedVar.getWrapperInsns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$rewriteRefValue_u24lambda_u2d5, (String)"");
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u2d5, it);
            }
            $this$forEach$iv = capturedVar.getGetFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl7 = false;
                $this$rewriteRefValue_u24lambda_u2d5.set(it, new VarInsnNode(loadOpcode, capturedVar.getLocalVarIndex()));
            }
            $this$forEach$iv = capturedVar.getPutFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl8 = false;
                $this$rewriteRefValue_u24lambda_u2d5.set(it, new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
            }
        }

        @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceTrackingInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;)V", "newOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processRefValueUsage", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/common/TrackedReferenceValue;", "position", "", "backend"})
        private final class Interpreter
        extends ReferenceTrackingInterpreter {
            public Interpreter() {
                Intrinsics.checkNotNullParameter((Object)Transformer.this, (String)"this$0");
            }

            @Override
            @NotNull
            public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
                Object object;
                ProperTrackedReferenceValue properTrackedReferenceValue;
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Object object2 = Transformer.this.refValuesByNewInsn;
                boolean bl = false;
                Object object3 = (CapturedVarDescriptor)object2.get(insn);
                if (object3 == null) {
                    properTrackedReferenceValue = null;
                } else {
                    object2 = object3;
                    bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    properTrackedReferenceValue = new ProperTrackedReferenceValue(((CapturedVarDescriptor)it).getRefType(), (ReferenceValueDescriptor)it);
                }
                ProperTrackedReferenceValue properTrackedReferenceValue2 = properTrackedReferenceValue;
                if (properTrackedReferenceValue2 == null) {
                    object3 = super.newOperation(insn);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"super.newOperation(insn)");
                    object = object3;
                } else {
                    object = properTrackedReferenceValue2;
                }
                return object;
            }

            @Override
            protected void processRefValueUsage(@NotNull TrackedReferenceValue value2, @NotNull AbstractInsnNode insn, int position) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                for (ReferenceValueDescriptor descriptor2 : value2.getDescriptors()) {
                    if (!(descriptor2 instanceof CapturedVarDescriptor)) {
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected descriptor: ", (Object)descriptor2));
                    }
                    if (insn.getOpcode() == 89) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 25) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 58) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getGetFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 181 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getPutFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 183 && insn instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)insn).name, (Object)"<init>") && position == 0) {
                        if (((CapturedVarDescriptor)descriptor2).getInitCallInsn() != null && !Intrinsics.areEqual((Object)((CapturedVarDescriptor)descriptor2).getInitCallInsn(), (Object)insn)) {
                            ((CapturedVarDescriptor)descriptor2).setHazard(true);
                            continue;
                        }
                        ((CapturedVarDescriptor)descriptor2).setInitCallInsn((MethodInsnNode)insn);
                        continue;
                    }
                    ((CapturedVarDescriptor)descriptor2).setHazard(true);
                }
            }
        }
    }
}

