/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.comparison;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.range.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.FloatingPointComparisonGeneratorKt;
import org.jetbrains.kotlin.codegen.range.comparison.IntComparisonGeneratorKt;
import org.jetbrains.kotlin.codegen.range.comparison.LongComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.RangeContainsTypeInfo;
import org.jetbrains.kotlin.codegen.range.comparison.UnsignedIntegerComparisonGeneratorKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"getComparisonGeneratorForKotlinType", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getComparisonGeneratorForRangeContainsCall", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "rangeContainsTypeInfo", "Lorg/jetbrains/kotlin/codegen/range/comparison/RangeContainsTypeInfo;", "getRangeContainsTypeInfo", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isPrimitiveIntOrCoercible", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "backend"})
public final class ComparisonGeneratorKt {
    @NotNull
    public static final ComparisonGenerator getComparisonGeneratorForKotlinType(@NotNull KotlinType kotlinType) {
        ComparisonGenerator comparisonGenerator;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        if (KotlinBuiltIns.isChar(kotlinType)) {
            comparisonGenerator = IntComparisonGeneratorKt.getCharComparisonGenerator();
        } else if (KotlinBuiltIns.isByte(kotlinType) || KotlinBuiltIns.isShort(kotlinType) || KotlinBuiltIns.isInt(kotlinType)) {
            comparisonGenerator = IntComparisonGeneratorKt.getIntComparisonGenerator();
        } else if (KotlinBuiltIns.isLong(kotlinType)) {
            comparisonGenerator = LongComparisonGenerator.INSTANCE;
        } else if (KotlinBuiltIns.isFloat(kotlinType)) {
            comparisonGenerator = FloatingPointComparisonGeneratorKt.getFloatComparisonGenerator();
        } else if (KotlinBuiltIns.isDouble(kotlinType)) {
            comparisonGenerator = FloatingPointComparisonGeneratorKt.getDoubleComparisonGenerator();
        } else if (KotlinBuiltIns.isUInt(kotlinType)) {
            comparisonGenerator = UnsignedIntegerComparisonGeneratorKt.getUIntComparisonGenerator();
        } else if (KotlinBuiltIns.isULong(kotlinType)) {
            comparisonGenerator = UnsignedIntegerComparisonGeneratorKt.getULongComparisonGenerator();
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unexpected element type: ", (Object)kotlinType));
        }
        return comparisonGenerator;
    }

    @Nullable
    public static final RangeContainsTypeInfo getRangeContainsTypeInfo(@NotNull ResolvedCall<? extends CallableDescriptor> call2) {
        KotlinType kotlinType;
        Annotated annotated;
        Annotated annotated2;
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        Annotated annotated3 = descriptor2.getExtensionReceiverParameter();
        KotlinType kotlinType3 = kotlinType2 = annotated3 == null ? null : annotated3.getType();
        if (kotlinType2 == null) {
            annotated2 = descriptor2.getDispatchReceiverParameter();
            Annotated annotated4 = annotated3 = annotated2 == null ? null : annotated2.getType();
            if (annotated3 == null) {
                return null;
            }
            annotated = annotated3;
        } else {
            annotated = kotlinType2;
        }
        KotlinType receiverType = kotlinType = annotated;
        kotlinType2 = RangeCodegenUtilKt.getRangeOrProgressionElementType(receiverType);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType elementType = kotlinType2;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        Annotated annotated5 = annotated2 = valueParameterDescriptor == null ? null : valueParameterDescriptor.getType();
        if (annotated2 == null) {
            return null;
        }
        Annotated valueParameterType = annotated3 = annotated2;
        return new RangeContainsTypeInfo(elementType, (KotlinType)valueParameterType);
    }

    @Nullable
    public static final ComparisonGenerator getComparisonGeneratorForRangeContainsCall(@NotNull ExpressionCodegen codegen2, @NotNull RangeContainsTypeInfo rangeContainsTypeInfo) {
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)rangeContainsTypeInfo, (String)"rangeContainsTypeInfo");
        KotlinType elementType = rangeContainsTypeInfo.getRangeElementType();
        KotlinType valueParameterType = rangeContainsTypeInfo.getValueParameterType();
        Type type2 = codegen2.asmType(elementType);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"codegen.asmType(elementType)");
        Type asmElementType = type2;
        Type type3 = codegen2.asmType(valueParameterType);
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"codegen.asmType(valueParameterType)");
        Type asmValueParameterType = type3;
        return Intrinsics.areEqual((Object)asmElementType, (Object)asmValueParameterType) ? ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(elementType) : (KotlinBuiltIns.isUInt(elementType) ? (ComparisonGenerator)(KotlinBuiltIns.isULong(valueParameterType) ? null : UnsignedIntegerComparisonGeneratorKt.getUIntComparisonGenerator()) : (KotlinBuiltIns.isULong(elementType) ? (ComparisonGenerator)UnsignedIntegerComparisonGeneratorKt.getULongComparisonGenerator() : (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmElementType) && ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmValueParameterType) ? (ComparisonGenerator)IntComparisonGeneratorKt.getIntComparisonGenerator() : (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmElementType) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.LONG_TYPE) || ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmValueParameterType) && Intrinsics.areEqual((Object)asmElementType, (Object)Type.LONG_TYPE) ? (ComparisonGenerator)LongComparisonGenerator.INSTANCE : (Intrinsics.areEqual((Object)asmElementType, (Object)Type.FLOAT_TYPE) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.DOUBLE_TYPE) || Intrinsics.areEqual((Object)asmElementType, (Object)Type.DOUBLE_TYPE) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.FLOAT_TYPE) ? (ComparisonGenerator)FloatingPointComparisonGeneratorKt.getDoubleComparisonGenerator() : null)))));
    }

    private static final boolean isPrimitiveIntOrCoercible(Type $this$isPrimitiveIntOrCoercible) {
        return Intrinsics.areEqual((Object)$this$isPrimitiveIntOrCoercible, (Object)Type.INT_TYPE) || Intrinsics.areEqual((Object)$this$isPrimitiveIntOrCoercible, (Object)Type.SHORT_TYPE) || Intrinsics.areEqual((Object)$this$isPrimitiveIntOrCoercible, (Object)Type.BYTE_TYPE);
    }
}

