/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UselessCallOnNotNullChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "triggerOn", "", "", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getCallableId", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "getNullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getPackage", "checkers"})
public final class UselessCallOnNotNullChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final UselessCallOnNotNullChecker INSTANCE = new UselessCallOnNotNullChecker();
    @NotNull
    private static final Set<String> triggerOn;

    private UselessCallOnNotNullChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CallableId callableId = this.getCallableId(expression2);
        if (callableId == null) {
            return;
        }
        CallableId method = callableId;
        FirExpression firExpression2 = expression2.getExplicitReceiver();
        if (firExpression2 == null) {
            return;
        }
        FirExpression calleeOn = firExpression2;
        String calleePackageName = this.getPackage(calleeOn);
        Object object = method.getCallableName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"method.callableName.asString()");
        String calleeName = object;
        if (!triggerOn.contains(calleePackageName + '.' + calleeName)) {
            return;
        }
        if (this.getNullability(calleeOn) == ConeNullability.NOT_NULL) {
            void source$iv;
            object = reporter;
            FirSourceElement firSourceElement = expression2.getSource();
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL();
            boolean $i$f$report = false;
            void var12_12 = source$iv;
            if (var12_12 != null) {
                void $this$report$iv;
                void var13_13 = var12_12;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var13_13;
                boolean bl3 = false;
                $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
            }
        }
    }

    private final CallableId getCallableId(FirQualifiedAccessExpression $this$getCallableId) {
        FirReference firReference = $this$getCallableId.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = abstractFirBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)abstractFirBasedSymbol : null;
        return firNamedFunctionSymbol == null ? null : firNamedFunctionSymbol.getCallableId();
    }

    private final String getPackage(FirExpression $this$getPackage) {
        ConeKotlinType coneKotlinType;
        Object object;
        FirTypeRef firTypeRef = $this$getPackage.getTypeRef();
        Object object2 = object = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (object == null) {
            coneKotlinType = null;
        } else {
            ConeKotlinType coneKotlinType2;
            FirTypeRef $this$coneType$iv = (FirTypeRef)object;
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                coneKotlinType3 = null;
            }
            if ((coneKotlinType2 = coneKotlinType3) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            coneKotlinType = coneKotlinType2;
        }
        ConeKotlinType coneKotlinType4 = coneKotlinType;
        return String.valueOf(coneKotlinType4 == null ? null : ((object = ConeTypeUtilsKt.getClassId(coneKotlinType4)) == null ? null : ((ClassId)object).getPackageFqName()));
    }

    private final ConeNullability getNullability(FirExpression $this$getNullability) {
        return ((FirResolvedTypeRef)$this$getNullability.getTypeRef()).getType().getNullability();
    }

    static {
        Object[] objectArray = new String[]{"kotlin.collections.orEmpty", "kotlin.sequences.orEmpty", "kotlin.text.orEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrBlank", "kotlin.isNullOrBlank", "kotlin.isNullOrEmpty", "kotlin.orEmpty"};
        triggerOn = SetsKt.setOf((Object[])objectArray);
    }
}

