/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u001c\u0010\u0019\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J$\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020\u00170\u001dH\u0016R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirSession;)V", "classifierCache", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "functionCache", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "processClassifiersByNameWithSubstitution", "", "name", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "resolve"})
public final class FirPackageMemberScope
extends FirScope {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final Map<Name, FirClassifierSymbol<?>> classifierCache;
    @NotNull
    private final Map<Name, List<FirNamedFunctionSymbol>> functionCache;
    @NotNull
    private final Map<Name, List<FirPropertySymbol>> propertyCache;

    public FirPackageMemberScope(@NotNull FqName fqName2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.fqName = fqName2;
        this.session = session2;
        this.symbolProvider = MainSessionComponentsKt.getFirSymbolProvider(this.session);
        boolean bl = false;
        this.classifierCache = new LinkedHashMap();
        bl = false;
        this.functionCache = new LinkedHashMap();
        bl = false;
        this.propertyCache = new LinkedHashMap();
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        FirClassifierSymbol symbol2;
        FirClassifierSymbol firClassifierSymbol;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        CharSequence charSequence = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"name.asString()");
        charSequence = charSequence;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        Map<Name, FirClassifierSymbol<?>> $this$getOrPut$iv = this.classifierCache;
        boolean $i$f$getOrPut = false;
        FirClassifierSymbol value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl2 = false;
            ClassId unambiguousFqName = new ClassId(this.getFqName(), name);
            FirClassifierSymbol answer$iv = this.symbolProvider.getClassLikeSymbolByFqName(unambiguousFqName);
            $this$getOrPut$iv.put(name, answer$iv);
            firClassifierSymbol = answer$iv;
        } else {
            firClassifierSymbol = value$iv;
        }
        if ((symbol2 = firClassifierSymbol) != null) {
            processor2.invoke(symbol2, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        List<FirNamedFunctionSymbol> list2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Map<Name, List<FirNamedFunctionSymbol>> $this$getOrPut$iv = this.functionCache;
        boolean $i$f$getOrPut = false;
        List<FirNamedFunctionSymbol> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirNamedFunctionSymbol> answer$iv = this.symbolProvider.getTopLevelFunctionSymbols(this.getFqName(), name);
            $this$getOrPut$iv.put(name, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirNamedFunctionSymbol> symbols2 = list2;
        for (FirNamedFunctionSymbol symbol2 : symbols2) {
            PhaseUtilsKt.ensureResolvedForCalls(symbol2, this.session);
            processor2.invoke((Object)symbol2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        List<FirPropertySymbol> list2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Map<Name, List<FirPropertySymbol>> $this$getOrPut$iv = this.propertyCache;
        boolean $i$f$getOrPut = false;
        List<FirPropertySymbol> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirPropertySymbol> answer$iv = this.symbolProvider.getTopLevelPropertySymbols(this.getFqName(), name);
            $this$getOrPut$iv.put(name, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirPropertySymbol> symbols2 = list2;
        for (FirPropertySymbol symbol2 : symbols2) {
            PhaseUtilsKt.ensureResolvedForCalls(symbol2, this.session);
            processor2.invoke((Object)symbol2);
        }
    }
}

