/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "", "sourceContentResolver", "Lkotlin/Function1;", "", "Ljava/io/Reader;", "(Lkotlin/jvm/functions/Function1;)V", "groups", "", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapGroup;", "getGroups", "()Ljava/util/List;", "getSourceContentResolver", "()Lkotlin/jvm/functions/Function1;", "debug", "", "writer", "Ljava/io/PrintStream;", "debugVerbose", "generatedJsFile", "Ljava/io/File;", "js.parser"})
public final class SourceMap {
    @NotNull
    private final Function1<String, Reader> sourceContentResolver;
    @NotNull
    private final List<SourceMapGroup> groups;

    public SourceMap(@NotNull Function1<? super String, ? extends Reader> sourceContentResolver) {
        Intrinsics.checkNotNullParameter(sourceContentResolver, (String)"sourceContentResolver");
        this.sourceContentResolver = sourceContentResolver;
        boolean bl = false;
        this.groups = new ArrayList();
    }

    @NotNull
    public final Function1<String, Reader> getSourceContentResolver() {
        return this.sourceContentResolver;
    }

    @NotNull
    public final List<SourceMapGroup> getGroups() {
        return this.groups;
    }

    public final void debug(@NotNull PrintStream writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Iterator<SourceMapGroup> iterator2 = this.groups.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            SourceMapGroup group = iterator2.next();
            writer.print("" + (index2 + 1) + ':');
            for (SourceMapSegment segment : group.getSegments()) {
                writer.print("" + ' ' + (segment.getGeneratedColumnNumber() + 1) + ':' + (segment.getSourceLineNumber() + 1) + ',' + (segment.getSourceColumnNumber() + 1));
            }
            writer.println();
        }
    }

    public static /* synthetic */ void debug$default(SourceMap sourceMap2, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"out");
            printStream = printStream2;
        }
        sourceMap2.debug(printStream);
    }

    /*
     * WARNING - void declaration
     */
    public final void debugVerbose(@NotNull PrintStream writer, @NotNull File generatedJsFile) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)generatedJsFile, (String)"generatedJsFile");
        boolean bl = generatedJsFile.exists();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SourceMap$debugVerbose$22 = false;
            String $i$a$-assert-SourceMap$debugVerbose$22 = generatedJsFile + " does not exist!";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SourceMap$debugVerbose$22));
        }
        Collection $this$toTypedArray$iv = FilesKt.readLines$default((File)generatedJsFile, null, (int)1, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] generatedLines = stringArray;
        Iterator<SourceMapGroup> iterator2 = this.groups.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            int index2 = n++;
            SourceMapGroup group = iterator2.next();
            writer.print("" + (index2 + 1) + ':');
            String generatedLine = generatedLines[index2];
            Iterable $this$map$iv = group.getSegments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SourceMapSegment sourceMapSegment = (SourceMapSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)it.getGeneratedColumnNumber(), (Object)it);
                collection.add(pair);
            }
            Map segmentsByColumn = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            int n2 = 0;
            int n3 = generatedLine.length() + -1;
            if (n2 <= n3) {
                do {
                    int i;
                    SourceMapSegment sourceMapSegment;
                    if ((sourceMapSegment = (SourceMapSegment)segmentsByColumn.get(i = n2++)) != null) {
                        SourceMapSegment sourceMapSegment2 = sourceMapSegment;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        SourceMapSegment $dstr$_u24__u24$sourceFile$sourceLine$sourceColumn = sourceMapSegment2;
                        boolean bl6 = false;
                        String sourceFile = $dstr$_u24__u24$sourceFile$sourceLine$sourceColumn.component2();
                        int sourceLine = $dstr$_u24__u24$sourceFile$sourceLine$sourceColumn.component3();
                        int sourceColumn = $dstr$_u24__u24$sourceFile$sourceLine$sourceColumn.component4();
                        writer.print('<' + sourceFile + ':' + (sourceLine + 1) + ':' + (sourceColumn + 1) + '>');
                    }
                    writer.print(generatedLine.charAt(i));
                } while (n2 <= n3);
            }
            writer.println();
        }
    }
}

