/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KTypeConstructor;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "visitedTypeParams", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lkotlin/collections/HashSet;", "callHelperFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "name", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "createDynamicType", "createKClassifier", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "createKType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createKTypeParameter", "typeParameter", "", "createKTypeProjection", "tp", "Lorg/jetbrains/kotlin/types/TypeProjection;", "createSimpleKType", "Lorg/jetbrains/kotlin/types/SimpleType;", "js.translator"})
final class KTypeConstructor {
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final HashSet<TypeParameterDescriptor> visitedTypeParams;

    public KTypeConstructor(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.visitedTypeParams = new HashSet();
    }

    @NotNull
    public final JsInvocation callHelperFunction(@NotNull String name, JsExpression ... arguments2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        JsExpression jsExpression = this.context.getReferenceToIntrinsic(name);
        JsExpression[] jsExpressionArray = new JsExpression[arguments2.length];
        System.arraycopy(arguments2, 0, jsExpressionArray, 0, arguments2.length);
        return new JsInvocation(jsExpression, jsExpressionArray);
    }

    @NotNull
    public final JsExpression createKType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        UnwrappedType unwrappedType = type2.unwrap();
        if (unwrappedType instanceof SimpleType) {
            return this.createSimpleKType((SimpleType)unwrappedType);
        }
        if (unwrappedType instanceof DynamicType) {
            return this.createDynamicType();
        }
        String string2 = Intrinsics.stringPlus((String)"Unexpected type ", (Object)type2);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    private final JsExpression createDynamicType() {
        return this.callHelperFunction("createDynamicKType", new JsExpression[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression createSimpleKType(SimpleType type2) {
        void $this$mapTo$iv$iv;
        JsExpression jsExpression;
        Collection<JsExpression> collection;
        JsExpression jsExpression2;
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor classifier2 = typeConstructor2.getDeclarationDescriptor();
        if (classifier2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)classifier2).isReified()) {
            JsName jsName = this.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.suggestedName)");
            JsName kClassName = jsName;
            MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            JsExpression[] jsExpressionArray = new JsExpression[]{UtilsKt.getReferenceToJsClass(classifier2, this.context)};
            JsInvocation reifiedTypeParameterType = new JsInvocation((JsExpression)kClassName.makeRef(), jsExpressionArray);
            if (type2.isMarkedNullable()) {
                jsExpressionArray = new JsExpression[]{reifiedTypeParameterType};
                return this.callHelperFunction("markKTypeNullable", jsExpressionArray);
            }
            return reifiedTypeParameterType;
        }
        if (classifier2 != null) {
            jsExpression2 = this.createKClassifier(classifier2);
        } else if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv2;
            JsName jsName = this.context.getNameForIntrinsic("getKClassM");
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.getNameForIntrinsic(\"getKClassM\")");
            JsName getKClassM = jsName;
            JsExpression[] $this$map$iv = (JsExpression[])((IntersectionTypeConstructor)typeConstructor2).getSupertypes();
            boolean $i$f$map2 = false;
            JsExpression[] jsExpressionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (TypeProjection item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                KotlinType kotlinType = (KotlinType)((Object)item$iv$iv2);
                collection = destination$iv$iv;
                boolean bl = false;
                jsExpression = UtilsKt.getReferenceToJsClass(it.getConstructor().getDeclarationDescriptor(), this.context);
                collection.add(jsExpression);
            }
            Collection<JsExpression> collection2 = collection = (List)destination$iv$iv;
            JsArrayLiteral args = new JsArrayLiteral((List<JsExpression>)collection2);
            $this$map$iv = new JsExpression[]{args};
            jsExpression2 = new JsInvocation((JsExpression)getKClassM.makeRef(), $this$map$iv);
        } else {
            String getKClassM = Intrinsics.stringPlus((String)"Can't get KClass for ", (Object)type2);
            boolean args = false;
            throw (Throwable)new IllegalStateException(getKClassM.toString());
        }
        JsExpression kClassifier = jsExpression2;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection item$iv$iv2;
            item$iv$iv2 = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            jsExpression = this.createKTypeProjection((TypeProjection)it);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        JsArrayLiteral arguments2 = new JsArrayLiteral(list2);
        JsBooleanLiteral isMarkedNullable = new JsBooleanLiteral(type2.isMarkedNullable());
        JsExpression[] jsExpressionArray = new JsExpression[]{kClassifier, arguments2, isMarkedNullable};
        return this.callHelperFunction("createKType", jsExpressionArray);
    }

    private final JsExpression createKTypeProjection(TypeProjection tp) {
        String string2;
        if (tp.isStarProjection()) {
            return this.callHelperFunction("getStarKTypeProjection", new JsExpression[0]);
        }
        Variance variance = tp.getProjectionKind();
        int n = WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
        switch (n) {
            case 1: {
                string2 = "createInvariantKTypeProjection";
                break;
            }
            case 2: {
                string2 = "createContravariantKTypeProjection";
                break;
            }
            case 3: {
                string2 = "createCovariantKTypeProjection";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String factoryName = string2;
        JsExpression[] jsExpressionArray = tp.getType();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpressionArray, (String)"tp.type");
        JsExpression kType = this.createKType((KotlinType)jsExpressionArray);
        jsExpressionArray = new JsExpression[]{kType};
        return this.callHelperFunction(factoryName, jsExpressionArray);
    }

    private final JsExpression createKClassifier(ClassifierDescriptor classifier2) {
        JsExpression jsExpression;
        ClassifierDescriptor classifierDescriptor = classifier2;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            jsExpression = this.createKTypeParameter((TypeParameterDescriptor)classifier2, (Set<TypeParameterDescriptor>)this.visitedTypeParams);
        } else {
            JsExpression jsExpression2 = ExpressionVisitor.getObjectKClass(this.context, classifier2);
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getObjectKClass(context, classifier)");
            jsExpression = jsExpression2;
        }
        return jsExpression;
    }

    private final JsExpression createKTypeParameter(TypeParameterDescriptor typeParameter, Set<TypeParameterDescriptor> visitedTypeParams) {
        if (visitedTypeParams.contains(typeParameter)) {
            JsInvocation jsInvocation = this.callHelperFunction("getStarKTypeProjection", new JsExpression[0]);
            boolean bl = false;
            boolean bl2 = false;
            JsInvocation it = jsInvocation;
            boolean bl3 = false;
            MetadataProperties.setKTypeWithRecursion(it, true);
            return jsInvocation;
        }
        visitedTypeParams.add(typeParameter);
        JsExpression jsExpression = KTypeConstructor.createKTypeParameter$createKTypeParameterImpl(typeParameter, this);
        boolean bl = false;
        boolean bl4 = false;
        JsExpression it = jsExpression;
        boolean bl5 = false;
        visitedTypeParams.remove(typeParameter);
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsExpression createKTypeParameter$createKTypeParameterImpl(TypeParameterDescriptor $typeParameter, KTypeConstructor this$0) {
        JsStringLiteral jsStringLiteral;
        Collection<JsExpression> collection;
        void $this$mapTo$iv$iv;
        JsStringLiteral name = new JsStringLiteral($typeParameter.getName().asString());
        List<KotlinType> list2 = $typeParameter.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"typeParameter.upperBounds");
        Iterable $this$map$iv = list2;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            JsExpression jsExpression = this$0.createKType((KotlinType)it);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        JsArrayLiteral upperBounds = new JsArrayLiteral(list3);
        Variance $i$f$map22 = $typeParameter.getVariance();
        int n = WhenMappings.$EnumSwitchMapping$0[$i$f$map22.ordinal()];
        switch (n) {
            case 1: {
                jsStringLiteral = new JsStringLiteral("invariant");
                break;
            }
            case 2: {
                jsStringLiteral = new JsStringLiteral("in");
                break;
            }
            case 3: {
                jsStringLiteral = new JsStringLiteral("out");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsStringLiteral variance = jsStringLiteral;
        if ($typeParameter.isReified()) {
            JsExpression[] jsExpressionArray = this$0.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkNotNullExpressionValue((Object)jsExpressionArray, (String)"context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.suggestedName)");
            JsExpression[] kClassName = jsExpressionArray;
            MetadataProperties.setSpecialFunction((JsName)kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            jsExpressionArray = new JsExpression[]{UtilsKt.getReferenceToJsClass($typeParameter, this$0.context)};
            return new JsInvocation((JsExpression)kClassName.makeRef(), jsExpressionArray);
        }
        JsExpression[] jsExpressionArray = new JsExpression[]{name, upperBounds, variance};
        return this$0.callHelperFunction("createKTypeParameter", jsExpressionArray);
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

