/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefComparator;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterComparator;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "Lkotlin/Comparator;", "()V", "compare", "", "a", "b", "tree"})
public final class FirCallableMemberDeclarationComparator
implements Comparator<FirCallableMemberDeclaration<?>> {
    @NotNull
    public static final FirCallableMemberDeclarationComparator INSTANCE = new FirCallableMemberDeclarationComparator();

    private FirCallableMemberDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirCallableMemberDeclaration<?> a, @NotNull FirCallableMemberDeclaration<?> b) {
        int typeParameterSizeDiff;
        int returnTypeDiff;
        boolean bl;
        int bHasReceiverType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        int typeAndNameDiff = FirMemberDeclarationComparator.TypeAndNameComparator.INSTANCE.compare(a, b);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        if (a.getReceiverTypeRef() != null || b.getReceiverTypeRef() != null) {
            int aHasReceiverType = a.getReceiverTypeRef() != null ? 1 : 0;
            int receiverTypePresenceDiff = aHasReceiverType - (bHasReceiverType = b.getReceiverTypeRef() != null ? 1 : 0);
            if (receiverTypePresenceDiff != 0) {
                return receiverTypePresenceDiff;
            }
            bl = a.getReceiverTypeRef() != null && b.getReceiverTypeRef() != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
        }
        if ((returnTypeDiff = FirTypeRefComparator.INSTANCE.compare(a.getReturnTypeRef(), b.getReturnTypeRef())) != 0) {
            return returnTypeDiff;
        }
        if (a instanceof FirFunction) {
            bHasReceiverType = b instanceof FirFunction;
            boolean bl5 = false;
            bl = false;
            if (bHasReceiverType == 0) {
                boolean bl6 = false;
                String string3 = "TypeAndNameComparator is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            int valueParameterSizeDiff = ((FirFunction)((Object)a)).getValueParameters().size() - ((FirFunction)((Object)b)).getValueParameters().size();
            if (valueParameterSizeDiff != 0) {
                return valueParameterSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirFunction)((Object)a)).getValueParameters(), (Iterable)((FirFunction)((Object)b)).getValueParameters())) {
                FirValueParameter bValueParameter;
                FirValueParameter aValueParameter = (FirValueParameter)pair.component1();
                int valueParameterDiff = FirValueParameterComparator.INSTANCE.compare(aValueParameter, bValueParameter = (FirValueParameter)pair.component2());
                if (valueParameterDiff == 0) continue;
                return valueParameterDiff;
            }
        }
        if ((typeParameterSizeDiff = a.getTypeParameters().size() - b.getTypeParameters().size()) != 0) {
            return typeParameterSizeDiff;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)a.getTypeParameters(), (Iterable)b.getTypeParameters())) {
            FirTypeParameterRef bTypeParameter;
            FirTypeParameterRef aTypeParameter = (FirTypeParameterRef)pair.component1();
            int typeParameterDiff = FirTypeParameterRefComparator.INSTANCE.compare(aTypeParameter, bTypeParameter = (FirTypeParameterRef)pair.component2());
            if (typeParameterDiff == 0) continue;
            return typeParameterDiff;
        }
        String string4 = a.getSymbol().getCallableId().getPackageName().asString();
        String string5 = b.getSymbol().getCallableId().getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"b.symbol.callableId.packageName.asString()");
        return string4.compareTo(string5);
    }
}

