/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "resolvedVariable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkInitializer", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "initializer", "checkers"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        FirElement firElement2;
        FirPureAbstractElement iterator2;
        Object object;
        FirComponentCall firComponentCall;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            boolean bl = declaration2.getName().isSpecial() && Intrinsics.areEqual((Object)declaration2.getName().asString(), (Object)"<destruct>");
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FirDestructuringDeclarationChecker$check$22 = false;
                String $i$a$-assert-FirDestructuringDeclarationChecker$check$22 = "Unexpected name: " + declaration2.getName().asString() + " for destructuring declaration";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FirDestructuringDeclarationChecker$check$22));
            }
            this.checkInitializer(source, declaration2.getInitializer(), reporter);
            return;
        }
        if (!Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirPureAbstractElement $i$a$-assert-FirDestructuringDeclarationChecker$check$22 = declaration2.getInitializer();
        FirComponentCall firComponentCall2 = firComponentCall = $i$a$-assert-FirDestructuringDeclarationChecker$check$22 instanceof FirComponentCall ? (FirComponentCall)$i$a$-assert-FirDestructuringDeclarationChecker$check$22 : null;
        if (firComponentCall == null) {
            return;
        }
        FirComponentCall componentCall = firComponentCall;
        FirPureAbstractElement firPureAbstractElement = componentCall.getCalleeReference();
        FirPureAbstractElement firPureAbstractElement2 = $i$a$-assert-FirDestructuringDeclarationChecker$check$22 = firPureAbstractElement instanceof FirErrorNamedReference ? (FirErrorNamedReference)firPureAbstractElement : null;
        if ($i$a$-assert-FirDestructuringDeclarationChecker$check$22 == null) {
            return;
        }
        FirPureAbstractElement reference = $i$a$-assert-FirDestructuringDeclarationChecker$check$22;
        firPureAbstractElement = this.getExplicitReceiverOfQualifiedAccess(componentCall);
        if (firPureAbstractElement == null) {
            return;
        }
        FirPureAbstractElement originalExpression = firPureAbstractElement;
        FirVariable<?> firVariable = this.getResolvedVariable((FirQualifiedAccessExpression)originalExpression);
        if (firVariable == null) {
            return;
        }
        FirVariable<?> originalDestructuringDeclaration = firVariable;
        Object object2 = originalDestructuringDeclaration;
        if (object2 instanceof FirProperty) {
            FirExpression firExpression2;
            FirExpression firExpression3 = originalDestructuringDeclaration.getInitializer();
            if (Intrinsics.areEqual(firExpression3 == null ? null : ((object = firExpression3.getSource()) == null ? null : ((FirSourceElement)object).getElementType()), (Object)KtNodeTypes.FOR)) {
                object = originalDestructuringDeclaration.getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression = iterator2 = object == null ? null : this.getExplicitReceiverOfQualifiedAccess((FirExpression)object);
                FirPureAbstractElement firPureAbstractElement3 = firQualifiedAccessExpression == null ? null : this.getResolvedVariable(firQualifiedAccessExpression);
                Object object3 = object = firPureAbstractElement3 instanceof FirProperty ? (FirProperty)firPureAbstractElement3 : null;
                firExpression2 = object == null ? null : ((firPureAbstractElement3 = ((FirProperty)object).getInitializer()) == null ? null : this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement3));
            } else {
                firExpression2 = originalDestructuringDeclaration.getInitializer();
            }
            firElement2 = firExpression2;
        } else {
            firElement2 = firElement = object2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        object2 = ((FirPureAbstractElement)originalDestructuringDeclarationOrInitializer).getSource();
        if (object2 == null) {
            return;
        }
        FirVariable<?> originalDestructuringDeclarationOrInitializerSource = object2;
        object = originalDestructuringDeclarationOrInitializer;
        FirPureAbstractElement firPureAbstractElement4 = object instanceof FirVariable ? ((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef() : (iterator2 = object instanceof FirExpression ? ((FirExpression)originalDestructuringDeclarationOrInitializer).getTypeRef() : null);
        if (iterator2 == null) {
            return;
        }
        FirPureAbstractElement originalDestructuringDeclarationType = iterator2;
        ConeDiagnostic diagnostic = ((FirErrorNamedReference)reference).getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedNameError) {
            reporter.report((FirDiagnostic)FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING().on((FirSourceElement)((Object)originalDestructuringDeclarationOrInitializerSource), ((ConeUnresolvedNameError)diagnostic).getName(), (FirTypeRef)originalDestructuringDeclarationType));
        } else if (diagnostic instanceof ConeAmbiguityError) {
            reporter.report((FirDiagnostic)FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY().on((FirSourceElement)((Object)originalDestructuringDeclarationOrInitializerSource), ((ConeAmbiguityError)diagnostic).getName(), ((ConeAmbiguityError)diagnostic).getCandidates()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInitializer(FirSourceElement source, FirExpression initializer2, DiagnosticReporter reporter) {
        boolean needToReport;
        ConeDiagnostic coneDiagnostic;
        ConeSimpleDiagnostic coneSimpleDiagnostic;
        Object object = initializer2;
        boolean bl = object == null ? true : (object instanceof FirErrorExpression ? ((coneSimpleDiagnostic = (coneDiagnostic = ((FirErrorExpression)initializer2).getDiagnostic()) instanceof ConeSimpleDiagnostic ? (ConeSimpleDiagnostic)coneDiagnostic : null) == null ? null : coneSimpleDiagnostic.getKind()) == DiagnosticKind.Syntax : (needToReport = false));
        if (needToReport) {
            object = reporter;
            FirDiagnosticFactory0<FirSourceElement, KtDestructuringDeclaration> factory$iv = FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement = source;
            if (firSourceElement != null) {
                void $this$report$iv;
                FirSourceElement firSourceElement2 = firSourceElement;
                boolean bl2 = false;
                boolean bl3 = false;
                FirSourceElement it$iv = firSourceElement2;
                boolean bl4 = false;
                $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
            }
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression2;
        FirQualifiedAccess firQualifiedAccess;
        FirQualifiedAccess firQualifiedAccess2 = firQualifiedAccess = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccess ? (FirQualifiedAccess)((Object)$this$explicitReceiverOfQualifiedAccess) : null;
        FirExpression firExpression3 = firQualifiedAccess == null ? null : ((firExpression2 = firQualifiedAccess.getExplicitReceiver()) == null ? null : this.getUnwrapped(firExpression2));
        return firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression2 = $this$unwrapped;
        return firExpression2 instanceof FirExpressionWithSmartcast ? (FirExpression)((FirExpressionWithSmartcast)$this$unwrapped).getOriginalExpression() : (firExpression2 instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable<?> getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirReference firReference = $this$resolvedVariable.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirVariableSymbol firVariableSymbol = abstractFirBasedSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)abstractFirBasedSymbol : null;
        Object var2_6 = firVariableSymbol == null ? null : firVariableSymbol.getFir();
        return var2_6 instanceof FirVariable ? (FirVariable)var2_6 : null;
    }
}

