/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "()V", "classFileName", "", "jClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "SERVICE", "frontend.java"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    @NotNull
    public static final SERVICE SERVICE = new SERVICE(null);

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        VirtualFile virtualFile2 = this.findVirtualFileWithHeader(classId);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file2, null, 2, null);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        VirtualFileBoundJavaClass virtualFileBoundJavaClass = javaClass instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)javaClass : null;
        VirtualFile virtualFile3 = virtualFile2 = virtualFileBoundJavaClass == null ? null : virtualFileBoundJavaClass.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (javaClass.getOuterClass() != null) {
            virtualFile2 = file2.getParent();
            Intrinsics.checkNotNull((Object)virtualFile2);
            VirtualFile $this$sure$iv = virtualFile2.findChild(Intrinsics.stringPlus((String)this.classFileName(javaClass), (Object)".class"));
            boolean $i$f$sure = false;
            VirtualFile virtualFile4 = $this$sure$iv;
            if (virtualFile4 == null) {
                String string2;
                boolean bl = false;
                String string3 = string2 = Intrinsics.stringPlus((String)"Virtual file not found for ", (Object)javaClass);
                throw new AssertionError((Object)string3);
            }
            file2 = virtualFile4;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file2, null, 2, null);
    }

    private final String classFileName(JavaClass jClass) {
        String string2 = jClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jClass.name.asString()");
        String simpleName = string2;
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            return simpleName;
        }
        JavaClass outerClass2 = javaClass;
        return this.classFileName(outerClass2) + '$' + simpleName;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "frontend.java"})
    public static final class SERVICE {
        private SERVICE() {
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return VirtualFileFinderFactory.SERVICE.getInstance(project).create(project, module2);
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            return virtualFileFinderFactory.create(globalSearchScope);
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

