/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower.inlineclasses;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbi;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a\n\u0010\u001c\u001a\u00020\u0014*\u00020\u0014\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0007*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\"\u0015\u0010\u0012\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\"\u0015\u0010\u0013\u001a\u00020\u0007*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\"\u0018\u0010\u0017\u001a\u00020\u0007*\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015\"\u0018\u0010\u0019\u001a\u00020\u0002*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"fullValueParameterList", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFullValueParameterList", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/util/List;", "hasMangledParameters", "", "getHasMangledParameters", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "hasMangledReturnType", "getHasMangledReturnType", "inlineClassFieldName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassFieldName", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/name/Name;", "isInlineCallableReference", "isInlineClassFieldGetter", "isMappedToPrimitive", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "isPrimaryInlineClassConstructor", "requiresMangling", "getRequiresMangling", "singlePrimaryConstructorParameter", "getSinglePrimaryConstructorParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "unboxInlineClass", "backend.jvm"})
public final class InlineClassAbiKt {
    @NotNull
    public static final IrType unboxInlineClass(@NotNull IrType $this$unboxInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$unboxInlineClass, (String)"<this>");
        IrType irType = InlineClassAbi.INSTANCE.unboxType$backend_jvm($this$unboxInlineClass);
        return irType == null ? $this$unboxInlineClass : irType;
    }

    public static final boolean getRequiresMangling(@NotNull IrType $this$requiresMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$requiresMangling, (String)"<this>");
        IrClass irClass2 = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getErasedUpperBound($this$requiresMangling);
        return irClass2.isInline() && !Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(irClass2), (Object)StandardNames.RESULT_FQ_NAME);
    }

    @NotNull
    public static final List<IrValueParameter> getFullValueParameterList(@NotNull IrFunction $this$fullValueParameterList) {
        Intrinsics.checkNotNullParameter((Object)$this$fullValueParameterList, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)$this$fullValueParameterList.getExtensionReceiverParameter()), (Iterable)$this$fullValueParameterList.getValueParameters());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasMangledParameters(@NotNull IrFunction $this$hasMangledParameters) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasMangledParameters, (String)"<this>");
        if ($this$hasMangledParameters.getDispatchReceiverParameter() != null) {
            if (IrUtilsKt.getParentAsClass($this$hasMangledParameters).isInline()) return true;
        }
        Iterable $this$any$iv = InlineClassAbiKt.getFullValueParameterList($this$hasMangledParameters);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                if (!InlineClassAbiKt.getRequiresMangling(it.getType())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!($this$hasMangledParameters instanceof IrConstructor)) return false;
        if (!AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$hasMangledParameters).isInline()) return false;
        return true;
    }

    public static final boolean getHasMangledReturnType(@NotNull IrFunction $this$hasMangledReturnType) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)$this$hasMangledReturnType, (String)"<this>");
        return org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isInlineClassType($this$hasMangledReturnType.getReturnType()) && !Intrinsics.areEqual((Object)((irClass2 = IrUtilsKt.getParentClassOrNull($this$hasMangledReturnType)) == null ? null : Boolean.valueOf(IrUtilsKt.isFileClass(irClass2))), (Object)true);
    }

    private static final IrValueParameter getSinglePrimaryConstructorParameter(IrClass $this$singlePrimaryConstructorParameter) {
        boolean bl = $this$singlePrimaryConstructorParameter.isInline();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an inline class: " + RenderIrElementKt.render($this$singlePrimaryConstructorParameter) + ' ';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrDeclarationBase irDeclarationBase = IrUtilsKt.getPrimaryConstructor($this$singlePrimaryConstructorParameter);
        if (irDeclarationBase == null) {
            String string3 = Intrinsics.stringPlus((String)"Inline class has no primary constructor: ", (Object)RenderIrElementKt.render($this$singlePrimaryConstructorParameter));
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        IrConstructor primaryConstructor2 = irDeclarationBase;
        if ((irDeclarationBase = (IrValueParameter)CollectionsKt.singleOrNull(primaryConstructor2.getValueParameters())) == null) {
            String string4 = Intrinsics.stringPlus((String)"Inline class primary constructor should have one parameter: ", (Object)RenderIrElementKt.render(primaryConstructor2));
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        return irDeclarationBase;
    }

    @NotNull
    public static final Name getInlineClassFieldName(@NotNull IrClass $this$inlineClassFieldName) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineClassFieldName, (String)"<this>");
        return InlineClassAbiKt.getSinglePrimaryConstructorParameter($this$inlineClassFieldName).getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineClassFieldGetter(@NotNull IrFunction $this$isInlineClassFieldGetter) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassFieldGetter, (String)"<this>");
        Object object = $this$isInlineClassFieldGetter.getParent();
        Object object2 = object instanceof IrClass ? (IrClass)object : null;
        if (!Intrinsics.areEqual((Object)(object2 == null ? null : Boolean.valueOf(((IrClass)object2).isInline())), (Object)true)) return false;
        if (!($this$isInlineClassFieldGetter instanceof IrSimpleFunction)) return false;
        if ($this$isInlineClassFieldGetter.getExtensionReceiverParameter() != null) return false;
        object2 = ((IrSimpleFunction)$this$isInlineClassFieldGetter).getCorrespondingPropertySymbol();
        if (object2 == null) {
            bl = null;
        } else {
            object = object2;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            bl = Intrinsics.areEqual((Object)((IrProperty)it.getOwner()).getGetter(), (Object)$this$isInlineClassFieldGetter) && Intrinsics.areEqual((Object)((IrProperty)it.getOwner()).getName(), (Object)InlineClassAbiKt.getInlineClassFieldName(IrUtilsKt.getParentAsClass($this$isInlineClassFieldGetter)));
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        return true;
    }

    public static final boolean isPrimaryInlineClassConstructor(@NotNull IrFunction $this$isPrimaryInlineClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimaryInlineClassConstructor, (String)"<this>");
        return $this$isPrimaryInlineClassConstructor instanceof IrConstructor && ((IrConstructor)$this$isPrimaryInlineClassConstructor).isPrimary() && AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$isPrimaryInlineClassConstructor).isInline();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineCallableReference(@NotNull IrFunction $this$isInlineCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineCallableReference, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isInlineCallableReference.getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE)) return false;
        String string2 = $this$isInlineCallableReference.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"$stub_for_inlining", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isMappedToPrimitive(@NotNull IrType $this$isMappedToPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$isMappedToPrimitive, (String)"<this>");
        return org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isInlineClassType($this$isMappedToPrimitive) && (!IrTypeUtilsKt.isNullable($this$isMappedToPrimitive) || !IrTypeUtilsKt.isNullable(InlineClassAbiKt.unboxInlineClass(IrTypesKt.makeNotNull($this$isMappedToPrimitive)))) && IrTypePredicatesKt.isPrimitiveType$default(InlineClassAbiKt.unboxInlineClass(IrTypesKt.makeNotNull($this$isMappedToPrimitive)), false, 1, null);
    }

    public static final /* synthetic */ IrValueParameter access$getSinglePrimaryConstructorParameter(IrClass $receiver) {
        return InlineClassAbiKt.getSinglePrimaryConstructorParameter($receiver);
    }
}

